/*
 * Decompiled with CFR 0.152.
 */
package org.onlab.packet.pim;

import java.nio.ByteBuffer;
import org.onlab.packet.DeserializationException;
import org.onlab.packet.Ip6Address;
import org.onlab.packet.IpAddress;
import org.onlab.packet.IpPrefix;
import org.onlab.packet.PacketUtils;

public class PIMAddrGroup {
    private byte family;
    private byte encType;
    private byte reserved;
    private boolean bBit;
    private boolean zBit;
    private byte masklen;
    IpAddress addr;
    public static final int ENC_GROUP_IPV4_BYTE_LENGTH = 8;
    public static final int ENC_GROUP_IPV6_BYTE_LENGTH = 20;

    public PIMAddrGroup() {
        this.family = (byte)4;
        this.encType = 0;
        this.reserved = 0;
        this.bBit = false;
        this.zBit = false;
    }

    public PIMAddrGroup(String addr) {
        this.setAddr(addr);
    }

    public PIMAddrGroup(IpPrefix gpfx) {
        this.setAddr(gpfx);
    }

    public void setAddr(String addr) {
        this.setAddr(IpPrefix.valueOf(addr));
    }

    public void setAddr(IpPrefix pfx) {
        this.addr = pfx.address();
        this.masklen = (byte)pfx.prefixLength();
        this.family = (byte)(this.addr.isIp4() ? 4 : 6);
    }

    public int getFamily() {
        return this.family;
    }

    public IpAddress getAddr() {
        return this.addr;
    }

    public int getMasklen() {
        return this.masklen;
    }

    public boolean getZBit() {
        return this.zBit;
    }

    public boolean getBBit() {
        return this.bBit;
    }

    public int getByteSize() {
        int size = 4;
        return size += this.addr.isIp4() ? 4 : 16;
    }

    public byte[] serialize() {
        int len = this.getByteSize();
        byte[] data = new byte[len];
        ByteBuffer bb = ByteBuffer.wrap(data);
        bb.put(this.family);
        bb.put(this.encType);
        bb.put(this.reserved);
        bb.put(this.masklen);
        bb.put(this.addr.toOctets());
        return data;
    }

    public PIMAddrGroup deserialize(ByteBuffer bb) throws DeserializationException {
        PacketUtils.checkInput(bb.array(), bb.position(), bb.limit() - bb.position(), 8);
        this.family = bb.get();
        if (this.family != 4 && this.family != 6) {
            throw new DeserializationException("Illegal IP version number: " + this.family + "\n");
        }
        if (this.family == 6) {
            PacketUtils.checkInput(bb.array(), bb.position(), bb.limit() - bb.position(), 19);
        }
        this.encType = bb.get();
        this.reserved = bb.get();
        if ((this.reserved & 0x80) != 0) {
            this.bBit = true;
        }
        if ((this.reserved & 1) != 0) {
            this.zBit = true;
        }
        this.reserved = (byte)(this.reserved | 0x7D);
        this.masklen = bb.get();
        if (this.family == 4) {
            this.addr = IpAddress.valueOf(bb.getInt());
        } else if (this.family == 6) {
            this.addr = Ip6Address.valueOf(bb.array(), 2);
        }
        return this;
    }

    public int hashCode() {
        int prime = 2521;
        int result = super.hashCode();
        result = 2521 * result + this.family;
        result = 2521 * result + this.encType;
        result = 2521 * result + this.reserved;
        result = 2521 * result + this.masklen;
        result = 2521 * result + this.addr.hashCode();
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof PIMAddrGroup)) {
            return false;
        }
        PIMAddrGroup other = (PIMAddrGroup)obj;
        if (this.family != this.family) {
            return false;
        }
        if (this.encType != other.encType) {
            return false;
        }
        return this.addr.equals(other.addr);
    }
}

