/*
 * Decompiled with CFR 0.152.
 */
package org.onlab.packet.pim;

import java.nio.ByteBuffer;
import org.onlab.packet.DeserializationException;
import org.onlab.packet.Ip6Address;
import org.onlab.packet.IpAddress;
import org.onlab.packet.IpPrefix;
import org.onlab.packet.PacketUtils;

public class PIMAddrSource {
    private byte family;
    private byte encType;
    private byte reserved;
    private boolean sBit;
    private boolean wBit;
    private boolean rBit;
    private byte masklen;
    IpAddress addr;
    public static final int ENC_SOURCE_IPV4_BYTE_LENGTH = 8;
    public static final int ENC_SOURCE_IPV6_BYTE_LENGTH = 20;

    public PIMAddrSource(String addr) {
        this.init();
        this.setAddr(addr);
    }

    public PIMAddrSource(IpPrefix spfx) {
        this.init();
        this.setAddr(spfx);
    }

    public PIMAddrSource() {
        this.init();
    }

    private void init() {
        this.family = (byte)4;
        this.encType = 0;
        this.reserved = 0;
        this.sBit = true;
        this.wBit = false;
        this.rBit = false;
    }

    public void setAddr(String addr) {
        IpPrefix spfx = IpPrefix.valueOf(addr);
        this.setAddr(spfx);
    }

    public void setAddr(IpPrefix spfx) {
        this.addr = spfx.address();
        this.masklen = (byte)spfx.prefixLength();
        this.family = (byte)(this.addr.isIp4() ? 4 : 6);
    }

    public byte getFamily() {
        return this.family;
    }

    public IpAddress getAddr() {
        return this.addr;
    }

    public int getMasklen() {
        return this.masklen;
    }

    public boolean getSBit() {
        return this.sBit;
    }

    public boolean getWBit() {
        return this.wBit;
    }

    public boolean getRBit() {
        return this.rBit;
    }

    public int getByteSize() {
        int size = 4;
        return size += this.addr.isIp4() ? 4 : 16;
    }

    public byte[] serialize() {
        int len = this.addr.isIp4() ? 8 : 20;
        byte[] data = new byte[len];
        ByteBuffer bb = ByteBuffer.wrap(data);
        bb.put(this.family);
        bb.put(this.encType);
        boolean mask = false;
        if (this.sBit) {
            this.reserved = (byte)(this.reserved | 4);
        }
        if (this.wBit) {
            this.reserved = (byte)(this.reserved | 2);
        }
        if (this.rBit) {
            this.reserved = (byte)(this.reserved | 1);
        }
        bb.put(this.reserved);
        bb.put(this.masklen);
        bb.put(this.addr.toOctets());
        return data;
    }

    public PIMAddrSource deserialize(byte[] data, int offset, int length) throws DeserializationException {
        ByteBuffer bb = ByteBuffer.wrap(data, offset, length);
        return this.deserialize(bb);
    }

    public PIMAddrSource deserialize(ByteBuffer bb) throws DeserializationException {
        PacketUtils.checkInput(bb.array(), bb.position(), bb.limit() - bb.position(), 8);
        this.family = bb.get();
        if (this.family != 4 && this.family != 6) {
            throw new DeserializationException("Illegal IP version number: " + this.family + "\n");
        }
        if (this.family == 6) {
            PacketUtils.checkInput(bb.array(), bb.position(), bb.limit() - bb.position(), 19);
        }
        this.encType = bb.get();
        this.reserved = bb.get();
        if ((this.reserved & 1) != 0) {
            this.rBit = true;
        }
        if ((this.reserved & 2) != 0) {
            this.wBit = true;
        }
        if ((this.reserved & 4) != 0) {
            this.sBit = true;
        }
        this.reserved = (byte)(this.reserved & 0xF8);
        this.masklen = bb.get();
        if (this.family == 4) {
            this.addr = IpAddress.valueOf(bb.getInt());
        } else if (this.family == 6) {
            this.addr = Ip6Address.valueOf(bb.array(), 2);
        }
        return this;
    }

    public int hashCode() {
        int prime = 2521;
        int result = super.hashCode();
        result = 2521 * result + this.family;
        result = 2521 * result + this.encType;
        result = 2521 * result + this.reserved;
        result = 2521 * result + this.masklen;
        result = 2521 * result + this.addr.hashCode();
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof PIMAddrSource)) {
            return false;
        }
        PIMAddrSource other = (PIMAddrSource)obj;
        if (this.family != this.family) {
            return false;
        }
        if (this.encType != other.encType) {
            return false;
        }
        return this.addr.equals(other.addr);
    }
}

