/*
 * Decompiled with CFR 0.152.
 */
package org.onlab.packet.pim;

import java.nio.ByteBuffer;
import java.util.Random;
import org.onlab.packet.BasePacket;
import org.onlab.packet.Deserializer;
import org.onlab.packet.IPacket;
import org.onlab.packet.IpAddress;
import org.onlab.packet.PacketUtils;

public class PIMHello
extends BasePacket {
    private IpAddress nbrIpAddress;
    private int holdtime = 105;
    private int genid = 0;
    private int priority = 1;
    private boolean priorityPresent = false;
    public static final int MINIMUM_OPTION_LEN_BYTES = 4;

    public void addHoldtime(int holdtime) {
        this.holdtime = holdtime;
    }

    public void addPriority(int priority) {
        this.priority = priority;
        this.priorityPresent = true;
    }

    public void addGenId(int genid) {
        if (genid == 0) {
            this.addGenId();
        } else {
            this.genid = genid;
        }
    }

    public void addGenId() {
        Random rand = new Random();
        this.genid = rand.nextInt();
    }

    @Override
    public byte[] serialize() {
        int size = Option.PRIORITY.optLen() + 4 + Option.GENID.optLen() + 4 + Option.HOLDTIME.optLen() + 4;
        byte[] data = new byte[size];
        ByteBuffer bb = ByteBuffer.wrap(data);
        bb.putShort((short)Option.PRIORITY.optType);
        bb.putShort((short)Option.PRIORITY.optLen);
        bb.putInt(this.priority);
        bb.putShort((short)Option.GENID.optType);
        bb.putShort((short)Option.GENID.optLen);
        bb.putInt(this.genid);
        bb.putShort((short)Option.HOLDTIME.optType);
        bb.putShort((short)Option.HOLDTIME.optLen);
        bb.putShort((short)this.holdtime);
        return data;
    }

    @Override
    public IPacket deserialize(byte[] data, int offset, int length) {
        return null;
    }

    public static Deserializer<PIMHello> deserializer() {
        return (data, offset, length) -> {
            PacketUtils.checkInput(data, offset, length, 4);
            ByteBuffer bb = ByteBuffer.wrap(data, offset, length);
            PIMHello hello = new PIMHello();
            while (bb.hasRemaining()) {
                short optType = bb.getShort();
                short optLen = bb.getShort();
                PacketUtils.checkInput(data, bb.position(), bb.limit() - bb.position(), optLen);
                if (optType == Option.GENID.optType) {
                    hello.addGenId(bb.getInt());
                    continue;
                }
                if (optType == Option.PRIORITY.optType) {
                    hello.addPriority(bb.getInt());
                    continue;
                }
                if (optType != Option.HOLDTIME.optType) continue;
                hello.addHoldtime(bb.getShort());
            }
            return hello;
        };
    }

    public static enum Option {
        HOLDTIME(1, 2),
        PRUNEDELAY(2, 4),
        PRIORITY(19, 4),
        GENID(20, 4),
        ADDRLIST(24, 0);

        private final int optType;
        private final int optLen;

        private Option(int ot, int ol) {
            this.optType = ot;
            this.optLen = ol;
        }

        public int optType() {
            return this.optType;
        }

        public int optLen() {
            return this.optLen;
        }
    }
}

