/*
 * Decompiled with CFR 0.152.
 */
package org.onlab.graph;

import com.google.common.collect.ImmutableSet;
import java.text.DecimalFormat;
import java.util.HashSet;
import java.util.Set;
import org.junit.Assert;
import org.junit.Test;
import org.onlab.graph.AbstractGraphPathSearch;
import org.onlab.graph.AdjacencyListsGraph;
import org.onlab.graph.BreadthFirstSearchTest;
import org.onlab.graph.DijkstraGraphSearch;
import org.onlab.graph.EdgeWeight;
import org.onlab.graph.Graph;
import org.onlab.graph.GraphPathSearch;
import org.onlab.graph.Path;
import org.onlab.graph.TestEdge;
import org.onlab.graph.TestVertex;
import org.onlab.graph.Vertex;

public class DijkstraGraphSearchTest
extends BreadthFirstSearchTest {
    @Override
    protected AbstractGraphPathSearch<TestVertex, TestEdge> graphSearch() {
        return new DijkstraGraphSearch();
    }

    @Override
    @Test
    public void defaultGraphTest() {
        this.executeDefaultTest(7, 5, 5.0);
    }

    @Override
    @Test
    public void defaultHopCountWeight() {
        this.weight = null;
        this.executeDefaultTest(10, 3, 3.0);
    }

    @Test
    public void noPath() {
        this.graph = new AdjacencyListsGraph((Set)ImmutableSet.of((Object)A, (Object)B, (Object)C, (Object)D), (Set)ImmutableSet.of((Object)((Object)new TestEdge(A, B, 1.0)), (Object)((Object)new TestEdge(B, A, 1.0)), (Object)((Object)new TestEdge(C, D, 1.0)), (Object)((Object)new TestEdge(D, C, 1.0))));
        AbstractGraphPathSearch<TestVertex, TestEdge> gs = this.graphSearch();
        Set paths = gs.search(this.graph, (Vertex)A, (Vertex)B, this.weight, 1).paths();
        this.printPaths(paths);
        Assert.assertEquals((String)"incorrect paths count", (long)1L, (long)paths.size());
        Assert.assertEquals((String)"incorrect path cost", (double)1.0, (double)((Path)paths.iterator().next()).cost(), (double)0.1);
        paths = gs.search(this.graph, (Vertex)A, (Vertex)D, this.weight, 1).paths();
        this.printPaths(paths);
        Assert.assertEquals((String)"incorrect paths count", (long)0L, (long)paths.size());
        paths = gs.search(this.graph, (Vertex)A, null, this.weight, 1).paths();
        this.printPaths(paths);
        Assert.assertEquals((String)"incorrect paths count", (long)1L, (long)paths.size());
        Assert.assertEquals((String)"incorrect path cost", (double)1.0, (double)((Path)paths.iterator().next()).cost(), (double)0.1);
    }

    @Test
    public void simpleMultiplePath() {
        this.graph = new AdjacencyListsGraph((Set)ImmutableSet.of((Object)A, (Object)B, (Object)C, (Object)D), (Set)ImmutableSet.of((Object)((Object)new TestEdge(A, B, 1.0)), (Object)((Object)new TestEdge(A, C, 1.0)), (Object)((Object)new TestEdge(B, D, 1.0)), (Object)((Object)new TestEdge(C, D, 1.0))));
        this.executeSearch((GraphPathSearch<TestVertex, TestEdge>)this.graphSearch(), (Graph<TestVertex, TestEdge>)this.graph, A, D, (EdgeWeight<TestVertex, TestEdge>)this.weight, 2, 2.0);
        this.executeSinglePathSearch((GraphPathSearch<TestVertex, TestEdge>)this.graphSearch(), (Graph<TestVertex, TestEdge>)this.graph, A, D, (EdgeWeight<TestVertex, TestEdge>)this.weight, 1, 2.0);
    }

    @Test
    public void denseMultiplePath() {
        this.graph = new AdjacencyListsGraph((Set)ImmutableSet.of((Object)A, (Object)B, (Object)C, (Object)D, (Object)E, (Object)F, (Object[])new TestVertex[]{G}), (Set)ImmutableSet.of((Object)((Object)new TestEdge(A, B, 1.0)), (Object)((Object)new TestEdge(A, C, 1.0)), (Object)((Object)new TestEdge(B, D, 1.0)), (Object)((Object)new TestEdge(C, D, 1.0)), (Object)((Object)new TestEdge(D, E, 1.0)), (Object)((Object)new TestEdge(D, F, 1.0)), (Object[])new TestEdge[]{new TestEdge(E, G, 1.0), new TestEdge(F, G, 1.0), new TestEdge(A, G, 4.0)}));
        this.executeSearch((GraphPathSearch<TestVertex, TestEdge>)this.graphSearch(), (Graph<TestVertex, TestEdge>)this.graph, A, G, (EdgeWeight<TestVertex, TestEdge>)this.weight, 5, 4.0);
        this.executeSinglePathSearch((GraphPathSearch<TestVertex, TestEdge>)this.graphSearch(), (Graph<TestVertex, TestEdge>)this.graph, A, G, (EdgeWeight<TestVertex, TestEdge>)this.weight, 1, 4.0);
    }

    @Test
    public void dualEdgeMultiplePath() {
        this.graph = new AdjacencyListsGraph((Set)ImmutableSet.of((Object)A, (Object)B, (Object)C, (Object)D, (Object)E, (Object)F, (Object[])new TestVertex[]{G, H}), (Set)ImmutableSet.of((Object)((Object)new TestEdge(A, B, 1.0)), (Object)((Object)new TestEdge(A, C, 3.0)), (Object)((Object)new TestEdge(B, D, 2.0)), (Object)((Object)new TestEdge(B, C, 1.0)), (Object)((Object)new TestEdge(B, E, 4.0)), (Object)((Object)new TestEdge(C, E, 1.0)), (Object[])new TestEdge[]{new TestEdge(D, H, 5.0), new TestEdge(D, E, 1.0), new TestEdge(E, F, 1.0), new TestEdge(F, D, 1.0), new TestEdge(F, G, 1.0), new TestEdge(F, H, 1.0), new TestEdge(A, E, 3.0), new TestEdge(B, D, 1.0)}));
        this.executeSearch((GraphPathSearch<TestVertex, TestEdge>)this.graphSearch(), (Graph<TestVertex, TestEdge>)this.graph, A, E, (EdgeWeight<TestVertex, TestEdge>)this.weight, 3, 3.0);
        this.executeSinglePathSearch((GraphPathSearch<TestVertex, TestEdge>)this.graphSearch(), (Graph<TestVertex, TestEdge>)this.graph, A, E, (EdgeWeight<TestVertex, TestEdge>)this.weight, 1, 3.0);
    }

    @Test
    public void negativeWeights() {
        this.graph = new AdjacencyListsGraph((Set)ImmutableSet.of((Object)A, (Object)B, (Object)C, (Object)D, (Object)E, (Object)F, (Object[])new TestVertex[]{G}), (Set)ImmutableSet.of((Object)((Object)new TestEdge(A, B, 1.0)), (Object)((Object)new TestEdge(A, C, -1.0)), (Object)((Object)new TestEdge(B, D, 1.0)), (Object)((Object)new TestEdge(D, A, -2.0)), (Object)((Object)new TestEdge(C, D, 1.0)), (Object)((Object)new TestEdge(D, E, 1.0)), (Object[])new TestEdge[]{new TestEdge(D, F, 1.0), new TestEdge(E, G, 1.0), new TestEdge(F, G, 1.0), new TestEdge(G, A, -5.0), new TestEdge(A, G, 4.0)}));
        this.executeSearch((GraphPathSearch<TestVertex, TestEdge>)this.graphSearch(), (Graph<TestVertex, TestEdge>)this.graph, A, G, (EdgeWeight<TestVertex, TestEdge>)this.weight, 3, 4.0);
        this.executeSinglePathSearch((GraphPathSearch<TestVertex, TestEdge>)this.graphSearch(), (Graph<TestVertex, TestEdge>)this.graph, A, G, (EdgeWeight<TestVertex, TestEdge>)this.weight, 1, 4.0);
    }

    @Test
    public void disconnectedPerf() {
        this.disconnected();
        this.disconnected();
        this.disconnected();
        this.disconnected();
        this.disconnected();
        this.disconnected();
        this.disconnected();
        this.disconnected();
        this.disconnected();
        this.disconnected();
    }

    @Test
    public void disconnected() {
        HashSet<TestVertex> vertexes = new HashSet<TestVertex>();
        for (int i = 0; i < 200; ++i) {
            vertexes.add(new TestVertex("v" + i));
        }
        this.graph = new AdjacencyListsGraph(vertexes, (Set)ImmutableSet.of());
        long start = System.nanoTime();
        for (TestVertex src : vertexes) {
            this.executeSearch((GraphPathSearch<TestVertex, TestEdge>)this.graphSearch(), (Graph<TestVertex, TestEdge>)this.graph, src, null, null, 0, 0.0);
        }
        long end = System.nanoTime();
        DecimalFormat fmt = new DecimalFormat("#,###");
        System.out.println("Compute cost is " + fmt.format(end - start) + " nanos");
    }
}

