/*
 * Decompiled with CFR 0.152.
 */
package org.onlab.graph;

import com.google.common.collect.ImmutableSet;
import java.util.Set;
import org.junit.Assert;
import org.junit.Test;
import org.onlab.graph.AbstractGraphPathSearch;
import org.onlab.graph.AdjacencyListsGraph;
import org.onlab.graph.BreadthFirstSearchTest;
import org.onlab.graph.DisjointPathPair;
import org.onlab.graph.EdgeWeight;
import org.onlab.graph.Graph;
import org.onlab.graph.GraphPathSearch;
import org.onlab.graph.SuurballeGraphSearch;
import org.onlab.graph.TestEdge;
import org.onlab.graph.TestVertex;
import org.onlab.graph.Vertex;

public class SuurballeGraphSearchTest
extends BreadthFirstSearchTest {
    @Override
    protected AbstractGraphPathSearch<TestVertex, TestEdge> graphSearch() {
        return new SuurballeGraphSearch();
    }

    public void setWeights() {
        this.weight = new EdgeWeight<TestVertex, TestEdge>(){

            public double weight(TestEdge edge) {
                return edge.weight();
            }
        };
    }

    public void setDefaultWeights() {
        this.weight = null;
    }

    @Override
    public void defaultGraphTest() {
    }

    @Override
    public void defaultHopCountWeight() {
    }

    @Test
    public void basicGraphTest() {
        this.setDefaultWeights();
        AdjacencyListsGraph graph = new AdjacencyListsGraph((Set)ImmutableSet.of((Object)A, (Object)B, (Object)C, (Object)D), (Set)ImmutableSet.of((Object)((Object)new TestEdge(A, B, 1.0)), (Object)((Object)new TestEdge(B, C, 1.0)), (Object)((Object)new TestEdge(A, D, 1.0)), (Object)((Object)new TestEdge(D, C, 1.0))));
        this.executeSearch((GraphPathSearch<TestVertex, TestEdge>)this.graphSearch(), (Graph<TestVertex, TestEdge>)graph, A, C, (EdgeWeight<TestVertex, TestEdge>)this.weight, 1, 4.0);
    }

    @Test
    public void multiplePathOnePairGraphTest() {
        this.setWeights();
        AdjacencyListsGraph graph = new AdjacencyListsGraph((Set)ImmutableSet.of((Object)A, (Object)B, (Object)C, (Object)D, (Object)E), (Set)ImmutableSet.of((Object)((Object)new TestEdge(A, B, 1.0)), (Object)((Object)new TestEdge(B, C, 1.0)), (Object)((Object)new TestEdge(A, D, 1.0)), (Object)((Object)new TestEdge(D, C, 1.0)), (Object)((Object)new TestEdge(B, E, 2.0)), (Object)((Object)new TestEdge(C, E, 1.0)), (Object[])new TestEdge[0]));
        this.executeSearch((GraphPathSearch<TestVertex, TestEdge>)this.graphSearch(), (Graph<TestVertex, TestEdge>)graph, A, E, (EdgeWeight<TestVertex, TestEdge>)this.weight, 1, 6.0);
    }

    @Test
    public void multiplePathsMultiplePairs() {
        this.setWeights();
        AdjacencyListsGraph graph = new AdjacencyListsGraph((Set)ImmutableSet.of((Object)A, (Object)B, (Object)C, (Object)D, (Object)E), (Set)ImmutableSet.of((Object)((Object)new TestEdge(A, B, 1.0)), (Object)((Object)new TestEdge(B, E, 1.0)), (Object)((Object)new TestEdge(A, C, 1.0)), (Object)((Object)new TestEdge(C, E, 1.0)), (Object)((Object)new TestEdge(A, D, 1.0)), (Object)((Object)new TestEdge(D, E, 1.0)), (Object[])new TestEdge[]{new TestEdge(A, E, 2.0)}));
        GraphPathSearch.Result result = this.graphSearch().search((Graph)graph, (Vertex)A, (Vertex)E, this.weight, -1);
        Set paths = result.paths();
        System.out.println("\n\n" + paths + "\n\n\ndone\n");
        Assert.assertEquals((String)"incorrect paths count", (long)3L, (long)paths.size());
        DisjointPathPair dpp = (DisjointPathPair)paths.iterator().next();
        Assert.assertEquals((String)"incorrect disjoint paths per path", (long)2L, (long)dpp.size());
    }

    @Test
    public void differingPrimaryAndBackupPathLengths() {
        this.setWeights();
        AdjacencyListsGraph graph = new AdjacencyListsGraph((Set)ImmutableSet.of((Object)A, (Object)B, (Object)C, (Object)D, (Object)E), (Set)ImmutableSet.of((Object)((Object)new TestEdge(A, B, 1.0)), (Object)((Object)new TestEdge(B, C, 1.0)), (Object)((Object)new TestEdge(A, D, 1.0)), (Object)((Object)new TestEdge(D, C, 1.0)), (Object)((Object)new TestEdge(B, E, 1.0)), (Object)((Object)new TestEdge(C, E, 1.0)), (Object[])new TestEdge[0]));
        this.executeSearch((GraphPathSearch<TestVertex, TestEdge>)this.graphSearch(), (Graph<TestVertex, TestEdge>)graph, A, E, (EdgeWeight<TestVertex, TestEdge>)this.weight, 1, 5.0);
    }

    @Test
    public void onePath() {
        this.setWeights();
        AdjacencyListsGraph graph = new AdjacencyListsGraph((Set)ImmutableSet.of((Object)A, (Object)B, (Object)C, (Object)D), (Set)ImmutableSet.of((Object)((Object)new TestEdge(A, B, 1.0)), (Object)((Object)new TestEdge(B, C, 1.0)), (Object)((Object)new TestEdge(A, C, 4.0)), (Object)((Object)new TestEdge(C, D, 1.0))));
        GraphPathSearch.Result result = this.graphSearch().search((Graph)graph, (Vertex)A, (Vertex)D, this.weight, -1);
        Set paths = result.paths();
        Assert.assertEquals((String)"incorrect paths count", (long)1L, (long)paths.size());
        DisjointPathPair dpp = (DisjointPathPair)paths.iterator().next();
        Assert.assertEquals((String)"incorrect disjoint paths count", (long)1L, (long)dpp.size());
    }

    @Test
    public void noPath() {
        this.setWeights();
        AdjacencyListsGraph graph = new AdjacencyListsGraph((Set)ImmutableSet.of((Object)A, (Object)B, (Object)C, (Object)D), (Set)ImmutableSet.of((Object)((Object)new TestEdge(A, B, 1.0)), (Object)((Object)new TestEdge(B, C, 1.0)), (Object)((Object)new TestEdge(A, C, 4.0))));
        GraphPathSearch.Result result = this.graphSearch().search((Graph)graph, (Vertex)A, (Vertex)D, this.weight, -1);
        Set paths = result.paths();
        Assert.assertEquals((String)"incorrect paths count", (long)paths.size(), (long)0L);
    }

    @Test
    public void disconnected() {
        this.setWeights();
        AdjacencyListsGraph graph = new AdjacencyListsGraph((Set)ImmutableSet.of((Object)A, (Object)B, (Object)C, (Object)D), (Set)ImmutableSet.of());
        GraphPathSearch.Result result = this.graphSearch().search((Graph)graph, (Vertex)A, (Vertex)D, this.weight, -1);
        Set paths = result.paths();
        Assert.assertEquals((String)"incorrect paths count", (long)0L, (long)paths.size());
    }
}

