/*
 * Decompiled with CFR 0.152.
 */
package org.onlab.graph;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.onlab.graph.AbstractGraphPathSearch;
import org.onlab.graph.DijkstraGraphSearch;
import org.onlab.graph.DisjointPathPair;
import org.onlab.graph.Edge;
import org.onlab.graph.EdgeWeight;
import org.onlab.graph.Graph;
import org.onlab.graph.GraphPathSearch;
import org.onlab.graph.MutableAdjacencyListsGraph;
import org.onlab.graph.MutableGraph;
import org.onlab.graph.Path;
import org.onlab.graph.Vertex;

public class SuurballeGraphSearch<V extends Vertex, E extends Edge<V>>
extends DijkstraGraphSearch<V, E> {
    private Class<?> clazzV;
    private Class<?> clazzE;

    @Override
    public GraphPathSearch.Result<V, E> search(Graph<V, E> graph, V src, V dst, EdgeWeight<V, E> weight, int maxPaths) {
        if (weight == null) {
            weight = edge -> 1.0;
        }
        ArrayList dpps = new ArrayList();
        EdgeWeight weightf = weight;
        AbstractGraphPathSearch.DefaultResult firstDijkstraS = (AbstractGraphPathSearch.DefaultResult)super.search(graph, src, dst, weight, -1);
        final AbstractGraphPathSearch.DefaultResult firstDijkstra = (AbstractGraphPathSearch.DefaultResult)super.search(graph, src, null, weight, -1);
        Path shortPath = null;
        if (firstDijkstraS.paths().size() == 0) {
            return firstDijkstraS;
        }
        Iterator iterator = firstDijkstraS.paths().iterator();
        while (iterator.hasNext()) {
            Path p;
            shortPath = p = iterator.next();
            EdgeWeight modified = edge -> {
                if (this.classE().isInstance(edge)) {
                    return weightf.weight(edge) + firstDijkstra.cost(edge.src()) - firstDijkstra.cost(edge.dst());
                }
                return 0.0;
            };
            EdgeWeight modified2 = edge -> weightf.weight(edge) + firstDijkstra.cost(edge.src()) - firstDijkstra.cost(edge.dst());
            MutableGraph gt = this.mutableCopy(graph);
            HashMap<1, Edge> revToEdge = new HashMap<1, Edge>();
            graph.getEdgesTo(src).forEach(gt::removeEdge);
            for (final Edge edge2 : shortPath.edges()) {
                gt.removeEdge(edge2);
                Edge reverse = new Edge<V>(){
                    final Edge<V> orig;
                    {
                        this.orig = edge2;
                    }

                    @Override
                    public V src() {
                        return this.orig.dst();
                    }

                    @Override
                    public V dst() {
                        return this.orig.src();
                    }

                    public String toString() {
                        return "ReversedEdge src=" + this.src() + " dst=" + this.dst();
                    }
                };
                revToEdge.put(reverse, edge2);
                gt.addEdge(reverse);
            }
            GraphPathSearch.Result secondDijkstra = new DijkstraGraphSearch<V, Edge>().search(gt, src, dst, modified, -1);
            Path residualShortPath = null;
            if (secondDijkstra.paths().size() == 0) {
                dpps.add(new DisjointPathPair(shortPath, null));
                continue;
            }
            Iterator iterator2 = secondDijkstra.paths().iterator();
            while (iterator2.hasNext()) {
                Path p2;
                residualShortPath = p2 = iterator2.next();
                MutableGraph roundTrip = this.mutableCopy(graph);
                List<Edge> tmp = roundTrip.getEdges().stream().collect(Collectors.toList());
                tmp.forEach(roundTrip::removeEdge);
                shortPath.edges().forEach(roundTrip::addEdge);
                if (residualShortPath != null) {
                    for (Edge edge3 : residualShortPath.edges()) {
                        if (this.classE().isInstance(edge3)) {
                            roundTrip.addEdge(edge3);
                            continue;
                        }
                        roundTrip.removeEdge((Edge)revToEdge.get(edge3));
                    }
                }
                AbstractGraphPathSearch.DefaultResult lastSearch = (AbstractGraphPathSearch.DefaultResult)super.search(roundTrip, src, dst, weight, -1);
                Path path1 = lastSearch.paths().iterator().next();
                path1.edges().forEach(roundTrip::removeEdge);
                Set<Path<V, E>> bckpaths = super.search(roundTrip, src, dst, weight, -1).paths();
                Path<V, E> backup = null;
                if (bckpaths.size() != 0) {
                    backup = bckpaths.iterator().next();
                }
                dpps.add(new DisjointPathPair(path1, backup));
            }
        }
        for (int i = dpps.size() - 1; i > 0; --i) {
            if (((DisjointPathPair)dpps.get(i)).size() > 1) continue;
            dpps.remove(i);
        }
        return new GraphPathSearch.Result<V, E>((Vertex)src, (Vertex)dst, dpps, maxPaths){
            final AbstractGraphPathSearch.DefaultResult search;
            final /* synthetic */ Vertex val$src;
            final /* synthetic */ Vertex val$dst;
            final /* synthetic */ List val$dpps;
            final /* synthetic */ int val$maxPaths;
            {
                this.val$src = vertex;
                this.val$dst = vertex2;
                this.val$dpps = list;
                this.val$maxPaths = n;
                this.search = firstDijkstra;
            }

            @Override
            public V src() {
                return this.val$src;
            }

            @Override
            public V dst() {
                return this.val$dst;
            }

            @Override
            public Set<Path<V, E>> paths() {
                HashSet pathsD = new HashSet();
                int paths = 0;
                for (DisjointPathPair path : this.val$dpps) {
                    pathsD.add(path);
                    if (++paths != this.val$maxPaths) continue;
                    break;
                }
                return pathsD;
            }

            @Override
            public Map<V, Double> costs() {
                return this.search.costs();
            }

            @Override
            public Map<V, Set<E>> parents() {
                return this.search.parents();
            }
        };
    }

    public Class<?> classV() {
        return this.clazzV;
    }

    public Class<?> classE() {
        return this.clazzE;
    }

    public MutableGraph mutableCopy(Graph<V, E> graph) {
        this.clazzV = ((Vertex)graph.getVertexes().iterator().next()).getClass();
        this.clazzE = ((Edge)graph.getEdges().iterator().next()).getClass();
        return new MutableAdjacencyListsGraph<V, E>(graph.getVertexes(), graph.getEdges());
    }
}

