/*
 * Decompiled with CFR 0.152.
 */
package org.onlab.packet;

import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import java.io.UnsupportedEncodingException;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.ListIterator;
import org.onlab.packet.BasePacket;
import org.onlab.packet.DHCPOption;
import org.onlab.packet.DHCPPacketType;
import org.onlab.packet.DeserializationException;
import org.onlab.packet.Deserializer;
import org.onlab.packet.IPacket;
import org.onlab.packet.PacketUtils;

public class DHCP
extends BasePacket {
    public static final int MIN_HEADER_LENGTH = 240;
    public static final byte OPCODE_REQUEST = 1;
    public static final byte OPCODE_REPLY = 2;
    public static final byte HWTYPE_ETHERNET = 1;
    protected byte opCode;
    protected byte hardwareType;
    protected byte hardwareAddressLength;
    protected byte hops;
    protected int transactionId;
    protected short seconds;
    protected short flags;
    protected int clientIPAddress;
    protected int yourIPAddress;
    protected int serverIPAddress;
    protected int gatewayIPAddress;
    protected byte[] clientHardwareAddress;
    protected String serverName;
    protected String bootFileName;
    protected List<DHCPOption> options = new ArrayList<DHCPOption>();

    public byte getOpCode() {
        return this.opCode;
    }

    public DHCP setOpCode(byte opCode) {
        this.opCode = opCode;
        return this;
    }

    public byte getHardwareType() {
        return this.hardwareType;
    }

    public DHCP setHardwareType(byte hardwareType) {
        this.hardwareType = hardwareType;
        return this;
    }

    public byte getHardwareAddressLength() {
        return this.hardwareAddressLength;
    }

    public DHCP setHardwareAddressLength(byte hardwareAddressLength) {
        this.hardwareAddressLength = hardwareAddressLength;
        return this;
    }

    public byte getHops() {
        return this.hops;
    }

    public DHCP setHops(byte hops) {
        this.hops = hops;
        return this;
    }

    public int getTransactionId() {
        return this.transactionId;
    }

    public DHCP setTransactionId(int transactionId) {
        this.transactionId = transactionId;
        return this;
    }

    public short getSeconds() {
        return this.seconds;
    }

    public DHCP setSeconds(short seconds) {
        this.seconds = seconds;
        return this;
    }

    public short getFlags() {
        return this.flags;
    }

    public DHCP setFlags(short flags) {
        this.flags = flags;
        return this;
    }

    public int getClientIPAddress() {
        return this.clientIPAddress;
    }

    public DHCP setClientIPAddress(int clientIPAddress) {
        this.clientIPAddress = clientIPAddress;
        return this;
    }

    public int getYourIPAddress() {
        return this.yourIPAddress;
    }

    public DHCP setYourIPAddress(int yourIPAddress) {
        this.yourIPAddress = yourIPAddress;
        return this;
    }

    public int getServerIPAddress() {
        return this.serverIPAddress;
    }

    public DHCP setServerIPAddress(int serverIPAddress) {
        this.serverIPAddress = serverIPAddress;
        return this;
    }

    public int getGatewayIPAddress() {
        return this.gatewayIPAddress;
    }

    public DHCP setGatewayIPAddress(int gatewayIPAddress) {
        this.gatewayIPAddress = gatewayIPAddress;
        return this;
    }

    public byte[] getClientHardwareAddress() {
        return this.clientHardwareAddress;
    }

    public DHCP setClientHardwareAddress(byte[] clientHardwareAddress) {
        this.clientHardwareAddress = clientHardwareAddress;
        return this;
    }

    public DHCPOption getOption(DHCPOptionCode optionCode) {
        for (DHCPOption opt : this.options) {
            if (opt.code != optionCode.value) continue;
            return opt;
        }
        return null;
    }

    public List<DHCPOption> getOptions() {
        return this.options;
    }

    public DHCP setOptions(List<DHCPOption> options) {
        this.options = options;
        return this;
    }

    public DHCPPacketType getPacketType() {
        ListIterator<DHCPOption> lit = this.options.listIterator();
        while (lit.hasNext()) {
            DHCPOption option = lit.next();
            if (option.getCode() != 53) continue;
            return DHCPPacketType.getType(option.getData()[0]);
        }
        return null;
    }

    public String getServerName() {
        return this.serverName;
    }

    public DHCP setServerName(String server) {
        this.serverName = server;
        return this;
    }

    public String getBootFileName() {
        return this.bootFileName;
    }

    public DHCP setBootFileName(String bootFile) {
        this.bootFileName = bootFile;
        return this;
    }

    @Override
    public byte[] serialize() {
        this.resetChecksum();
        int optionsLength = 0;
        for (DHCPOption option : this.options) {
            if (option.getCode() == 0 || option.getCode() == -1) {
                ++optionsLength;
                continue;
            }
            optionsLength += 2 + (0xFF & option.getLength());
        }
        int optionsPadLength = 0;
        if (optionsLength < 60) {
            optionsPadLength = 60 - optionsLength;
        }
        byte[] data = new byte[240 + optionsLength + optionsPadLength];
        ByteBuffer bb = ByteBuffer.wrap(data);
        bb.put(this.opCode);
        bb.put(this.hardwareType);
        bb.put(this.hardwareAddressLength);
        bb.put(this.hops);
        bb.putInt(this.transactionId);
        bb.putShort(this.seconds);
        bb.putShort(this.flags);
        bb.putInt(this.clientIPAddress);
        bb.putInt(this.yourIPAddress);
        bb.putInt(this.serverIPAddress);
        bb.putInt(this.gatewayIPAddress);
        Preconditions.checkArgument((this.clientHardwareAddress.length <= 16 ? 1 : 0) != 0, (String)"Hardware address is too long (%s bytes)", (Object[])new Object[]{this.clientHardwareAddress.length});
        bb.put(this.clientHardwareAddress);
        if (this.clientHardwareAddress.length < 16) {
            for (int i = 0; i < 16 - this.clientHardwareAddress.length; ++i) {
                bb.put((byte)0);
            }
        }
        this.writeString(this.serverName, bb, 64);
        this.writeString(this.bootFileName, bb, 128);
        bb.put((byte)99);
        bb.put((byte)-126);
        bb.put((byte)83);
        bb.put((byte)99);
        for (DHCPOption option : this.options) {
            int code = option.getCode() & 0xFF;
            bb.put((byte)code);
            if (code == 0 || code == 255) continue;
            bb.put(option.getLength());
            bb.put(option.getData());
        }
        return data;
    }

    @Override
    public IPacket deserialize(byte[] data, int offset, int length) {
        ByteBuffer bb = ByteBuffer.wrap(data, offset, length);
        if (bb.remaining() < 240) {
            return this;
        }
        this.opCode = bb.get();
        this.hardwareType = bb.get();
        this.hardwareAddressLength = bb.get();
        this.hops = bb.get();
        this.transactionId = bb.getInt();
        this.seconds = bb.getShort();
        this.flags = bb.getShort();
        this.clientIPAddress = bb.getInt();
        this.yourIPAddress = bb.getInt();
        this.serverIPAddress = bb.getInt();
        this.gatewayIPAddress = bb.getInt();
        int hardwareAddressLength = 0xFF & this.hardwareAddressLength;
        this.clientHardwareAddress = new byte[hardwareAddressLength];
        bb.get(this.clientHardwareAddress);
        for (int i = hardwareAddressLength; i < 16; ++i) {
            bb.get();
        }
        this.serverName = DHCP.readString(bb, 64);
        this.bootFileName = DHCP.readString(bb, 128);
        bb.get();
        bb.get();
        bb.get();
        bb.get();
        while (bb.hasRemaining()) {
            DHCPOption option = new DHCPOption();
            int code = 0xFF & bb.get();
            option.setCode((byte)code);
            if (code == 0) continue;
            if (code != 255) {
                if (bb.hasRemaining()) {
                    int l = 0xFF & bb.get();
                    option.setLength((byte)l);
                    if (bb.remaining() >= l) {
                        byte[] optionData = new byte[l];
                        bb.get(optionData);
                        option.setData(optionData);
                    } else {
                        code = 255;
                        option.setCode((byte)code);
                        option.setLength((byte)0);
                    }
                } else {
                    code = 255;
                    option.setCode((byte)code);
                    option.setLength((byte)0);
                }
            }
            this.options.add(option);
            if (code != 255) continue;
            break;
        }
        return this;
    }

    protected void writeString(String string, ByteBuffer bb, int maxLength) {
        if (string == null) {
            for (int i = 0; i < maxLength; ++i) {
                bb.put((byte)0);
            }
        } else {
            byte[] bytes = null;
            try {
                bytes = string.getBytes("ascii");
            }
            catch (UnsupportedEncodingException e) {
                throw new RuntimeException("Failure encoding server name", e);
            }
            int writeLength = bytes.length;
            if (writeLength > maxLength) {
                writeLength = maxLength;
            }
            bb.put(bytes, 0, writeLength);
            for (int i = writeLength; i < maxLength; ++i) {
                bb.put((byte)0);
            }
        }
    }

    private static String readString(ByteBuffer bb, int maxLength) {
        byte[] bytes = new byte[maxLength];
        bb.get(bytes);
        String result = null;
        try {
            result = new String(bytes, "ascii").trim();
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException("Failure decoding string", e);
        }
        return result;
    }

    public static Deserializer<DHCP> deserializer() {
        return (data, offset, length) -> {
            PacketUtils.checkInput(data, offset, length, 240);
            ByteBuffer bb = ByteBuffer.wrap(data, offset, length);
            DHCP dhcp = new DHCP();
            dhcp.opCode = bb.get();
            dhcp.hardwareType = bb.get();
            dhcp.hardwareAddressLength = bb.get();
            dhcp.hops = bb.get();
            dhcp.transactionId = bb.getInt();
            dhcp.seconds = bb.getShort();
            dhcp.flags = bb.getShort();
            dhcp.clientIPAddress = bb.getInt();
            dhcp.yourIPAddress = bb.getInt();
            dhcp.serverIPAddress = bb.getInt();
            dhcp.gatewayIPAddress = bb.getInt();
            int hardwareAddressLength = 0xFF & dhcp.hardwareAddressLength;
            dhcp.clientHardwareAddress = new byte[hardwareAddressLength];
            bb.get(dhcp.clientHardwareAddress);
            for (int i = hardwareAddressLength; i < 16; ++i) {
                bb.get();
            }
            dhcp.serverName = DHCP.readString(bb, 64);
            dhcp.bootFileName = DHCP.readString(bb, 128);
            bb.get();
            bb.get();
            bb.get();
            bb.get();
            boolean foundEndOptionsMarker = false;
            while (bb.hasRemaining()) {
                DHCPOption option = new DHCPOption();
                int code = 0xFF & bb.get();
                option.setCode((byte)code);
                if (code == 0) continue;
                if (code != 255) {
                    if (!bb.hasRemaining()) continue;
                    int l = 0xFF & bb.get();
                    option.setLength((byte)l);
                    if (bb.remaining() >= l) {
                        byte[] optionData = new byte[l];
                        bb.get(optionData);
                        option.setData(optionData);
                        dhcp.options.add(option);
                        continue;
                    }
                    throw new DeserializationException("Buffer underflow while reading DHCP option");
                }
                if (code != 255) continue;
                DHCPOption end = new DHCPOption();
                end.setCode((byte)-1);
                dhcp.options.add(end);
                foundEndOptionsMarker = true;
                break;
            }
            if (!foundEndOptionsMarker) {
                throw new DeserializationException("DHCP End options marker was missing");
            }
            return dhcp;
        };
    }

    public String toString() {
        return MoreObjects.toStringHelper(this.getClass()).add("opCode", (Object)Byte.toString(this.opCode)).add("hardwareType", (Object)Byte.toString(this.hardwareType)).add("hardwareAddressLength", (Object)Byte.toString(this.hardwareAddressLength)).add("hops", (Object)Byte.toString(this.hops)).add("transactionId", (Object)Integer.toString(this.transactionId)).add("seconds", (Object)Short.toString(this.seconds)).add("flags", (Object)Short.toString(this.flags)).add("clientIPAddress", (Object)Integer.toString(this.clientIPAddress)).add("yourIPAddress", (Object)Integer.toString(this.yourIPAddress)).add("serverIPAddress", (Object)Integer.toString(this.serverIPAddress)).add("gatewayIPAddress", (Object)Integer.toString(this.gatewayIPAddress)).add("clientHardwareAddress", (Object)Arrays.toString(this.clientHardwareAddress)).add("serverName", (Object)this.serverName).add("bootFileName", (Object)this.bootFileName).toString();
    }

    public static enum DHCPOptionCode {
        OptionCode_SubnetMask(1),
        OptionCode_RouterAddress(3),
        OptionCode_DomainServer(6),
        OptionCode_HostName(12),
        OptionCode_DomainName(15),
        OptionCode_BroadcastAddress(28),
        OptionCode_RequestedIP(50),
        OptionCode_LeaseTime(51),
        OptionCode_MessageType(53),
        OptionCode_DHCPServerIp(54),
        OptionCode_RequestedParameters(55),
        OptionCode_RenewalTime(58),
        OPtionCode_RebindingTime(59),
        OptionCode_ClientID(61),
        OptionCode_END(-1);

        protected byte value;

        private DHCPOptionCode(byte value) {
            this.value = value;
        }

        public byte getValue() {
            return this.value;
        }
    }
}

