/*
 * Decompiled with CFR 0.152.
 */
package org.onlab.packet;

import com.google.common.base.MoreObjects;
import java.nio.ByteBuffer;
import java.util.Arrays;
import org.onlab.packet.BasePacket;
import org.onlab.packet.Deserializer;
import org.onlab.packet.IPacket;
import org.onlab.packet.PacketUtils;

public class EAP
extends BasePacket {
    private static final int HEADER_LENGTH = 4;
    public static final short MIN_LEN = 4;
    public static final short EAP_HDR_LEN_REQ_RESP = 5;
    public static final short EAP_HDR_LEN_SUC_FAIL = 4;
    public static final byte REQUEST = 1;
    public static final byte RESPONSE = 2;
    public static final byte SUCCESS = 3;
    public static final byte FAILURE = 4;
    public static final byte ATTR_IDENTITY = 1;
    public static final byte ATTR_NOTIFICATION = 2;
    public static final byte ATTR_NAK = 3;
    public static final byte ATTR_MD5 = 4;
    public static final byte ATTR_OTP = 5;
    public static final byte ATTR_GTC = 6;
    public static final byte ATTR_TLS = 13;
    protected byte code;
    protected byte identifier;
    protected short length;
    protected byte type;
    protected byte[] data;

    public byte getCode() {
        return this.code;
    }

    public EAP setCode(byte code) {
        this.code = code;
        return this;
    }

    public byte getIdentifier() {
        return this.identifier;
    }

    public EAP setIdentifier(byte identifier) {
        this.identifier = identifier;
        return this;
    }

    public short getLength() {
        return this.length;
    }

    public EAP setLength(short length) {
        this.length = length;
        return this;
    }

    public byte getDataType() {
        return this.type;
    }

    public EAP setDataType(byte type) {
        this.type = type;
        return this;
    }

    public byte[] getData() {
        return this.data;
    }

    public EAP setData(byte[] data) {
        this.data = data;
        return this;
    }

    public EAP() {
        this.code = 0;
    }

    public EAP(byte code, byte identifier, byte type, byte[] data) {
        this.code = code;
        this.identifier = identifier;
        if (this.code == 1 || this.code == 2) {
            this.length = (short)(5 + (data == null ? 0 : data.length));
            this.type = type;
        } else {
            this.length = (short)(4 + (data == null ? 0 : data.length));
        }
        this.data = data;
    }

    public static Deserializer<EAP> deserializer() {
        return (data, offset, length) -> {
            int dataLength;
            PacketUtils.checkInput(data, offset, length, 4);
            EAP eap = new EAP();
            ByteBuffer bb = ByteBuffer.wrap(data, offset, length);
            eap.code = bb.get();
            eap.identifier = bb.get();
            eap.length = bb.getShort();
            PacketUtils.checkHeaderLength(length, eap.length);
            if (eap.code == 1 || eap.code == 2) {
                eap.type = bb.get();
                dataLength = eap.length - 5;
            } else {
                dataLength = eap.length - 4;
            }
            eap.data = new byte[dataLength];
            bb.get(eap.data);
            return eap;
        };
    }

    @Override
    public byte[] serialize() {
        byte[] data = new byte[this.length];
        ByteBuffer bb = ByteBuffer.wrap(data);
        bb.put(this.code);
        bb.put(this.identifier);
        bb.putShort(this.length);
        if (this.code == 1 || this.code == 2) {
            bb.put(this.type);
        }
        if (this.data != null) {
            bb.put(this.data);
        }
        return data;
    }

    @Override
    public IPacket deserialize(byte[] data, int offset, int length) {
        int dataLength;
        ByteBuffer bb = ByteBuffer.wrap(data, offset, length);
        this.code = bb.get();
        this.identifier = bb.get();
        this.length = bb.getShort();
        if (this.code == 1 || this.code == 2) {
            this.type = bb.get();
            dataLength = this.length - 5;
        } else {
            dataLength = this.length - 4;
        }
        this.data = new byte[dataLength];
        bb.get(this.data);
        return this;
    }

    @Override
    public int hashCode() {
        int prime = 3889;
        int result = super.hashCode();
        result = 3889 * result + this.code;
        result = 3889 * result + this.identifier;
        result = 3889 * result + this.length;
        result = 3889 * result + this.type;
        return result;
    }

    public String toString() {
        return MoreObjects.toStringHelper(this.getClass()).add("code", (Object)Byte.toString(this.code)).add("identifier", (Object)Byte.toString(this.identifier)).add("length", (Object)Short.toString(this.length)).add("type", (Object)Byte.toString(this.type)).add("data", (Object)Arrays.toString(this.data)).toString();
    }
}

