/*
 * Decompiled with CFR 0.152.
 */
package org.onlab.packet;

import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.onlab.packet.BasePacket;
import org.onlab.packet.DeserializationException;
import org.onlab.packet.Deserializer;
import org.onlab.packet.IGMPGroup;
import org.onlab.packet.IGMPMembership;
import org.onlab.packet.IGMPQuery;
import org.onlab.packet.IPacket;
import org.onlab.packet.PacketUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class IGMP
extends BasePacket {
    private final Logger log = LoggerFactory.getLogger(this.getClass());
    public static final byte TYPE_IGMPV3_MEMBERSHIP_QUERY = 17;
    public static final byte TYPE_IGMPV1_MEMBERSHIP_REPORT = 18;
    public static final byte TYPE_IGMPV2_MEMBERSHIP_REPORT = 22;
    public static final byte TYPE_IGMPV2_LEAVE_GROUP = 23;
    public static final byte TYPE_IGMPV3_MEMBERSHIP_REPORT = 34;
    public static final Map<Byte, Deserializer<? extends IPacket>> PROTOCOL_DESERIALIZER_MAP = new HashMap<Byte, Deserializer<? extends IPacket>>();
    public static final int MINIMUM_HEADER_LEN = 12;
    List<IGMPGroup> groups = new ArrayList<IGMPGroup>();
    private byte igmpType;
    private byte resField = 0;
    private short checksum = 0;
    private byte[] unsupportTypeData;

    public byte getIgmpType() {
        return this.igmpType;
    }

    public void setIgmpType(byte msgType) {
        this.igmpType = msgType;
    }

    public short getChecksum() {
        return this.checksum;
    }

    public byte getMaxRespField() {
        return this.resField;
    }

    public void setMaxRespCode(byte respCode) {
        if (this.igmpType != 17) {
            this.log.debug("Requesting the max response code for an incorrect field: ");
        }
        this.resField = respCode;
    }

    public List<IGMPGroup> getGroups() {
        return this.groups;
    }

    public boolean addGroup(IGMPGroup group) {
        Preconditions.checkNotNull((Object)group);
        switch (this.igmpType) {
            case 17: {
                if (group instanceof IGMPMembership) {
                    return false;
                }
                if (group.sources.size() <= 1) break;
                return false;
            }
            case 34: {
                if (!(group instanceof IGMPMembership)) break;
                return false;
            }
            default: {
                this.log.debug("Warning no IGMP message type has been set");
            }
        }
        this.groups.add(group);
        return true;
    }

    @Override
    public byte[] serialize() {
        byte[] data = new byte[8915];
        ByteBuffer bb = ByteBuffer.wrap(data);
        bb.put(this.getIgmpType());
        bb.put(this.resField);
        bb.putShort((short)0);
        switch (this.igmpType) {
            case 34: {
                bb.putShort((short)0);
                bb.putShort((short)this.groups.size());
            }
            case 17: {
                for (IGMPGroup grp : this.groups) {
                    grp.serialize(bb);
                }
                break;
            }
            default: {
                bb.put(this.unsupportTypeData);
            }
        }
        int size = bb.position();
        bb.position(0);
        byte[] rdata = new byte[size];
        bb.get(rdata, 0, size);
        return rdata;
    }

    @Override
    public IPacket deserialize(byte[] data, int offset, int length) {
        IGMP igmp = new IGMP();
        try {
            igmp = IGMP.deserializer().deserialize(data, offset, length);
        }
        catch (DeserializationException e) {
            this.log.error(e.getStackTrace().toString());
            return this;
        }
        this.igmpType = igmp.igmpType;
        this.resField = igmp.resField;
        this.checksum = igmp.checksum;
        this.groups = igmp.groups;
        return this;
    }

    public static Deserializer<IGMP> deserializer() {
        return (data, offset, length) -> {
            PacketUtils.checkInput(data, offset, length, 12);
            IGMP igmp = new IGMP();
            ByteBuffer bb = ByteBuffer.wrap(data, offset, length);
            igmp.igmpType = bb.get();
            igmp.resField = bb.get();
            igmp.checksum = bb.getShort();
            int len = 12;
            switch (igmp.igmpType) {
                case 17: {
                    IGMPQuery qgroup = new IGMPQuery();
                    qgroup.deserialize(bb);
                    igmp.groups.add(qgroup);
                    break;
                }
                case 34: {
                    bb.getShort();
                    for (int ngrps = bb.getShort(); ngrps > 0; --ngrps) {
                        IGMPMembership mgroup = new IGMPMembership();
                        mgroup.deserialize(bb);
                        igmp.groups.add(mgroup);
                    }
                    break;
                }
                case 18: 
                case 22: 
                case 23: {
                    igmp.unsupportTypeData = bb.array();
                    String msg = "IGMP message type: " + igmp.igmpType + " is not supported";
                    igmp.log.debug(msg);
                    break;
                }
                default: {
                    String msg = "IGMP message type: " + igmp.igmpType + " is not recognized";
                    igmp.unsupportTypeData = bb.array();
                    igmp.log.debug(msg);
                }
            }
            return igmp;
        };
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        if (!(obj instanceof IGMP)) {
            return false;
        }
        IGMP other = (IGMP)obj;
        if (this.igmpType != other.igmpType) {
            return false;
        }
        if (this.resField != other.resField) {
            return false;
        }
        if (this.checksum != other.checksum) {
            return false;
        }
        if (this.groups.size() != other.groups.size()) {
            return false;
        }
        return this.groups.equals(other.groups);
    }

    @Override
    public int hashCode() {
        int prime = 2521;
        int result = super.hashCode();
        result = 2521 * result + this.igmpType;
        result = 2521 * result + this.groups.size();
        result = 2521 * result + this.resField;
        result = 2521 * result + this.checksum;
        result = 2521 * result + this.groups.hashCode();
        return result;
    }

    public String toString() {
        return MoreObjects.toStringHelper(this.getClass()).add("igmpType", (Object)Byte.toString(this.igmpType)).add("resField", (Object)Byte.toString(this.resField)).add("checksum", (Object)Short.toString(this.checksum)).add("unsupportTypeData", (Object)Arrays.toString(this.unsupportTypeData)).toString();
    }
}

