/*
 * Decompiled with CFR 0.152.
 */
package org.onlab.packet;

import java.nio.ByteBuffer;
import org.onlab.packet.DeserializationException;
import org.onlab.packet.IGMPGroup;
import org.onlab.packet.Ip4Address;
import org.onlab.packet.IpAddress;
import org.onlab.packet.PacketUtils;

public class IGMPMembership
extends IGMPGroup {
    public static final byte MODE_IS_INCLUDE = 1;
    public static final byte MODE_IS_EXCLUDE = 2;
    public static final byte CHANGE_TO_INCLUDE_MODE = 3;
    public static final byte CHANGE_TO_EXCLUDE_MODE = 4;
    public static final byte ALLOW_NEW_SOURCES = 5;
    public static final byte BLOCK_OLD_SOURCES = 6;
    private final int minGroupRecordLen = 8;
    protected byte recordType;
    protected byte auxDataLength = 0;
    protected byte[] auxData;

    public IGMPMembership(Ip4Address gaddr) {
        super(gaddr, 0);
    }

    public IGMPMembership() {
    }

    @Override
    public byte[] serialize(ByteBuffer bb) {
        bb.put(this.recordType);
        bb.put(this.auxDataLength);
        bb.putShort((short)this.sources.size());
        bb.put(this.gaddr.toOctets());
        for (IpAddress ipaddr : this.sources) {
            bb.put(ipaddr.toOctets());
        }
        if (this.auxDataLength > 0) {
            bb.put(this.auxData);
        }
        return bb.array();
    }

    @Override
    public IGMPGroup deserialize(ByteBuffer bb) throws DeserializationException {
        int nsrcs;
        PacketUtils.checkBufferLength(bb.remaining(), 0, 8);
        this.recordType = bb.get();
        this.auxDataLength = bb.get();
        this.gaddr = Ip4Address.valueOf(bb.getInt());
        PacketUtils.checkBufferLength(bb.remaining(), 0, 4 * nsrcs);
        for (nsrcs = bb.getShort(); nsrcs > 0; --nsrcs) {
            Ip4Address src = Ip4Address.valueOf(bb.getInt());
            this.sources.add(src);
        }
        if (this.auxDataLength > 0) {
            this.auxData = new byte[this.auxDataLength];
            bb.get(this.auxData, 0, this.auxDataLength);
        }
        return this;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof IGMPMembership)) {
            return false;
        }
        IGMPMembership other = (IGMPMembership)obj;
        if (!this.gaddr.equals(other.gaddr)) {
            return false;
        }
        if (this.recordType != other.recordType) {
            return false;
        }
        if (this.auxDataLength != other.auxDataLength) {
            return false;
        }
        if (this.sources.size() != other.sources.size()) {
            return false;
        }
        return this.sources.equals(other.sources);
    }

    public int hashCode() {
        int prime = 2521;
        int result = super.hashCode();
        result = 2521 * result + this.gaddr.hashCode();
        result = 2521 * result + this.recordType;
        result = 2521 * result + this.auxDataLength;
        result = 2521 * result + this.sources.hashCode();
        return result;
    }
}

