/*
 * Decompiled with CFR 0.152.
 */
package org.onlab.packet.pim;

import java.nio.ByteBuffer;
import java.text.MessageFormat;
import org.onlab.packet.DeserializationException;
import org.onlab.packet.PacketUtils;

public class PIMHelloOption {
    public static final short OPT_HOLDTIME = 1;
    public static final short OPT_PRUNEDELAY = 2;
    public static final short OPT_PRIORITY = 19;
    public static final short OPT_GENID = 20;
    public static final short OPT_ADDRLIST = 24;
    public static final short DEFAULT_HOLDTIME = 105;
    public static final int DEFAULT_PRUNEDELAY = 2000;
    public static final int DEFAULT_PRIORITY = 1;
    public static final int DEFAULT_GENID = 0;
    public static final int MINIMUM_OPTION_LEN_BYTES = 4;
    private short optType;
    private short optLength;
    private byte[] optValue;

    public PIMHelloOption() {
    }

    public PIMHelloOption(short type) {
        this.optType = type;
        switch (type) {
            case 1: {
                this.optLength = (short)2;
                this.optValue = new byte[this.optLength];
                ByteBuffer.wrap(this.optValue).putShort((short)105);
                break;
            }
            case 2: {
                this.optLength = (short)4;
                this.optValue = new byte[this.optLength];
                ByteBuffer.wrap(this.optValue).putInt(2000);
                break;
            }
            case 19: {
                this.optLength = (short)4;
                this.optValue = new byte[this.optLength];
                ByteBuffer.wrap(this.optValue).putInt(1);
                break;
            }
            case 20: {
                this.optLength = (short)4;
                this.optValue = new byte[this.optLength];
                ByteBuffer.wrap(this.optValue).putInt(0);
                break;
            }
            case 24: {
                this.optLength = 0;
                this.optValue = null;
            }
            default: {
                return;
            }
        }
    }

    public void setOptType(short type) {
        this.optType = type;
    }

    public short getOptType() {
        return this.optType;
    }

    public void setOptLength(short len) {
        this.optLength = len;
    }

    public short getOptLength() {
        return this.optLength;
    }

    public void setValue(ByteBuffer bb) throws DeserializationException {
        this.optValue = new byte[this.optLength];
        bb.get(this.optValue, 0, this.optLength);
    }

    public byte[] getValue() {
        return this.optValue;
    }

    public static PIMHelloOption deserialize(ByteBuffer bb) throws DeserializationException {
        PacketUtils.checkInput(bb.array(), bb.position(), bb.limit() - bb.position(), 4);
        PIMHelloOption opt = new PIMHelloOption();
        opt.setOptType(bb.getShort());
        opt.setOptLength(bb.getShort());
        PacketUtils.checkBufferLength(bb.limit(), bb.position(), opt.getOptLength());
        opt.setValue(bb);
        return opt;
    }

    public byte[] serialize() {
        int len = 4 + this.optLength;
        ByteBuffer bb = ByteBuffer.allocate(len);
        bb.putShort(this.optType);
        bb.putShort(this.optLength);
        bb.put(this.optValue);
        return bb.array();
    }

    public String toString() {
        return MessageFormat.format("Type: {0}, len: {1} value: {2}", this.optType, this.optLength, this.optValue == null ? "null" : this.optValue.toString());
    }
}

