/*
 * Decompiled with CFR 0.152.
 */
package org.onlab.util;

import org.jboss.netty.buffer.ChannelBuffer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class HexDump {
    protected static final Logger log = LoggerFactory.getLogger(HexDump.class);

    private HexDump() {
    }

    public static void dump(ChannelBuffer buff) {
        try {
            byte[] yTemp = buff.array();
            int iStartIndex = buff.readerIndex();
            int iEndIndex = buff.writerIndex();
            do {
                StringBuilder sb = new StringBuilder();
                for (int k = 0; k < 16 && iStartIndex < iEndIndex; ++k) {
                    if (0 == k % 4) {
                        sb.append(String.format(" ", new Object[0]));
                    }
                    sb.append(String.format("%02X ", yTemp[iStartIndex++]));
                }
                log.debug(sb.toString());
            } while (iStartIndex < iEndIndex);
        }
        catch (Exception e) {
            log.error("[HexDump] Invalid buffer: " + e.toString());
        }
    }
}

