/*
 * Decompiled with CFR 0.152.
 */
package org.onlab.util;

import com.esotericsoftware.minlog.Log;
import junit.framework.TestCase;
import org.junit.Assert;
import org.junit.Test;
import org.onlab.util.HexString;

public class HexStringTest {
    @Test
    public void testMarshalling() throws Exception {
        String dpidStr = "00:00:00:23:20:2d:16:71";
        long dpid = HexString.toLong((String)dpidStr);
        String testStr = HexString.toHexString((long)dpid);
        TestCase.assertEquals((String)dpidStr, (String)testStr);
    }

    @Test
    public void testToLong() {
        String dpidStr = "3e:1f:01:fc:72:8c:63:31";
        long valid = 4476298738394751793L;
        long testLong = HexString.toLong((String)dpidStr);
        TestCase.assertEquals((long)valid, (long)testLong);
    }

    @Test
    public void testToLongMsb() {
        String dpidStr = "ca:7c:5e:d1:64:7a:95:9b";
        long valid = -3856102927509056101L;
        long testLong = HexString.toLong((String)dpidStr);
        TestCase.assertEquals((long)valid, (long)testLong);
    }

    @Test
    public void testToLongError() {
        String dpidStr = "09:08:07:06:05:04:03:02:01";
        try {
            HexString.toLong((String)dpidStr);
            Assert.fail((String)"HexString.toLong() should have thrown a NumberFormatException");
        }
        catch (NumberFormatException expected) {
            Log.info((String)"HexString.toLong() have thrown a NumberFormatException");
        }
    }

    @Test
    public void testToStringBytes() {
        byte[] dpid = new byte[]{0, 0, 0, 0, 0, 0, 0, -1};
        String valid = "00:00:00:00:00:00:00:ff";
        String testString = HexString.toHexString((byte[])dpid);
        TestCase.assertEquals((String)valid, (String)testString);
    }

    @Test
    public void testFromHexStringError() {
        String invalidStr = "00:00:00:00:00:00:ffff";
        try {
            HexString.fromHexString((String)invalidStr);
            Assert.fail((String)"HexString.fromHexString() should have thrown a NumberFormatException");
        }
        catch (NumberFormatException expected) {
            Log.info((String)"HexString.toLong() have thrown a NumberFormatException");
        }
    }
}

