/*
 * Decompiled with CFR 0.152.
 */
package org.onlab.packet;

import org.onlab.packet.Ip4Address;
import org.onlab.packet.IpAddress;
import org.onlab.packet.IpPrefix;

public final class Ip4Prefix
extends IpPrefix {
    public static final IpAddress.Version VERSION = IpAddress.Version.INET;
    public static final int MAX_MASK_LENGTH = 32;

    private Ip4Prefix(Ip4Address address, int prefixLength) {
        super(address, prefixLength);
    }

    @Override
    public Ip4Address address() {
        IpAddress a = super.address();
        return (Ip4Address)a;
    }

    public static Ip4Prefix valueOf(int address, int prefixLength) {
        return new Ip4Prefix(Ip4Address.valueOf(address), prefixLength);
    }

    public static Ip4Prefix valueOf(byte[] address, int prefixLength) {
        return new Ip4Prefix(Ip4Address.valueOf(address), prefixLength);
    }

    public static Ip4Prefix valueOf(Ip4Address address, int prefixLength) {
        return new Ip4Prefix(address, prefixLength);
    }

    public static Ip4Prefix valueOf(String address) {
        String[] parts = address.split("/");
        if (parts.length != 2) {
            String msg = "Malformed IPv4 prefix string: " + address + ". " + "Address must take form \"x.x.x.x/y\"";
            throw new IllegalArgumentException(msg);
        }
        Ip4Address ipAddress = Ip4Address.valueOf(parts[0]);
        int prefixLength = Integer.parseInt(parts[1]);
        return new Ip4Prefix(ipAddress, prefixLength);
    }
}

