/*
 * Decompiled with CFR 0.152.
 */
package org.onlab.packet;

import org.onlab.util.Identifier;

public class VlanId
extends Identifier<Short> {
    public static final short UNTAGGED = -1;
    public static final short ANY_VALUE = 4096;
    public static final VlanId NONE = VlanId.vlanId((short)-1);
    public static final VlanId ANY = VlanId.vlanId((short)4096);
    public static final short MAX_VLAN = 4095;

    protected VlanId() {
        super((short)-1);
    }

    protected VlanId(short value) {
        super(value);
    }

    public static VlanId vlanId() {
        return new VlanId(-1);
    }

    public static VlanId vlanId(short value) {
        if (value == -1) {
            return new VlanId();
        }
        if (value == 4096) {
            return new VlanId(4096);
        }
        if (value > 4095) {
            throw new IllegalArgumentException("value exceeds allowed maximum VLAN ID value (4095)");
        }
        return new VlanId(value);
    }

    public short toShort() {
        return (Short)this.identifier;
    }

    @Override
    public String toString() {
        if ((Short)this.identifier == 4096) {
            return "Any";
        }
        return String.valueOf(this.identifier);
    }
}

