/*
 * Decompiled with CFR 0.152.
 */
package org.onlab.util;

import com.google.common.collect.ComparisonChain;
import org.onlab.util.DataRateUnit;
import org.onlab.util.DoubleBandwidth;
import org.onlab.util.LongBandwidth;
import org.onlab.util.RichComparable;

public interface Bandwidth
extends RichComparable<Bandwidth> {
    public static Bandwidth of(long v, DataRateUnit unit) {
        return new LongBandwidth(unit.toBitsPerSecond(v));
    }

    public static Bandwidth of(double v, DataRateUnit unit) {
        return new DoubleBandwidth(unit.toBitsPerSecond(v));
    }

    public static Bandwidth bps(long bps) {
        return new LongBandwidth(bps);
    }

    public static Bandwidth bps(double bps) {
        return new DoubleBandwidth(bps);
    }

    public static Bandwidth kbps(long kbps) {
        return Bandwidth.bps(kbps * 1000L);
    }

    public static Bandwidth kbps(double kbps) {
        return Bandwidth.bps(kbps * 1000.0);
    }

    public static Bandwidth mbps(long mbps) {
        return Bandwidth.bps(mbps * 1000000L);
    }

    public static Bandwidth mbps(double mbps) {
        return Bandwidth.bps(mbps * 1000000.0);
    }

    public static Bandwidth gbps(long gbps) {
        return Bandwidth.bps(gbps * 1000000000L);
    }

    public static Bandwidth gbps(double gbps) {
        return Bandwidth.bps(gbps * 1.0E9);
    }

    public double bps();

    default public Bandwidth add(Bandwidth value) {
        return Bandwidth.bps(this.bps() + value.bps());
    }

    default public Bandwidth subtract(Bandwidth value) {
        return Bandwidth.bps(this.bps() - value.bps());
    }

    @Override
    default public int compareTo(Bandwidth other) {
        return ComparisonChain.start().compare(this.bps(), other.bps()).result();
    }
}

