/*
 * Decompiled with CFR 0.152.
 */
package org.onlab.util;

import com.google.common.base.Preconditions;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import org.onlab.util.SharedScheduledExecutorService;
import org.onlab.util.Tools;

public final class SharedScheduledExecutors {
    public static final int DEFAULT_POOL_SIZE = 30;
    private static SharedScheduledExecutorService singleThreadExecutor = new SharedScheduledExecutorService(Executors.newSingleThreadScheduledExecutor(Tools.groupedThreads("onos/shared/scheduled", "onos-single-executor")));
    private static SharedScheduledExecutorService poolThreadExecutor = new SharedScheduledExecutorService(Executors.newScheduledThreadPool(30, Tools.groupedThreads("onos/shared/scheduled", "onos-pool-executor-%d")));

    private SharedScheduledExecutors() {
    }

    public static ScheduledExecutorService getSingleThreadExecutor() {
        return singleThreadExecutor;
    }

    public static ScheduledExecutorService getPoolThreadExecutor() {
        return poolThreadExecutor;
    }

    public static void setPoolSize(int poolSize) {
        Preconditions.checkArgument((poolSize > 0 ? 1 : 0) != 0, (Object)"Shared pool size size must be greater than 0");
        poolThreadExecutor.setBackingExecutor(Executors.newScheduledThreadPool(poolSize, Tools.groupedThreads("onos/shared/scheduled", "onos-pool-executor-%d")));
    }

    public static void shutdown() {
        singleThreadExecutor.backingExecutor().shutdown();
        poolThreadExecutor.backingExecutor().shutdown();
    }
}

