/*
 * Decompiled with CFR 0.152.
 */
package org.onlab.graph;

import java.util.Set;
import org.junit.Assert;
import org.junit.Test;
import org.onlab.graph.AbstractGraphPathSearch;
import org.onlab.graph.AbstractGraphPathSearchTest;
import org.onlab.graph.AdjacencyListsGraph;
import org.onlab.graph.BreadthFirstSearch;
import org.onlab.graph.EdgeWeight;
import org.onlab.graph.Graph;
import org.onlab.graph.GraphPathSearch;
import org.onlab.graph.Path;
import org.onlab.graph.TestEdge;
import org.onlab.graph.TestVertex;
import org.onlab.graph.Vertex;

public class BreadthFirstSearchTest
extends AbstractGraphPathSearchTest {
    @Override
    protected AbstractGraphPathSearch<TestVertex, TestEdge> graphSearch() {
        return new BreadthFirstSearch();
    }

    @Test
    public void defaultGraphTest() {
        this.executeDefaultTest(7, 3, 8.0);
    }

    @Test
    public void defaultHopCountWeight() {
        this.weight = null;
        this.executeDefaultTest(7, 3, 3.0);
    }

    protected void executeDefaultTest(int pathCount, int pathLength, double pathCost) {
        this.graph = new AdjacencyListsGraph(this.vertexes(), this.edges());
        AbstractGraphPathSearch<TestVertex, TestEdge> search = this.graphSearch();
        Set paths = search.search(this.graph, (Vertex)A, (Vertex)H, this.weight, -1).paths();
        Assert.assertEquals((String)"incorrect paths count", (long)1L, (long)paths.size());
        Path p = (Path)paths.iterator().next();
        Assert.assertEquals((String)"incorrect src", (Object)A, (Object)p.src());
        Assert.assertEquals((String)"incorrect dst", (Object)H, (Object)p.dst());
        Assert.assertEquals((String)"incorrect path length", (long)pathLength, (long)p.edges().size());
        Assert.assertEquals((String)"incorrect path cost", (double)pathCost, (double)p.cost(), (double)0.1);
        paths = search.search(this.graph, (Vertex)A, null, this.weight, -1).paths();
        this.printPaths(paths);
        Assert.assertEquals((String)"incorrect paths count", (long)pathCount, (long)paths.size());
    }

    protected void executeSearch(GraphPathSearch<TestVertex, TestEdge> search, Graph<TestVertex, TestEdge> graph, TestVertex src, TestVertex dst, EdgeWeight<TestVertex, TestEdge> weight, int pathCount, double pathCost) {
        GraphPathSearch.Result result = search.search(graph, (Vertex)src, (Vertex)dst, weight, -1);
        Set paths = result.paths();
        this.printPaths(paths);
        Assert.assertEquals((String)"incorrect paths count", (long)pathCount, (long)paths.size());
        if (pathCount > 0) {
            Path path = (Path)paths.iterator().next();
            Assert.assertEquals((String)"incorrect path cost", (double)pathCost, (double)path.cost(), (double)0.1);
        }
    }

    protected void executeSinglePathSearch(GraphPathSearch<TestVertex, TestEdge> search, Graph<TestVertex, TestEdge> graph, TestVertex src, TestVertex dst, EdgeWeight<TestVertex, TestEdge> weight, int pathCount, double pathCost) {
        GraphPathSearch.Result result = search.search(graph, (Vertex)src, (Vertex)dst, weight, 1);
        Set paths = result.paths();
        this.printPaths(paths);
        Assert.assertEquals((String)"incorrect paths count", (long)Math.min(pathCount, 1), (long)paths.size());
        if (pathCount > 0) {
            Path path = (Path)paths.iterator().next();
            Assert.assertEquals((String)"incorrect path cost", (double)pathCost, (double)path.cost(), (double)0.1);
        }
    }
}

