/*
 * Decompiled with CFR 0.152.
 */
package org.onlab.packet;

import java.nio.ByteBuffer;
import java.util.Arrays;
import org.apache.commons.lang3.StringUtils;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.onlab.packet.ARP;
import org.onlab.packet.Deserializer;
import org.onlab.packet.Ip4Address;
import org.onlab.packet.MacAddress;
import org.onlab.packet.PacketTestUtils;

public class ArpTest {
    private Deserializer<ARP> deserializer = ARP.deserializer();
    private final byte hwAddressLength = (byte)6;
    private final byte protoAddressLength = (byte)4;
    private MacAddress srcMac = MacAddress.valueOf((long)1L);
    private MacAddress targetMac = MacAddress.valueOf((long)2L);
    private Ip4Address srcIp = Ip4Address.valueOf((int)1);
    private Ip4Address targetIp = Ip4Address.valueOf((int)2);
    private byte[] byteHeader;

    @Before
    public void setUp() {
        ByteBuffer bb = ByteBuffer.allocate(28);
        bb.putShort((short)1);
        bb.putShort((short)2048);
        bb.put((byte)6);
        bb.put((byte)4);
        bb.putShort((short)2);
        bb.put(this.srcMac.toBytes());
        bb.put(this.srcIp.toOctets());
        bb.put(this.targetMac.toBytes());
        bb.put(this.targetIp.toOctets());
        this.byteHeader = bb.array();
    }

    @Test
    public void testDeserializeBadInput() throws Exception {
        PacketTestUtils.testDeserializeBadInput(this.deserializer);
    }

    @Test
    public void testDeserializeTruncated() throws Exception {
        PacketTestUtils.testDeserializeTruncated(this.deserializer, this.byteHeader);
    }

    @Test
    public void testDeserialize() throws Exception {
        ARP arp = (ARP)this.deserializer.deserialize(this.byteHeader, 0, this.byteHeader.length);
        Assert.assertEquals((long)1L, (long)arp.getHardwareType());
        Assert.assertEquals((long)2048L, (long)arp.getProtocolType());
        Assert.assertEquals((long)6L, (long)arp.getHardwareAddressLength());
        Assert.assertEquals((long)4L, (long)arp.getProtocolAddressLength());
        Assert.assertEquals((long)2L, (long)arp.getOpCode());
        Assert.assertTrue((boolean)Arrays.equals(this.srcMac.toBytes(), arp.getSenderHardwareAddress()));
        Assert.assertTrue((boolean)Arrays.equals(this.srcIp.toOctets(), arp.getSenderProtocolAddress()));
        Assert.assertTrue((boolean)Arrays.equals(this.targetMac.toBytes(), arp.getTargetHardwareAddress()));
        Assert.assertTrue((boolean)Arrays.equals(this.targetIp.toOctets(), arp.getTargetProtocolAddress()));
    }

    @Test
    public void testToStringArp() throws Exception {
        ARP arp = (ARP)this.deserializer.deserialize(this.byteHeader, 0, this.byteHeader.length);
        String str = arp.toString();
        Assert.assertTrue((boolean)StringUtils.contains((CharSequence)str, (CharSequence)"hardwareAddressLength=6"));
        Assert.assertTrue((boolean)StringUtils.contains((CharSequence)str, (CharSequence)"protocolAddressLength=4"));
        Assert.assertTrue((boolean)StringUtils.contains((CharSequence)str, (CharSequence)("senderHardwareAddress=" + Arrays.toString(this.srcMac.toBytes()))));
        Assert.assertTrue((boolean)StringUtils.contains((CharSequence)str, (CharSequence)("senderProtocolAddress=" + Arrays.toString(this.srcIp.toOctets()))));
        Assert.assertTrue((boolean)StringUtils.contains((CharSequence)str, (CharSequence)("targetHardwareAddress=" + Arrays.toString(this.targetMac.toBytes()))));
        Assert.assertTrue((boolean)StringUtils.contains((CharSequence)str, (CharSequence)("targetProtocolAddress=" + Arrays.toString(this.targetIp.toOctets()))));
    }
}

