/*
 * Decompiled with CFR 0.152.
 */
package org.onlab.packet;

import com.google.common.testing.EqualsTester;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.Test;
import org.onlab.junit.ImmutableClassChecker;
import org.onlab.packet.Ip6Address;
import org.onlab.packet.Ip6Prefix;
import org.onlab.packet.IpAddress;
import org.onlab.packet.IpPrefix;

public class Ip6PrefixTest {
    @Test
    public void testImmutable() {
        ImmutableClassChecker.assertThatClassIsImmutable(Ip6Prefix.class);
    }

    @Test
    public void testAddressVersion() {
        Assert.assertThat((Object)Ip6Prefix.VERSION, (Matcher)Matchers.is((Object)IpAddress.Version.INET6));
    }

    @Test
    public void testMaxMaskLength() {
        Assert.assertThat((Object)128, (Matcher)Matchers.is((Object)128));
    }

    @Test
    public void testVersion() {
        Ip6Prefix ipPrefix = Ip6Prefix.valueOf((String)"::/0");
        Assert.assertThat((Object)ipPrefix.version(), (Matcher)Matchers.is((Object)IpAddress.Version.INET6));
    }

    @Test
    public void testAddressAndPrefixLengthIPv6() {
        Ip6Prefix ipPrefix = Ip6Prefix.valueOf((String)"1100::/8");
        Assert.assertThat((Object)ipPrefix.address(), (Matcher)Matchers.equalTo((Object)Ip6Address.valueOf((String)"1100::")));
        Assert.assertThat((Object)ipPrefix.prefixLength(), (Matcher)Matchers.is((Object)8));
        ipPrefix = Ip6Prefix.valueOf((String)"1111:2222:3333:4444:5555:6666:7777:8885/8");
        Assert.assertThat((Object)ipPrefix.address(), (Matcher)Matchers.equalTo((Object)Ip6Address.valueOf((String)"1100::")));
        Assert.assertThat((Object)ipPrefix.prefixLength(), (Matcher)Matchers.is((Object)8));
        ipPrefix = Ip6Prefix.valueOf((String)"1111:2222:3333:4444:5555:6666:7777:8800/120");
        Assert.assertThat((Object)ipPrefix.address(), (Matcher)Matchers.equalTo((Object)Ip6Address.valueOf((String)"1111:2222:3333:4444:5555:6666:7777:8800")));
        Assert.assertThat((Object)ipPrefix.prefixLength(), (Matcher)Matchers.is((Object)120));
        ipPrefix = Ip6Prefix.valueOf((String)"1111:2222:3333:4444:5555:6666:7777:8885/128");
        Assert.assertThat((Object)ipPrefix.address(), (Matcher)Matchers.equalTo((Object)Ip6Address.valueOf((String)"1111:2222:3333:4444:5555:6666:7777:8885")));
        Assert.assertThat((Object)ipPrefix.prefixLength(), (Matcher)Matchers.is((Object)128));
        ipPrefix = Ip6Prefix.valueOf((String)"::/0");
        Assert.assertThat((Object)ipPrefix.address(), (Matcher)Matchers.equalTo((Object)Ip6Address.valueOf((String)"::")));
        Assert.assertThat((Object)ipPrefix.prefixLength(), (Matcher)Matchers.is((Object)0));
        ipPrefix = Ip6Prefix.valueOf((String)"ffff:ffff:ffff:ffff:ffff:ffff:ffff:ffff/128");
        Assert.assertThat((Object)ipPrefix.address(), (Matcher)Matchers.equalTo((Object)Ip6Address.valueOf((String)"ffff:ffff:ffff:ffff:ffff:ffff:ffff:ffff")));
        Assert.assertThat((Object)ipPrefix.prefixLength(), (Matcher)Matchers.is((Object)128));
        ipPrefix = Ip6Prefix.valueOf((String)"1111:2222:3333:4444:5555:6666:7777:8885/64");
        Assert.assertThat((Object)ipPrefix.address(), (Matcher)Matchers.equalTo((Object)Ip6Address.valueOf((String)"1111:2222:3333:4444::")));
        Assert.assertThat((Object)ipPrefix.prefixLength(), (Matcher)Matchers.is((Object)64));
    }

    @Test
    public void testValueOfByteArrayIPv6() {
        byte[] value = new byte[]{17, 17, 34, 34, 51, 51, 68, 68, 85, 85, 102, 102, 119, 119, -120, -120};
        Ip6Prefix ipPrefix = Ip6Prefix.valueOf((byte[])value, (int)120);
        Assert.assertThat((Object)ipPrefix.toString(), (Matcher)Matchers.is((Object)"1111:2222:3333:4444:5555:6666:7777:8800/120"));
        ipPrefix = Ip6Prefix.valueOf((byte[])value, (int)128);
        Assert.assertThat((Object)ipPrefix.toString(), (Matcher)Matchers.is((Object)"1111:2222:3333:4444:5555:6666:7777:8888/128"));
        value = new byte[]{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0};
        ipPrefix = Ip6Prefix.valueOf((byte[])value, (int)0);
        Assert.assertThat((Object)ipPrefix.toString(), (Matcher)Matchers.is((Object)"::/0"));
        ipPrefix = Ip6Prefix.valueOf((byte[])value, (int)128);
        Assert.assertThat((Object)ipPrefix.toString(), (Matcher)Matchers.is((Object)"::/128"));
        value = new byte[]{-1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1};
        ipPrefix = Ip6Prefix.valueOf((byte[])value, (int)0);
        Assert.assertThat((Object)ipPrefix.toString(), (Matcher)Matchers.is((Object)"::/0"));
        ipPrefix = Ip6Prefix.valueOf((byte[])value, (int)64);
        Assert.assertThat((Object)ipPrefix.toString(), (Matcher)Matchers.is((Object)"ffff:ffff:ffff:ffff::/64"));
        ipPrefix = Ip6Prefix.valueOf((byte[])value, (int)128);
        Assert.assertThat((Object)ipPrefix.toString(), (Matcher)Matchers.is((Object)"ffff:ffff:ffff:ffff:ffff:ffff:ffff:ffff/128"));
    }

    @Test(expected=NullPointerException.class)
    public void testInvalidValueOfNullArrayIPv6() {
        byte[] value = null;
        Ip6Prefix ipPrefix = Ip6Prefix.valueOf(value, (int)120);
    }

    @Test(expected=IllegalArgumentException.class)
    public void testInvalidValueOfShortArrayIPv6() {
        byte[] value = new byte[]{1, 2, 3, 4, 5, 6, 7, 8, 9};
        Ip6Prefix ipPrefix = Ip6Prefix.valueOf((byte[])value, (int)120);
    }

    @Test(expected=IllegalArgumentException.class)
    public void testInvalidValueOfByteArrayNegativePrefixLengthIPv6() {
        byte[] value = new byte[]{17, 17, 34, 34, 51, 51, 68, 68, 85, 85, 102, 102, 119, 119, -120, -120};
        Ip6Prefix ipPrefix = Ip6Prefix.valueOf((byte[])value, (int)-1);
    }

    @Test(expected=IllegalArgumentException.class)
    public void testInvalidValueOfByteArrayTooLongPrefixLengthIPv6() {
        byte[] value = new byte[]{17, 17, 34, 34, 51, 51, 68, 68, 85, 85, 102, 102, 119, 119, -120, -120};
        Ip6Prefix ipPrefix = Ip6Prefix.valueOf((byte[])value, (int)129);
    }

    @Test
    public void testValueOfAddressIPv6() {
        Ip6Address ipAddress = Ip6Address.valueOf((String)"1111:2222:3333:4444:5555:6666:7777:8888");
        Ip6Prefix ipPrefix = Ip6Prefix.valueOf((Ip6Address)ipAddress, (int)120);
        Assert.assertThat((Object)ipPrefix.toString(), (Matcher)Matchers.is((Object)"1111:2222:3333:4444:5555:6666:7777:8800/120"));
        ipPrefix = Ip6Prefix.valueOf((Ip6Address)ipAddress, (int)128);
        Assert.assertThat((Object)ipPrefix.toString(), (Matcher)Matchers.is((Object)"1111:2222:3333:4444:5555:6666:7777:8888/128"));
        ipAddress = Ip6Address.valueOf((String)"::");
        ipPrefix = Ip6Prefix.valueOf((Ip6Address)ipAddress, (int)0);
        Assert.assertThat((Object)ipPrefix.toString(), (Matcher)Matchers.is((Object)"::/0"));
        ipPrefix = Ip6Prefix.valueOf((Ip6Address)ipAddress, (int)128);
        Assert.assertThat((Object)ipPrefix.toString(), (Matcher)Matchers.is((Object)"::/128"));
        ipAddress = Ip6Address.valueOf((String)"ffff:ffff:ffff:ffff:ffff:ffff:ffff:ffff");
        ipPrefix = Ip6Prefix.valueOf((Ip6Address)ipAddress, (int)0);
        Assert.assertThat((Object)ipPrefix.toString(), (Matcher)Matchers.is((Object)"::/0"));
        ipPrefix = Ip6Prefix.valueOf((Ip6Address)ipAddress, (int)64);
        Assert.assertThat((Object)ipPrefix.toString(), (Matcher)Matchers.is((Object)"ffff:ffff:ffff:ffff::/64"));
        ipPrefix = Ip6Prefix.valueOf((Ip6Address)ipAddress, (int)128);
        Assert.assertThat((Object)ipPrefix.toString(), (Matcher)Matchers.is((Object)"ffff:ffff:ffff:ffff:ffff:ffff:ffff:ffff/128"));
    }

    @Test(expected=NullPointerException.class)
    public void testInvalidValueOfNullAddress() {
        Ip6Address ipAddress = null;
        Ip6Prefix ipPrefix = Ip6Prefix.valueOf(ipAddress, (int)24);
    }

    @Test(expected=IllegalArgumentException.class)
    public void testInvalidValueOfAddressNegativePrefixLengthIPv6() {
        Ip6Address ipAddress = Ip6Address.valueOf((String)"1111:2222:3333:4444:5555:6666:7777:8888");
        Ip6Prefix ipPrefix = Ip6Prefix.valueOf((Ip6Address)ipAddress, (int)-1);
    }

    @Test(expected=IllegalArgumentException.class)
    public void testInvalidValueOfAddressTooLongPrefixLengthIPv6() {
        Ip6Address ipAddress = Ip6Address.valueOf((String)"1111:2222:3333:4444:5555:6666:7777:8888");
        Ip6Prefix ipPrefix = Ip6Prefix.valueOf((Ip6Address)ipAddress, (int)129);
    }

    @Test
    public void testValueOfStringIPv6() {
        Ip6Prefix ipPrefix = Ip6Prefix.valueOf((String)"1111:2222:3333:4444:5555:6666:7777:8888/120");
        Assert.assertThat((Object)ipPrefix.toString(), (Matcher)Matchers.is((Object)"1111:2222:3333:4444:5555:6666:7777:8800/120"));
        ipPrefix = Ip6Prefix.valueOf((String)"1111:2222:3333:4444:5555:6666:7777:8888/128");
        Assert.assertThat((Object)ipPrefix.toString(), (Matcher)Matchers.is((Object)"1111:2222:3333:4444:5555:6666:7777:8888/128"));
        ipPrefix = Ip6Prefix.valueOf((String)"::/0");
        Assert.assertThat((Object)ipPrefix.toString(), (Matcher)Matchers.is((Object)"::/0"));
        ipPrefix = Ip6Prefix.valueOf((String)"::/128");
        Assert.assertThat((Object)ipPrefix.toString(), (Matcher)Matchers.is((Object)"::/128"));
        ipPrefix = Ip6Prefix.valueOf((String)"ffff:ffff:ffff:ffff:ffff:ffff:ffff:ffff/0");
        Assert.assertThat((Object)ipPrefix.toString(), (Matcher)Matchers.is((Object)"::/0"));
        ipPrefix = Ip6Prefix.valueOf((String)"ffff:ffff:ffff:ffff:ffff:ffff:ffff:ffff/64");
        Assert.assertThat((Object)ipPrefix.toString(), (Matcher)Matchers.is((Object)"ffff:ffff:ffff:ffff::/64"));
        ipPrefix = Ip6Prefix.valueOf((String)"ffff:ffff:ffff:ffff:ffff:ffff:ffff:ffff/128");
        Assert.assertThat((Object)ipPrefix.toString(), (Matcher)Matchers.is((Object)"ffff:ffff:ffff:ffff:ffff:ffff:ffff:ffff/128"));
    }

    @Test(expected=NullPointerException.class)
    public void testInvalidValueOfNullString() {
        String fromString = null;
        Ip6Prefix ipPrefix = Ip6Prefix.valueOf(fromString);
    }

    @Test(expected=IllegalArgumentException.class)
    public void testInvalidValueOfEmptyString() {
        String fromString = "";
        Ip6Prefix ipPrefix = Ip6Prefix.valueOf((String)fromString);
    }

    @Test(expected=IllegalArgumentException.class)
    public void testInvalidValueOfIncorrectString() {
        String fromString = "NoSuchIpPrefix";
        Ip6Prefix ipPrefix = Ip6Prefix.valueOf((String)fromString);
    }

    @Test(expected=IllegalArgumentException.class)
    public void testInvalidValueOfStringNegativePrefixLengthIPv6() {
        Ip6Prefix ipPrefix = Ip6Prefix.valueOf((String)"1111:2222:3333:4444:5555:6666:7777:8888/-1");
    }

    @Test(expected=IllegalArgumentException.class)
    public void testInvalidValueOfStringTooLongPrefixLengthIPv6() {
        Ip6Prefix ipPrefix = Ip6Prefix.valueOf((String)"1111:2222:3333:4444:5555:6666:7777:8888/129");
    }

    @Test
    public void testContainsIpPrefixIPv6() {
        Ip6Prefix ipPrefix = Ip6Prefix.valueOf((String)"1111:2222:3333:4444::/120");
        Assert.assertTrue((boolean)ipPrefix.contains((IpPrefix)Ip6Prefix.valueOf((String)"1111:2222:3333:4444::/120")));
        Assert.assertTrue((boolean)ipPrefix.contains((IpPrefix)Ip6Prefix.valueOf((String)"1111:2222:3333:4444::/128")));
        Assert.assertTrue((boolean)ipPrefix.contains((IpPrefix)Ip6Prefix.valueOf((String)"1111:2222:3333:4444::1/128")));
        Assert.assertFalse((boolean)ipPrefix.contains((IpPrefix)Ip6Prefix.valueOf((String)"1111:2222:3333:4444::/64")));
        Assert.assertFalse((boolean)ipPrefix.contains((IpPrefix)Ip6Prefix.valueOf((String)"1111:2222:3333:4445::/120")));
        Assert.assertFalse((boolean)ipPrefix.contains((IpPrefix)Ip6Prefix.valueOf((String)"::/64")));
        Assert.assertFalse((boolean)ipPrefix.contains((IpPrefix)Ip6Prefix.valueOf((String)"::/0")));
        Assert.assertFalse((boolean)ipPrefix.contains((IpPrefix)Ip6Prefix.valueOf((String)"ffff:ffff:ffff:ffff:ffff:ffff:ffff:ffff/128")));
        ipPrefix = Ip6Prefix.valueOf((String)"1111:2222:3333:4444::/128");
        Assert.assertFalse((boolean)ipPrefix.contains((IpPrefix)Ip6Prefix.valueOf((String)"1111:2222:3333:4444::/120")));
        Assert.assertTrue((boolean)ipPrefix.contains((IpPrefix)Ip6Prefix.valueOf((String)"1111:2222:3333:4444::/128")));
        Assert.assertFalse((boolean)ipPrefix.contains((IpPrefix)Ip6Prefix.valueOf((String)"1111:2222:3333:4444::1/128")));
        Assert.assertFalse((boolean)ipPrefix.contains((IpPrefix)Ip6Prefix.valueOf((String)"1111:2222:3333:4444::/64")));
        Assert.assertFalse((boolean)ipPrefix.contains((IpPrefix)Ip6Prefix.valueOf((String)"1111:2222:3333:4445::/120")));
        Assert.assertFalse((boolean)ipPrefix.contains((IpPrefix)Ip6Prefix.valueOf((String)"::/64")));
        Assert.assertFalse((boolean)ipPrefix.contains((IpPrefix)Ip6Prefix.valueOf((String)"::/0")));
        Assert.assertFalse((boolean)ipPrefix.contains((IpPrefix)Ip6Prefix.valueOf((String)"ffff:ffff:ffff:ffff:ffff:ffff:ffff:ffff/128")));
        ipPrefix = Ip6Prefix.valueOf((String)"::/0");
        Assert.assertTrue((boolean)ipPrefix.contains((IpPrefix)Ip6Prefix.valueOf((String)"1111:2222:3333:4444::/120")));
        Assert.assertTrue((boolean)ipPrefix.contains((IpPrefix)Ip6Prefix.valueOf((String)"1111:2222:3333:4444::/128")));
        Assert.assertTrue((boolean)ipPrefix.contains((IpPrefix)Ip6Prefix.valueOf((String)"1111:2222:3333:4444::1/128")));
        Assert.assertTrue((boolean)ipPrefix.contains((IpPrefix)Ip6Prefix.valueOf((String)"1111:2222:3333:4444::/64")));
        Assert.assertTrue((boolean)ipPrefix.contains((IpPrefix)Ip6Prefix.valueOf((String)"1111:2222:3333:4445::/120")));
        Assert.assertTrue((boolean)ipPrefix.contains((IpPrefix)Ip6Prefix.valueOf((String)"::/64")));
        Assert.assertTrue((boolean)ipPrefix.contains((IpPrefix)Ip6Prefix.valueOf((String)"::/0")));
        Assert.assertTrue((boolean)ipPrefix.contains((IpPrefix)Ip6Prefix.valueOf((String)"ffff:ffff:ffff:ffff:ffff:ffff:ffff:ffff/128")));
        ipPrefix = Ip6Prefix.valueOf((String)"ffff:ffff:ffff:ffff:ffff:ffff:ffff:ffff/128");
        Assert.assertFalse((boolean)ipPrefix.contains((IpPrefix)Ip6Prefix.valueOf((String)"1111:2222:3333:4444::/120")));
        Assert.assertFalse((boolean)ipPrefix.contains((IpPrefix)Ip6Prefix.valueOf((String)"1111:2222:3333:4444::/128")));
        Assert.assertFalse((boolean)ipPrefix.contains((IpPrefix)Ip6Prefix.valueOf((String)"1111:2222:3333:4444::1/128")));
        Assert.assertFalse((boolean)ipPrefix.contains((IpPrefix)Ip6Prefix.valueOf((String)"1111:2222:3333:4444::/64")));
        Assert.assertFalse((boolean)ipPrefix.contains((IpPrefix)Ip6Prefix.valueOf((String)"1111:2222:3333:4445::/120")));
        Assert.assertFalse((boolean)ipPrefix.contains((IpPrefix)Ip6Prefix.valueOf((String)"::/64")));
        Assert.assertFalse((boolean)ipPrefix.contains((IpPrefix)Ip6Prefix.valueOf((String)"::/0")));
        Assert.assertTrue((boolean)ipPrefix.contains((IpPrefix)Ip6Prefix.valueOf((String)"ffff:ffff:ffff:ffff:ffff:ffff:ffff:ffff/128")));
    }

    @Test
    public void testContainsIpAddressIPv6() {
        Ip6Prefix ipPrefix = Ip6Prefix.valueOf((String)"1111:2222:3333:4444::/120");
        Assert.assertTrue((boolean)ipPrefix.contains((IpAddress)Ip6Address.valueOf((String)"1111:2222:3333:4444::")));
        Assert.assertTrue((boolean)ipPrefix.contains((IpAddress)Ip6Address.valueOf((String)"1111:2222:3333:4444::1")));
        Assert.assertFalse((boolean)ipPrefix.contains((IpAddress)Ip6Address.valueOf((String)"1111:2222:3333:4445::")));
        Assert.assertFalse((boolean)ipPrefix.contains((IpAddress)Ip6Address.valueOf((String)"::")));
        Assert.assertFalse((boolean)ipPrefix.contains((IpAddress)Ip6Address.valueOf((String)"ffff:ffff:ffff:ffff:ffff:ffff:ffff:ffff")));
        ipPrefix = Ip6Prefix.valueOf((String)"1111:2222:3333:4444::/128");
        Assert.assertTrue((boolean)ipPrefix.contains((IpAddress)Ip6Address.valueOf((String)"1111:2222:3333:4444::")));
        Assert.assertFalse((boolean)ipPrefix.contains((IpAddress)Ip6Address.valueOf((String)"1111:2222:3333:4444::1")));
        Assert.assertFalse((boolean)ipPrefix.contains((IpAddress)Ip6Address.valueOf((String)"1111:2222:3333:4445::")));
        Assert.assertFalse((boolean)ipPrefix.contains((IpAddress)Ip6Address.valueOf((String)"::")));
        Assert.assertFalse((boolean)ipPrefix.contains((IpAddress)Ip6Address.valueOf((String)"ffff:ffff:ffff:ffff:ffff:ffff:ffff:ffff")));
        ipPrefix = Ip6Prefix.valueOf((String)"::/0");
        Assert.assertTrue((boolean)ipPrefix.contains((IpAddress)Ip6Address.valueOf((String)"1111:2222:3333:4444::")));
        Assert.assertTrue((boolean)ipPrefix.contains((IpAddress)Ip6Address.valueOf((String)"1111:2222:3333:4444::1")));
        Assert.assertTrue((boolean)ipPrefix.contains((IpAddress)Ip6Address.valueOf((String)"1111:2222:3333:4445::")));
        Assert.assertTrue((boolean)ipPrefix.contains((IpAddress)Ip6Address.valueOf((String)"::")));
        Assert.assertTrue((boolean)ipPrefix.contains((IpAddress)Ip6Address.valueOf((String)"ffff:ffff:ffff:ffff:ffff:ffff:ffff:ffff")));
        ipPrefix = Ip6Prefix.valueOf((String)"ffff:ffff:ffff:ffff:ffff:ffff:ffff:ffff/128");
        Assert.assertFalse((boolean)ipPrefix.contains((IpAddress)Ip6Address.valueOf((String)"1111:2222:3333:4444::")));
        Assert.assertFalse((boolean)ipPrefix.contains((IpAddress)Ip6Address.valueOf((String)"1111:2222:3333:4444::1")));
        Assert.assertFalse((boolean)ipPrefix.contains((IpAddress)Ip6Address.valueOf((String)"1111:2222:3333:4445::")));
        Assert.assertFalse((boolean)ipPrefix.contains((IpAddress)Ip6Address.valueOf((String)"::")));
        Assert.assertTrue((boolean)ipPrefix.contains((IpAddress)Ip6Address.valueOf((String)"ffff:ffff:ffff:ffff:ffff:ffff:ffff:ffff")));
    }

    @Test
    public void testEqualityIPv6() {
        new EqualsTester().addEqualityGroup(new Object[]{Ip6Prefix.valueOf((String)"1111:2222:3333:4444::/120"), Ip6Prefix.valueOf((String)"1111:2222:3333:4444::1/120"), Ip6Prefix.valueOf((String)"1111:2222:3333:4444::/120")}).addEqualityGroup(new Object[]{Ip6Prefix.valueOf((String)"1111:2222:3333:4444::/64"), Ip6Prefix.valueOf((String)"1111:2222:3333:4444::/64")}).addEqualityGroup(new Object[]{Ip6Prefix.valueOf((String)"1111:2222:3333:4444::/128"), Ip6Prefix.valueOf((String)"1111:2222:3333:4444::/128")}).addEqualityGroup(new Object[]{Ip6Prefix.valueOf((String)"1111:2222:3333:4445::/64"), Ip6Prefix.valueOf((String)"1111:2222:3333:4445::/64")}).addEqualityGroup(new Object[]{Ip6Prefix.valueOf((String)"::/0"), Ip6Prefix.valueOf((String)"::/0")}).addEqualityGroup(new Object[]{Ip6Prefix.valueOf((String)"ffff:ffff:ffff:ffff:ffff:ffff:ffff:ffff/128"), Ip6Prefix.valueOf((String)"ffff:ffff:ffff:ffff:ffff:ffff:ffff:ffff/128")}).testEquals();
    }

    @Test
    public void testToStringIPv6() {
        Ip6Prefix ipPrefix = Ip6Prefix.valueOf((String)"1100::/8");
        Assert.assertThat((Object)ipPrefix.toString(), (Matcher)Matchers.is((Object)"1100::/8"));
        ipPrefix = Ip6Prefix.valueOf((String)"1111:2222:3333:4444:5555:6666:7777:8885/8");
        Assert.assertThat((Object)ipPrefix.toString(), (Matcher)Matchers.is((Object)"1100::/8"));
        ipPrefix = Ip6Prefix.valueOf((String)"::/0");
        Assert.assertThat((Object)ipPrefix.toString(), (Matcher)Matchers.is((Object)"::/0"));
        ipPrefix = Ip6Prefix.valueOf((String)"ffff:ffff:ffff:ffff:ffff:ffff:ffff:ffff/128");
        Assert.assertThat((Object)ipPrefix.toString(), (Matcher)Matchers.is((Object)"ffff:ffff:ffff:ffff:ffff:ffff:ffff:ffff/128"));
    }
}

