/*
 * Decompiled with CFR 0.152.
 */
package org.onlab.graph;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;
import org.onlab.graph.AbstractGraphPathSearch;
import org.onlab.graph.DefaultPath;
import org.onlab.graph.DijkstraGraphSearch;
import org.onlab.graph.Edge;
import org.onlab.graph.EdgeWeight;
import org.onlab.graph.Graph;
import org.onlab.graph.GraphPathSearch;
import org.onlab.graph.Path;
import org.onlab.graph.Vertex;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class KShortestPathsSearch<V extends Vertex, E extends Edge<V>>
extends AbstractGraphPathSearch<V, E> {
    private final Logger log = LoggerFactory.getLogger(this.getClass());

    @Override
    public GraphPathSearch.Result<V, E> search(Graph<V, E> graph, V src, V dst, EdgeWeight<V, E> weight, int maxPaths) {
        Preconditions.checkNotNull(src);
        Preconditions.checkNotNull(dst);
        InnerEdgeWeighter modifiedWeighter = new InnerEdgeWeighter((EdgeWeight)Preconditions.checkNotNull(weight));
        Preconditions.checkArgument((maxPaths > 0 ? 1 : 0) != 0);
        Graph originalGraph = (Graph)Preconditions.checkNotNull(graph);
        InnerOrderedResult result = new InnerOrderedResult(this, src, dst, maxPaths);
        ArrayList resultPaths = new ArrayList(maxPaths);
        ArrayList potentialPaths = Lists.newArrayList();
        DijkstraGraphSearch dijkstraSearch = new DijkstraGraphSearch();
        Set dijkstraResults = dijkstraSearch.search(originalGraph, src, dst, modifiedWeighter, 1).paths();
        if (dijkstraResults.size() == 0) {
            this.log.warn("No path was found.");
            return result;
        }
        resultPaths.add(dijkstraResults.iterator().next());
        for (int k = 1; k < maxPaths; ++k) {
            for (int i = 0; i < ((Path)resultPaths.get(k - 1)).edges().size() - 1; ++i) {
                Object spurNode = ((Edge)((Path)resultPaths.get(k - 1)).edges().get(i)).src();
                List rootPathEdgeList = ((Path)resultPaths.get(k - 1)).edges().subList(0, i);
                for (Path path : resultPaths) {
                    if (!this.edgeListsAreEqual(rootPathEdgeList, path.edges().subList(0, i))) continue;
                    modifiedWeighter.removedEdges.add(path.edges().get(i));
                }
                for (Edge edge : rootPathEdgeList) {
                    originalGraph.getEdgesFrom(edge.src()).forEach(e -> modifiedWeighter.removedEdges.add(e));
                    originalGraph.getEdgesTo(edge.src()).forEach(e -> modifiedWeighter.removedEdges.add(e));
                }
                dijkstraResults = dijkstraSearch.search(originalGraph, spurNode, dst, modifiedWeighter, 1).paths();
                if (dijkstraResults.size() != 0) {
                    Path spurPath = dijkstraResults.iterator().next();
                    ArrayList arrayList = new ArrayList(rootPathEdgeList);
                    spurPath.edges().forEach(e -> totalPath.add(e));
                    potentialPaths.add(new DefaultPath(arrayList, this.calculatePathCost(weight, arrayList)));
                }
                modifiedWeighter.removedEdges.clear();
            }
            if (potentialPaths.isEmpty()) break;
            potentialPaths.sort(new InnerPathComparator());
            resultPaths.add(potentialPaths.get(0));
            potentialPaths.remove(0);
        }
        result.pathSet.addAll(resultPaths);
        return result;
    }

    private boolean edgeListsAreEqual(List<E> edgeListOne, List<E> edgeListTwo) {
        if (edgeListOne.size() != edgeListTwo.size()) {
            return false;
        }
        for (int i = 0; i < edgeListOne.size(); ++i) {
            Edge edgeTwo;
            Edge edgeOne = (Edge)edgeListOne.get(i);
            if (edgeOne.equals(edgeTwo = (Edge)edgeListTwo.get(i))) continue;
            return false;
        }
        return true;
    }

    private Double calculatePathCost(EdgeWeight<V, E> weighter, List<E> edges) {
        Double totalCost = 0.0;
        for (Edge edge : edges) {
            totalCost = totalCost + weighter.weight(edge);
        }
        return totalCost;
    }

    private class InnerPathComparator
    implements Comparator<Path<V, E>> {
        private InnerPathComparator() {
        }

        @Override
        public int compare(Path<V, E> pathOne, Path<V, E> pathTwo) {
            int comparisonValue = Double.compare(pathOne.cost(), pathTwo.cost());
            if (comparisonValue != 0) {
                return comparisonValue;
            }
            if (KShortestPathsSearch.this.edgeListsAreEqual(pathOne.edges(), pathTwo.edges())) {
                return 0;
            }
            return 1;
        }
    }

    protected class InnerOrderedResult
    extends AbstractGraphPathSearch.DefaultResult {
        private TreeSet<Path<V, E>> pathSet;
        final /* synthetic */ KShortestPathsSearch this$0;

        public InnerOrderedResult(V src, V dst) {
            this.this$0 = this$0;
            super((AbstractGraphPathSearch)this$0, src, dst);
            this.pathSet = new TreeSet(this.this$0.new InnerPathComparator());
        }

        /*
         * WARNING - Possible parameter corruption
         */
        public InnerOrderedResult(V src, V dst, int maxPaths) {
            this.this$0 = (KShortestPathsSearch)this$0;
            super((AbstractGraphPathSearch)this$0, src, dst, maxPaths);
            this.pathSet = new TreeSet(this.this$0.new InnerPathComparator());
        }

        @Override
        public Set<Path<V, E>> paths() {
            return ImmutableSet.copyOf(this.pathSet);
        }
    }

    private class InnerEdgeWeighter
    implements EdgeWeight<V, E> {
        private Set<E> removedEdges = Sets.newConcurrentHashSet();
        private EdgeWeight<V, E> innerEdgeWeight;

        public InnerEdgeWeighter(EdgeWeight<V, E> weight) {
            this.innerEdgeWeight = weight;
        }

        @Override
        public double weight(E edge) {
            if (this.removedEdges.contains(edge)) {
                return -1.0;
            }
            return this.innerEdgeWeight.weight(edge);
        }
    }
}

