/*
 * Decompiled with CFR 0.152.
 */
package org.onlab.graph;

import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import org.onlab.graph.Edge;
import org.onlab.graph.Path;
import org.onlab.graph.Vertex;

public class DefaultPath<V extends Vertex, E extends Edge<V>>
implements Path<V, E> {
    private final V src;
    private final V dst;
    private final List<E> edges;
    private double cost = 0.0;

    public DefaultPath(List<E> edges, double cost) {
        Preconditions.checkNotNull(edges, (Object)"Edges list must not be null");
        Preconditions.checkArgument((!edges.isEmpty() ? 1 : 0) != 0, (Object)"There must be at least one edge");
        this.edges = ImmutableList.copyOf(edges);
        this.src = ((Edge)edges.get(0)).src();
        this.dst = ((Edge)edges.get(edges.size() - 1)).dst();
        this.cost = cost;
    }

    @Override
    public V src() {
        return this.src;
    }

    @Override
    public V dst() {
        return this.dst;
    }

    @Override
    public double cost() {
        return this.cost;
    }

    @Override
    public List<E> edges() {
        return Collections.unmodifiableList(this.edges);
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("src", this.src).add("dst", this.dst).add("cost", this.cost).add("edges", this.edges).toString();
    }

    public int hashCode() {
        return Objects.hash(this.src, this.dst, this.edges, this.cost);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof DefaultPath) {
            DefaultPath other = (DefaultPath)obj;
            return Objects.equals(this.src, other.src) && Objects.equals(this.dst, other.dst) && Objects.equals(this.cost, other.cost) && Objects.equals(this.edges, other.edges);
        }
        return false;
    }
}

