/*
 * Decompiled with CFR 0.152.
 */
package org.onlab.packet;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.nio.ByteBuffer;
import java.nio.charset.StandardCharsets;
import java.util.HashMap;
import org.apache.commons.lang.ArrayUtils;
import org.onlab.packet.ChassisId;
import org.onlab.packet.Ethernet;
import org.onlab.packet.LLDP;
import org.onlab.packet.LLDPOrganizationalTLV;
import org.onlab.packet.LLDPTLV;
import org.onlab.packet.MacAddress;

public class ONOSLLDP
extends LLDP {
    public static final byte[] ONLAB_OUI = new byte[]{-92, 35, 5};
    public static final String DEFAULT_DEVICE = "INVALID";
    public static final String DEFAULT_NAME = "ONOS Discovery";
    public static final byte[] LLDP_ONLAB = new byte[]{-91, 35, 5, 0, 0, 1};
    public static final byte[] BDDP_MULTICAST = new byte[]{-1, -1, -1, -1, -1, -1};
    protected static final byte NAME_SUBTYPE = 1;
    protected static final byte DEVICE_SUBTYPE = 2;
    protected static final byte DOMAIN_SUBTYPE = 3;
    private static final short NAME_LENGTH = 4;
    private static final short DEVICE_LENGTH = 4;
    private static final short DOMAIN_LENGTH = 4;
    private final HashMap<Byte, LLDPOrganizationalTLV> opttlvs = Maps.newHashMap();
    private static final byte CHASSIS_TLV_TYPE = 1;
    private static final byte CHASSIS_TLV_SIZE = 7;
    private static final byte CHASSIS_TLV_SUBTYPE = 4;
    private static final byte PORT_TLV_TYPE = 2;
    private static final byte PORT_TLV_SIZE = 5;
    private static final byte PORT_TLV_SUBTYPE = 2;
    private static final byte TTL_TLV_TYPE = 3;
    private final byte[] ttlValue = new byte[]{0, 120};

    public ONOSLLDP(byte ... subtype) {
        for (byte st : subtype) {
            this.opttlvs.put(st, new LLDPOrganizationalTLV());
        }
        this.opttlvs.putIfAbsent((byte)1, new LLDPOrganizationalTLV());
        this.opttlvs.putIfAbsent((byte)2, new LLDPOrganizationalTLV());
        this.setName(DEFAULT_NAME);
        this.setDevice(DEFAULT_DEVICE);
        this.setOptionalTLVList(Lists.newArrayList(this.opttlvs.values()));
        this.setTtl(new LLDPTLV().setType((byte)3).setLength((short)this.ttlValue.length).setValue(this.ttlValue));
    }

    private ONOSLLDP(LLDP lldp) {
        this.portId = lldp.getPortId();
        this.chassisId = lldp.getChassisId();
        this.ttl = lldp.getTtl();
        this.optionalTLVList = lldp.getOptionalTLVList();
    }

    public void setName(String name) {
        LLDPOrganizationalTLV nametlv = this.opttlvs.get((byte)1);
        nametlv.setLength((short)(name.length() + 4));
        nametlv.setInfoString(name);
        nametlv.setSubType((byte)1);
        nametlv.setOUI(ONLAB_OUI);
    }

    public void setDevice(String device) {
        LLDPOrganizationalTLV devicetlv = this.opttlvs.get((byte)2);
        devicetlv.setInfoString(device);
        devicetlv.setLength((short)(device.length() + 4));
        devicetlv.setSubType((byte)2);
        devicetlv.setOUI(ONLAB_OUI);
    }

    public void setDomainInfo(String domainId) {
        LLDPOrganizationalTLV domaintlv = this.opttlvs.get((byte)3);
        if (domaintlv == null) {
            return;
        }
        domaintlv.setInfoString(domainId);
        domaintlv.setLength((short)(domainId.length() + 4));
        domaintlv.setSubType((byte)3);
        domaintlv.setOUI(ONLAB_OUI);
    }

    public void setChassisId(ChassisId chassisId) {
        MacAddress chassisMac = MacAddress.valueOf(chassisId.value());
        byte[] chassis = ArrayUtils.addAll((byte[])new byte[]{4}, (byte[])chassisMac.toBytes());
        LLDPTLV chassisTLV = new LLDPTLV();
        chassisTLV.setLength((short)7);
        chassisTLV.setType((byte)1);
        chassisTLV.setValue(chassis);
        this.setChassisId(chassisTLV);
    }

    public void setPortId(int portNumber) {
        byte[] port = ArrayUtils.addAll((byte[])new byte[]{2}, (byte[])ByteBuffer.allocate(4).putInt(portNumber).array());
        LLDPTLV portTLV = new LLDPTLV();
        portTLV.setLength((short)5);
        portTLV.setType((byte)2);
        portTLV.setValue(port);
        this.setPortId(portTLV);
    }

    public LLDPOrganizationalTLV getNameTLV() {
        for (LLDPTLV tlv : this.getOptionalTLVList()) {
            LLDPOrganizationalTLV orgTLV;
            if (tlv.getType() != 127 || (orgTLV = (LLDPOrganizationalTLV)tlv).getSubType() != 1) continue;
            return orgTLV;
        }
        return null;
    }

    public LLDPOrganizationalTLV getDeviceTLV() {
        for (LLDPTLV tlv : this.getOptionalTLVList()) {
            LLDPOrganizationalTLV orgTLV;
            if (tlv.getType() != 127 || (orgTLV = (LLDPOrganizationalTLV)tlv).getSubType() != 2) continue;
            return orgTLV;
        }
        return null;
    }

    public LLDPOrganizationalTLV getDomainTLV() {
        for (LLDPTLV tlv : this.getOptionalTLVList()) {
            LLDPOrganizationalTLV orgTLV;
            if (tlv.getType() != 127 || (orgTLV = (LLDPOrganizationalTLV)tlv).getSubType() != 3) continue;
            return orgTLV;
        }
        return null;
    }

    public String getNameString() {
        LLDPOrganizationalTLV tlv = this.getNameTLV();
        if (tlv != null) {
            return new String(tlv.getInfoString(), StandardCharsets.UTF_8);
        }
        return null;
    }

    public String getDeviceString() {
        LLDPOrganizationalTLV tlv = this.getDeviceTLV();
        if (tlv != null) {
            return new String(tlv.getInfoString(), StandardCharsets.UTF_8);
        }
        return null;
    }

    public String getDomainString() {
        LLDPOrganizationalTLV tlv = this.getDomainTLV();
        if (tlv != null) {
            return new String(tlv.getInfoString(), StandardCharsets.UTF_8);
        }
        return null;
    }

    public Integer getPort() {
        ByteBuffer portBB = ByteBuffer.wrap(this.getPortId().getValue());
        portBB.position(1);
        return portBB.getInt();
    }

    public static ONOSLLDP parseONOSLLDP(Ethernet eth) {
        ONOSLLDP onosLldp;
        if ((eth.getEtherType() == Ethernet.TYPE_LLDP || eth.getEtherType() == Ethernet.TYPE_BSN) && DEFAULT_NAME.equals((onosLldp = new ONOSLLDP((LLDP)eth.getPayload())).getNameString())) {
            return onosLldp;
        }
        return null;
    }

    public static ONOSLLDP onosLLDP(String deviceId, ChassisId chassisId, int portNum) {
        ONOSLLDP probe = new ONOSLLDP(1, 2);
        probe.setPortId(portNum);
        probe.setDevice(deviceId);
        probe.setChassisId(chassisId);
        return probe;
    }
}

