/*
 * Decompiled with CFR 0.152.
 */
package org.onlab.util;

import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import java.util.List;
import java.util.Timer;
import java.util.TimerTask;
import org.onlab.util.Accumulator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractAccumulator<T>
implements Accumulator<T> {
    private Logger log = LoggerFactory.getLogger(AbstractAccumulator.class);
    private final Timer timer;
    private final int maxItems;
    private final int maxBatchMillis;
    private final int maxIdleMillis;
    private volatile TimerTask idleTask = new ProcessorTask();
    private volatile TimerTask maxTask = new ProcessorTask();
    private List<T> items = Lists.newArrayList();

    protected AbstractAccumulator(Timer timer, int maxItems, int maxBatchMillis, int maxIdleMillis) {
        this.timer = (Timer)Preconditions.checkNotNull((Object)timer, (Object)"Timer cannot be null");
        Preconditions.checkArgument((maxItems > 1 ? 1 : 0) != 0, (Object)"Maximum number of items must be > 1");
        Preconditions.checkArgument((maxBatchMillis > 0 ? 1 : 0) != 0, (Object)"Maximum millis must be positive");
        Preconditions.checkArgument((maxIdleMillis > 0 ? 1 : 0) != 0, (Object)"Maximum idle millis must be positive");
        this.maxItems = maxItems;
        this.maxBatchMillis = maxBatchMillis;
        this.maxIdleMillis = maxIdleMillis;
    }

    @Override
    public synchronized void add(T item) {
        this.idleTask = this.cancelIfActive(this.idleTask);
        this.items.add(Preconditions.checkNotNull(item, (Object)"Item cannot be null"));
        if (this.items.size() >= this.maxItems) {
            this.maxTask = this.cancelIfActive(this.maxTask);
            this.scheduleNow();
        } else {
            this.idleTask = this.schedule(this.maxIdleMillis);
            if (this.items.size() == 1) {
                this.maxTask = this.schedule(this.maxBatchMillis);
            }
        }
    }

    private void scheduleNow() {
        if (this.isReady()) {
            ProcessorTask task = new ProcessorTask(this.finalizeCurrentBatch());
            this.timer.schedule((TimerTask)task, 1L);
        }
    }

    private TimerTask schedule(int millis) {
        ProcessorTask task = new ProcessorTask();
        this.timer.schedule((TimerTask)task, millis);
        return task;
    }

    private TimerTask cancelIfActive(TimerTask task) {
        if (task != null) {
            task.cancel();
        }
        return task;
    }

    private synchronized List<T> finalizeCurrentBatch() {
        List<T> toBeProcessed = this.items;
        this.items = Lists.newArrayList();
        return toBeProcessed;
    }

    @Override
    public boolean isReady() {
        return true;
    }

    public Timer timer() {
        return this.timer;
    }

    public int maxItems() {
        return this.maxItems;
    }

    public int maxBatchMillis() {
        return this.maxBatchMillis;
    }

    public int maxIdleMillis() {
        return this.maxIdleMillis;
    }

    private class ProcessorTask
    extends TimerTask {
        private final List<T> items;

        ProcessorTask() {
            this.items = null;
        }

        ProcessorTask(List<T> items) {
            this.items = items;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            AbstractAccumulator abstractAccumulator = AbstractAccumulator.this;
            synchronized (abstractAccumulator) {
                AbstractAccumulator.this.idleTask = AbstractAccumulator.this.cancelIfActive(AbstractAccumulator.this.idleTask);
            }
            if (AbstractAccumulator.this.isReady()) {
                try {
                    List batch;
                    abstractAccumulator = AbstractAccumulator.this;
                    synchronized (abstractAccumulator) {
                        AbstractAccumulator.this.maxTask = AbstractAccumulator.this.cancelIfActive(AbstractAccumulator.this.maxTask);
                    }
                    List list = batch = this.items != null ? this.items : AbstractAccumulator.this.finalizeCurrentBatch();
                    if (!batch.isEmpty()) {
                        AbstractAccumulator.this.processItems(batch);
                    }
                }
                catch (Exception e) {
                    AbstractAccumulator.this.log.warn("Unable to process batch due to", (Throwable)e);
                }
            } else {
                abstractAccumulator = AbstractAccumulator.this;
                synchronized (abstractAccumulator) {
                    AbstractAccumulator.this.idleTask = AbstractAccumulator.this.schedule(AbstractAccumulator.this.maxIdleMillis);
                }
            }
        }
    }
}

