/*
 * Decompiled with CFR 0.152.
 */
package org.onlab.packet;

import com.google.common.base.MoreObjects;
import java.nio.ByteBuffer;
import java.util.HashMap;
import java.util.Map;
import org.onlab.packet.BasePacket;
import org.onlab.packet.Data;
import org.onlab.packet.DeserializationException;
import org.onlab.packet.Deserializer;
import org.onlab.packet.IPacket;
import org.onlab.packet.IPv6;
import org.onlab.packet.PacketUtils;
import org.onlab.packet.ipv6.IExtensionHeader;
import org.onlab.packet.ndp.NeighborAdvertisement;
import org.onlab.packet.ndp.NeighborSolicitation;
import org.onlab.packet.ndp.Redirect;
import org.onlab.packet.ndp.RouterAdvertisement;
import org.onlab.packet.ndp.RouterSolicitation;

public class ICMP6
extends BasePacket {
    public static final byte HEADER_LENGTH = 4;
    public static final byte DEST_UNREACH = 1;
    public static final byte PKT_TOO_BIG = 2;
    public static final byte TIME_EXCEED = 3;
    public static final byte PARAM_ERR = 4;
    public static final byte ECHO_REQUEST = -128;
    public static final byte ECHO_REPLY = -127;
    public static final byte MCAST_QUERY = -126;
    public static final byte MCAST_REPORT = -125;
    public static final byte MCAST_DONE = -124;
    public static final byte ROUTER_SOLICITATION = -123;
    public static final byte ROUTER_ADVERTISEMENT = -122;
    public static final byte NEIGHBOR_SOLICITATION = -121;
    public static final byte NEIGHBOR_ADVERTISEMENT = -120;
    public static final byte REDIRECT = -119;
    public static final byte NO_ROUTE = 0;
    public static final byte COMM_PROHIBIT = 1;
    public static final byte BEYOND_SCOPE = 2;
    public static final byte ADDR_UNREACH = 3;
    public static final byte PORT_UNREACH = 4;
    public static final byte FAIL_POLICY = 5;
    public static final byte REJECT_ROUTE = 6;
    public static final byte SRC_ROUTING_HEADER_ERR = 7;
    public static final byte HOP_LIMIT_EXCEED = 0;
    public static final byte DEFRAG_TIME_EXCEED = 1;
    public static final byte HDR_FIELD_ERR = 0;
    public static final byte NEXT_HEADER_ERR = 1;
    public static final byte IPV6_OPT_ERR = 1;
    public static final Map<Byte, Deserializer<? extends IPacket>> TYPE_DESERIALIZER_MAP = new HashMap<Byte, Deserializer<? extends IPacket>>();
    protected byte icmpType;
    protected byte icmpCode;
    protected short checksum;
    private static final byte[] ZERO_ADDRESS;

    public byte getIcmpType() {
        return this.icmpType;
    }

    public ICMP6 setIcmpType(byte icmpType) {
        this.icmpType = icmpType;
        return this;
    }

    public byte getIcmpCode() {
        return this.icmpCode;
    }

    public ICMP6 setIcmpCode(byte icmpCode) {
        this.icmpCode = icmpCode;
        return this;
    }

    public short getChecksum() {
        return this.checksum;
    }

    public ICMP6 setChecksum(short checksum) {
        this.checksum = checksum;
        return this;
    }

    @Override
    public byte[] serialize() {
        byte[] payloadData = null;
        if (this.payload != null) {
            this.payload.setParent(this);
            payloadData = this.payload.serialize();
        }
        int payloadLength = 0;
        if (payloadData != null) {
            payloadLength = payloadData.length;
        }
        byte[] data = new byte[4 + payloadLength];
        ByteBuffer bbData = ByteBuffer.wrap(data);
        byte[] checksumData = new byte[44 + payloadLength];
        ByteBuffer bbChecksum = ByteBuffer.wrap(checksumData);
        IPv6 ipv6Parent = null;
        for (IPacket p = this.parent; p != null; p = p.getParent()) {
            if (!(p instanceof IPv6)) continue;
            ipv6Parent = (IPv6)p;
            break;
        }
        if (ipv6Parent != null) {
            bbChecksum.put(ipv6Parent.getSourceAddress());
            bbChecksum.put(ipv6Parent.getDestinationAddress());
        } else {
            bbChecksum.put(ZERO_ADDRESS);
            bbChecksum.put(ZERO_ADDRESS);
        }
        bbChecksum.putInt(4 + payloadLength);
        bbChecksum.put((byte)0);
        bbChecksum.put((byte)0);
        bbChecksum.put((byte)0);
        bbChecksum.put((byte)58);
        bbChecksum.put(this.icmpType);
        bbChecksum.put(this.icmpCode);
        bbChecksum.put((byte)0);
        bbChecksum.put((byte)0);
        bbData.put(this.icmpType);
        bbData.put(this.icmpCode);
        bbData.putShort(this.checksum);
        if (payloadData != null) {
            bbData.put(payloadData);
            bbChecksum.put(payloadData);
        }
        if (this.parent != null) {
            if (this.parent instanceof IPv6) {
                ((IPv6)this.parent).setNextHeader((byte)58);
            } else if (this.parent instanceof IExtensionHeader) {
                ((IExtensionHeader)((Object)this.parent)).setNextHeader((byte)58);
            }
        }
        if (this.checksum == 0) {
            bbData.rewind();
            bbChecksum.rewind();
            int accumulation = 0;
            for (int i = 0; i < checksumData.length / 2; ++i) {
                accumulation += 0xFFFF & bbChecksum.getShort();
            }
            if (checksumData.length % 2 > 0) {
                accumulation += (bbChecksum.get() & 0xFF) << 8;
            }
            accumulation = (accumulation >> 16 & 0xFFFF) + (accumulation & 0xFFFF);
            this.checksum = (short)(~accumulation & 0xFFFF);
            bbData.putShort(2, this.checksum);
        }
        return data;
    }

    @Override
    public IPacket deserialize(byte[] data, int offset, int length) {
        ByteBuffer bb = ByteBuffer.wrap(data, offset, length);
        this.icmpType = bb.get();
        this.icmpCode = bb.get();
        this.checksum = bb.getShort();
        Deserializer<IPacket> deserializer = TYPE_DESERIALIZER_MAP.containsKey(this.icmpType) ? TYPE_DESERIALIZER_MAP.get(this.icmpType) : Data.deserializer();
        try {
            this.payload = deserializer.deserialize(data, bb.position(), bb.limit() - bb.position());
            this.payload.setParent(this);
        }
        catch (DeserializationException e) {
            return this;
        }
        return this;
    }

    @Override
    public int hashCode() {
        int prime = 5807;
        int result = super.hashCode();
        result = 5807 * result + this.icmpType;
        result = 5807 * result + this.icmpCode;
        result = 5807 * result + this.checksum;
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        if (!(obj instanceof ICMP6)) {
            return false;
        }
        ICMP6 other = (ICMP6)obj;
        if (this.icmpType != other.icmpType) {
            return false;
        }
        if (this.icmpCode != other.icmpCode) {
            return false;
        }
        return this.checksum == other.checksum;
    }

    public static Deserializer<ICMP6> deserializer() {
        return (data, offset, length) -> {
            PacketUtils.checkInput(data, offset, length, 4);
            ICMP6 icmp6 = new ICMP6();
            ByteBuffer bb = ByteBuffer.wrap(data, offset, length);
            icmp6.icmpType = bb.get();
            icmp6.icmpCode = bb.get();
            icmp6.checksum = bb.getShort();
            Deserializer<IPacket> deserializer = TYPE_DESERIALIZER_MAP.containsKey(icmp6.icmpType) ? TYPE_DESERIALIZER_MAP.get(icmp6.icmpType) : Data.deserializer();
            icmp6.payload = deserializer.deserialize(data, bb.position(), bb.limit() - bb.position());
            icmp6.payload.setParent(icmp6);
            return icmp6;
        };
    }

    public String toString() {
        return MoreObjects.toStringHelper(this.getClass()).add("icmpType", (Object)Byte.toString(this.icmpType)).add("icmpCode", (Object)Byte.toString(this.icmpCode)).add("checksum", (Object)Short.toString(this.checksum)).toString();
    }

    static {
        TYPE_DESERIALIZER_MAP.put((byte)-123, RouterSolicitation.deserializer());
        TYPE_DESERIALIZER_MAP.put((byte)-122, RouterAdvertisement.deserializer());
        TYPE_DESERIALIZER_MAP.put((byte)-121, NeighborSolicitation.deserializer());
        TYPE_DESERIALIZER_MAP.put((byte)-120, NeighborAdvertisement.deserializer());
        TYPE_DESERIALIZER_MAP.put((byte)-119, Redirect.deserializer());
        ZERO_ADDRESS = new byte[16];
    }
}

