/*
 * Decompiled with CFR 0.152.
 */
package org.onlab.graph;

import com.google.common.base.Preconditions;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.onlab.graph.DefaultMutablePath;
import org.onlab.graph.DefaultPath;
import org.onlab.graph.Edge;
import org.onlab.graph.EdgeWeight;
import org.onlab.graph.Graph;
import org.onlab.graph.GraphPathSearch;
import org.onlab.graph.Path;
import org.onlab.graph.Vertex;

public abstract class AbstractGraphPathSearch<V extends Vertex, E extends Edge<V>>
implements GraphPathSearch<V, E> {
    private double samenessThreshold = Double.MIN_VALUE;

    public void setSamenessThreshold(double threshold) {
        this.samenessThreshold = threshold;
    }

    public double samenessThreshold() {
        return this.samenessThreshold;
    }

    private void buildAllPaths(DefaultResult result, V src, V dst, int maxPaths) {
        DefaultMutablePath basePath = new DefaultMutablePath();
        basePath.setCost(result.cost(dst));
        HashSet pendingPaths = new HashSet();
        pendingPaths.add(basePath);
        while (!(pendingPaths.isEmpty() || maxPaths != -1 && result.paths.size() >= maxPaths)) {
            HashSet<DefaultMutablePath> frontier = new HashSet<DefaultMutablePath>();
            for (DefaultMutablePath path : pendingPaths) {
                V firstVertex = this.firstVertex(path, dst);
                if (firstVertex.equals(src)) {
                    path.setCost(result.cost(dst));
                    result.paths.add(new DefaultPath(path.edges(), path.cost()));
                    continue;
                }
                Set firstVertexParents = result.parents.get(firstVertex);
                if (firstVertexParents == null || firstVertexParents.isEmpty()) break;
                Iterator edges = firstVertexParents.iterator();
                while (edges.hasNext()) {
                    boolean isLast;
                    Edge edge = (Edge)edges.next();
                    boolean bl = isLast = !edges.hasNext();
                    if (this.isInPath(edge, path)) continue;
                    DefaultMutablePath pendingPath = isLast ? path : new DefaultMutablePath(path);
                    pendingPath.insertEdge(edge);
                    frontier.add(pendingPath);
                }
            }
            pendingPaths = frontier;
        }
    }

    private boolean isInPath(E edge, DefaultMutablePath<V, E> path) {
        return path.edges().stream().anyMatch(e -> edge.src().equals(e.dst()));
    }

    private V firstVertex(Path<V, E> path, V dst) {
        return path.edges().isEmpty() ? dst : ((Edge)path.edges().get(0)).src();
    }

    protected void checkArguments(Graph<V, E> graph, V src, V dst) {
        Preconditions.checkNotNull(graph, (Object)"Graph cannot be null");
        Preconditions.checkNotNull(src, (Object)"Source cannot be null");
        Set<V> vertices = graph.getVertexes();
        Preconditions.checkArgument((boolean)vertices.contains(src), (Object)"Source not in the graph");
        Preconditions.checkArgument((dst == null || vertices.contains(dst) ? 1 : 0) != 0, (Object)"Destination not in graph");
    }

    protected class DefaultResult
    implements GraphPathSearch.Result<V, E> {
        private final V src;
        private final V dst;
        protected final Set<Path<V, E>> paths = new HashSet();
        protected final Map<V, Double> costs = new HashMap();
        protected final Map<V, Set<E>> parents = new HashMap();
        protected final int maxPaths;
        final /* synthetic */ AbstractGraphPathSearch this$0;

        public DefaultResult(V src, V dst) {
            this(this$0, (Vertex)src, (Vertex)dst, 1);
        }

        /*
         * WARNING - Possible parameter corruption
         */
        public DefaultResult(V src, V dst, int maxPaths) {
            this.this$0 = (AbstractGraphPathSearch)this$0;
            Preconditions.checkNotNull(src, (Object)"Source cannot be null");
            this.src = src;
            this.dst = dst;
            this.maxPaths = maxPaths;
        }

        @Override
        public V src() {
            return this.src;
        }

        @Override
        public V dst() {
            return this.dst;
        }

        @Override
        public Set<Path<V, E>> paths() {
            return this.paths;
        }

        @Override
        public Map<V, Double> costs() {
            return this.costs;
        }

        @Override
        public Map<V, Set<E>> parents() {
            return this.parents;
        }

        boolean hasCost(V v) {
            return this.costs.get(v) != null;
        }

        double cost(V v) {
            Double c = this.costs.get(v);
            return c == null ? Double.MAX_VALUE : c;
        }

        void updateVertex(V vertex, E edge, double cost, boolean replace) {
            this.costs.put((Double)vertex, cost);
            if (edge != null) {
                Set edges = this.parents.get(vertex);
                if (edges == null) {
                    edges = new HashSet();
                    this.parents.put((Set)vertex, edges);
                }
                if (replace) {
                    edges.clear();
                }
                if (this.maxPaths == -1 || edges.size() < this.maxPaths) {
                    edges.add(edge);
                }
            }
        }

        void removeVertex(V v) {
            this.parents.remove(v);
        }

        boolean relaxEdge(E edge, double cost, EdgeWeight<V, E> ew, boolean ... forbidNegatives) {
            boolean same;
            double hopCost;
            Object v = edge.dst();
            double oldCost = this.cost(v);
            double d = hopCost = ew == null ? 1.0 : ew.weight(edge);
            if (hopCost < 0.0 && forbidNegatives.length == 1 && forbidNegatives[0]) {
                return false;
            }
            double newCost = cost + hopCost;
            boolean relaxed = newCost < oldCost;
            boolean bl = same = Math.abs(newCost - oldCost) <= this.this$0.samenessThreshold;
            if (same || relaxed) {
                this.updateVertex(v, edge, newCost, !same);
            }
            return relaxed;
        }

        protected void buildPaths() {
            HashSet destinations = new HashSet();
            if (this.dst == null) {
                destinations.addAll(this.costs.keySet());
            } else {
                destinations.add(this.dst);
            }
            for (Vertex v : destinations) {
                if (v.equals(this.src)) continue;
                this.this$0.buildAllPaths(this, this.src, v, this.maxPaths);
            }
        }
    }
}

