/*
 * Decompiled with CFR 0.152.
 */
package org.onlab.packet;

import org.onlab.packet.IPacket;

public abstract class BasePacket
implements IPacket {
    protected IPacket parent;
    protected IPacket payload;

    @Override
    public IPacket getParent() {
        return this.parent;
    }

    @Override
    public IPacket setParent(IPacket parent) {
        this.parent = parent;
        return this;
    }

    @Override
    public IPacket getPayload() {
        return this.payload;
    }

    @Override
    public IPacket setPayload(IPacket payload) {
        this.payload = payload;
        return this;
    }

    @Override
    public void resetChecksum() {
        if (this.parent != null) {
            this.parent.resetChecksum();
        }
    }

    public int hashCode() {
        int prime = 6733;
        int result = 1;
        result = 6733 * result + (this.payload == null ? 0 : this.payload.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof BasePacket)) {
            return false;
        }
        BasePacket other = (BasePacket)obj;
        return !(this.payload == null ? other.payload != null : !this.payload.equals(other.payload));
    }

    @Override
    public Object clone() {
        IPacket pkt;
        try {
            pkt = (IPacket)this.getClass().newInstance();
        }
        catch (Exception e) {
            throw new RuntimeException("Could not clone packet");
        }
        byte[] data = this.serialize();
        pkt.deserialize(this.serialize(), 0, data.length);
        pkt.setParent(this.parent);
        return pkt;
    }
}

