/*
 * Decompiled with CFR 0.152.
 */
package org.onlab.util;

import com.google.common.base.Throwables;
import java.util.function.Function;
import org.onlab.util.Tools;

public class RetryingFunction<U, V>
implements Function<U, V> {
    private final Function<U, V> baseFunction;
    private final Class<? extends Throwable> exceptionClass;
    private final int maxRetries;
    private final int maxDelayBetweenRetries;

    public RetryingFunction(Function<U, V> baseFunction, Class<? extends Throwable> exceptionClass, int maxRetries, int maxDelayBetweenRetries) {
        this.baseFunction = baseFunction;
        this.exceptionClass = exceptionClass;
        this.maxRetries = maxRetries;
        this.maxDelayBetweenRetries = maxDelayBetweenRetries;
    }

    @Override
    public V apply(U input) {
        int retryAttempts = 0;
        while (true) {
            try {
                return this.baseFunction.apply(input);
            }
            catch (Throwable t) {
                if (!this.exceptionClass.isAssignableFrom(t.getClass()) || retryAttempts == this.maxRetries) {
                    Throwables.propagate((Throwable)t);
                }
                Tools.randomDelay(this.maxDelayBetweenRetries);
                ++retryAttempts;
                continue;
            }
            break;
        }
    }
}

