/*
 * Decompiled with CFR 0.152.
 */
package org.onlab.util;

public final class HexString {
    private HexString() {
    }

    public static String toHexString(byte[] bytes) {
        return HexString.toHexString(bytes, ":");
    }

    public static String toHexString(byte[] bytes, String separator) {
        if (bytes == null) {
            return "(null)";
        }
        if (separator == null) {
            separator = "";
        }
        StringBuilder ret = new StringBuilder(bytes.length * 3 - 1);
        for (int i = 0; i < bytes.length; ++i) {
            String tmp;
            if (i > 0) {
                ret.append(separator);
            }
            if ((tmp = Integer.toHexString(bytes[i] & 0xFF)).length() == 1) {
                ret.append('0');
            }
            ret.append(tmp);
        }
        return ret.toString();
    }

    public static String toHexString(long val, int padTo) {
        int i;
        char[] arr = Long.toHexString(val).toCharArray();
        StringBuilder ret = new StringBuilder(padTo * 3 - 1);
        for (i = 0; i < padTo * 2 - arr.length; ++i) {
            ret.append('0');
            if (i % 2 == 0) continue;
            ret.append(':');
        }
        for (int j = 0; j < arr.length; ++j) {
            ret.append(arr[j]);
            if ((i + j) % 2 == 0 || j >= arr.length - 1) continue;
            ret.append(':');
        }
        return ret.toString();
    }

    public static String toHexString(long val) {
        return HexString.toHexString(val, 8);
    }

    public static byte[] fromHexString(String values) {
        return HexString.fromHexString(values, ":");
    }

    public static byte[] fromHexString(String values, String separator) {
        String regexSeparator = separator == null || separator.length() == 0 ? "(?<=\\G.{2})" : separator;
        String[] octets = values.split(regexSeparator);
        byte[] ret = new byte[octets.length];
        for (int i = 0; i < octets.length; ++i) {
            if (octets[i].length() > 2) {
                throw new NumberFormatException("Invalid octet length");
            }
            ret[i] = Integer.valueOf(octets[i], 16).byteValue();
        }
        return ret;
    }

    public static long toLong(String value) {
        String[] octets = value.split(":");
        if (octets.length > 8) {
            throw new NumberFormatException("Input string is too big to fit in long: " + value);
        }
        long l = 0L;
        for (String octet : octets) {
            if (octet.length() > 2) {
                throw new NumberFormatException("Each colon-separated byte component must consist of 1 or 2 hex digits: " + value);
            }
            short s = Short.parseShort(octet, 16);
            l = (l << 8) + (long)s;
        }
        return l;
    }
}

