/*
 * Decompiled with CFR 0.152.
 */
package org.onlab.graph;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.onlab.graph.Edge;
import org.onlab.graph.EdgeWeight;
import org.onlab.graph.Graph;
import org.onlab.graph.GraphSearch;
import org.onlab.graph.Vertex;

public class TarjanGraphSearch<V extends Vertex, E extends Edge<V>>
implements GraphSearch<V, E> {
    @Override
    public SccResult<V, E> search(Graph<V, E> graph, EdgeWeight<V, E> weight) {
        SccResult result = new SccResult(graph);
        for (Vertex vertex : graph.getVertexes()) {
            VertexData data = result.data(vertex);
            if (data != null) continue;
            this.connect(graph, vertex, weight, result);
        }
        return result.build();
    }

    private VertexData<V> connect(Graph<V, E> graph, V vertex, EdgeWeight<V, E> weight, SccResult<V, E> result) {
        VertexData data = ((SccResult)result).addData(vertex);
        for (Edge edge : graph.getEdgesFrom(vertex)) {
            Object nextVertex = edge.dst();
            if (weight != null && weight.weight(edge) < 0.0) continue;
            VertexData<V> nextData = ((SccResult)result).data(nextVertex);
            if (nextData == null) {
                nextData = this.connect(graph, nextVertex, weight, result);
                data.lowLink = Math.min(data.lowLink, nextData.lowLink);
                continue;
            }
            if (!((SccResult)result).visited(nextData)) continue;
            data.lowLink = Math.min(data.lowLink, nextData.index);
        }
        if (data.lowLink == data.index) {
            ((SccResult)result).addCluster(data);
        }
        return data;
    }

    private static final class VertexData<V extends Vertex> {
        final V vertex;
        int index;
        int lowLink;

        private VertexData(V vertex, int index) {
            this.vertex = vertex;
            this.index = index;
            this.lowLink = index;
        }

        /* synthetic */ VertexData(Vertex x0, int x1, 1 x2) {
            this(x0, x1);
        }
    }

    public static final class SccResult<V extends Vertex, E extends Edge<V>>
    implements GraphSearch.Result {
        private final Graph<V, E> graph;
        private List<Set<V>> clusterVertexes = new ArrayList<Set<V>>();
        private List<Set<E>> clusterEdges = new ArrayList<Set<E>>();
        private int index = 0;
        private final Map<V, VertexData<V>> vertexData = new HashMap<V, VertexData<V>>();
        private final List<VertexData<V>> visited = new ArrayList<VertexData<V>>();

        private SccResult(Graph<V, E> graph) {
            this.graph = graph;
        }

        public int clusterCount() {
            return this.clusterEdges.size();
        }

        public List<Set<V>> clusterVertexes() {
            return this.clusterVertexes;
        }

        public List<Set<E>> clusterEdges() {
            return this.clusterEdges;
        }

        private VertexData<V> data(V vertex) {
            return this.vertexData.get(vertex);
        }

        private VertexData<V> addData(V vertex) {
            VertexData d = new VertexData((Vertex)vertex, this.index, null);
            this.vertexData.put(vertex, d);
            this.visited.add(0, d);
            ++this.index;
            return d;
        }

        private boolean visited(VertexData data) {
            return this.visited.contains(data);
        }

        private void addCluster(VertexData data) {
            Set<V> vertexes = this.findClusterVertices(data);
            this.clusterVertexes.add(vertexes);
            this.clusterEdges.add(this.findClusterEdges(vertexes));
        }

        private Set<V> findClusterVertices(VertexData data) {
            VertexData<V> nextVertexData;
            HashSet vertexes = new HashSet();
            do {
                nextVertexData = this.visited.remove(0);
                vertexes.add(nextVertexData.vertex);
            } while (data != nextVertexData);
            return Collections.unmodifiableSet(vertexes);
        }

        private Set<E> findClusterEdges(Set<V> vertexes) {
            HashSet<Edge> edges = new HashSet<Edge>();
            for (Vertex vertex : vertexes) {
                for (Edge edge : this.graph.getEdgesFrom(vertex)) {
                    if (!vertexes.contains(edge.dst())) continue;
                    edges.add(edge);
                }
            }
            return Collections.unmodifiableSet(edges);
        }

        public SccResult<V, E> build() {
            this.clusterVertexes = Collections.unmodifiableList(this.clusterVertexes);
            this.clusterEdges = Collections.unmodifiableList(this.clusterEdges);
            return this;
        }
    }
}

