/*
 * Decompiled with CFR 0.152.
 */
package org.onlab.graph;

import com.google.common.base.MoreObjects;
import com.google.common.collect.HashMultimap;
import com.google.common.collect.SetMultimap;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;
import org.onlab.graph.Edge;
import org.onlab.graph.Graph;
import org.onlab.graph.MutableGraph;
import org.onlab.graph.Vertex;

public class MutableAdjacencyListsGraph<V extends Vertex, E extends Edge<V>>
implements MutableGraph<V, E> {
    private Set<V> vertexes = new HashSet<V>();
    private Set<E> edges = new HashSet();
    private SetMultimap<V, E> sources = HashMultimap.create();
    private SetMultimap<V, E> destinations = HashMultimap.create();

    public MutableAdjacencyListsGraph(Set<V> vertex, Set<E> edge) {
        this.vertexes.addAll(vertex);
        this.edges.addAll(edge);
        for (Edge e : edge) {
            this.sources.put(e.src(), (Object)e);
            this.vertexes.add(e.src());
            this.destinations.put(e.dst(), (Object)e);
            this.vertexes.add(e.dst());
        }
    }

    @Override
    public Set<V> getVertexes() {
        return this.vertexes;
    }

    @Override
    public Set<E> getEdges() {
        return this.edges;
    }

    @Override
    public Set<E> getEdgesFrom(V src) {
        return this.sources.get(src);
    }

    @Override
    public Set<E> getEdgesTo(V dst) {
        return this.destinations.get(dst);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof MutableAdjacencyListsGraph) {
            MutableAdjacencyListsGraph that = (MutableAdjacencyListsGraph)obj;
            return this.getClass() == that.getClass() && Objects.equals(this.vertexes, that.vertexes) && Objects.equals(this.edges, that.edges);
        }
        return false;
    }

    public int hashCode() {
        return Objects.hash(this.vertexes, this.edges);
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("vertexes", this.vertexes).add("edges", this.edges).toString();
    }

    @Override
    public void addVertex(V vertex) {
        if (this.vertexes != null && !this.vertexes.contains(vertex)) {
            this.vertexes.add(vertex);
        }
    }

    @Override
    public void removeVertex(V vertex) {
        if (this.vertexes != null && this.edges != null && this.vertexes.contains(vertex)) {
            this.vertexes.remove(vertex);
            Set srcEdgesList = this.sources.get(vertex);
            Set dstEdgesList = this.destinations.get(vertex);
            this.edges.removeAll(srcEdgesList);
            this.edges.removeAll(dstEdgesList);
            this.sources.remove(vertex, (Object)srcEdgesList);
            this.sources.remove(vertex, (Object)dstEdgesList);
        }
    }

    @Override
    public void addEdge(E edge) {
        if (this.edges != null && !this.edges.contains(edge)) {
            this.edges.add(edge);
            this.sources.put(edge.src(), edge);
            this.destinations.put(edge.dst(), edge);
        }
    }

    @Override
    public void removeEdge(E edge) {
        if (this.edges != null && this.edges.contains(edge)) {
            this.edges.remove(edge);
            this.sources.remove(edge.src(), edge);
            this.destinations.remove(edge.dst(), edge);
        }
    }

    @Override
    public Graph<V, E> toImmutable() {
        return null;
    }

    public void clear() {
        this.edges.clear();
        this.vertexes.clear();
        this.sources.clear();
        this.destinations.clear();
    }
}

