/*
 * Decompiled with CFR 0.152.
 */
package org.onlab.graph;

import com.google.common.base.MoreObjects;
import java.util.List;
import java.util.Objects;
import org.onlab.graph.Edge;
import org.onlab.graph.Path;
import org.onlab.graph.Vertex;

public class DisjointPathPair<V extends Vertex, E extends Edge<V>>
implements Path<V, E> {
    private final Path<V, E> primary;
    private final Path<V, E> secondary;
    private boolean primaryActive = true;

    public DisjointPathPair(Path<V, E> primary, Path<V, E> secondary) {
        this.primary = primary;
        this.secondary = secondary;
    }

    @Override
    public V src() {
        return this.primary.src();
    }

    @Override
    public V dst() {
        return this.primary.dst();
    }

    public Path<V, E> primary() {
        return this.primary;
    }

    public Path<V, E> secondary() {
        return this.secondary;
    }

    @Override
    public double cost() {
        return this.hasBackup() ? this.primary.cost() + this.secondary.cost() : this.primary.cost();
    }

    @Override
    public List<E> edges() {
        return this.primaryActive || !this.hasBackup() ? this.primary.edges() : this.secondary.edges();
    }

    public boolean hasBackup() {
        return this.secondary != null;
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("src", this.src()).add("dst", this.dst()).add("cost", this.cost()).add("edges", this.edges()).toString();
    }

    public int hashCode() {
        return this.hasBackup() ? this.primary.hashCode() + this.secondary.hashCode() : Objects.hash(this.primary);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof DisjointPathPair) {
            DisjointPathPair other = (DisjointPathPair)obj;
            return Objects.equals(this.src(), other.src()) && Objects.equals(this.dst(), other.dst()) && Objects.equals(this.primary, other.primary) && Objects.equals(this.secondary, other.secondary) || Objects.equals(this.primary, other.secondary) && Objects.equals(this.secondary, other.primary);
        }
        return false;
    }

    public int size() {
        return this.hasBackup() ? 2 : 1;
    }
}

