/*
 * Decompiled with CFR 0.152.
 */
package org.onlab.util;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import org.junit.Assert;
import org.junit.Test;
import org.onlab.util.BoundedThreadPool;
import org.onlab.util.Tools;

public final class BoundedThreadPoolTest {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void simpleJob() {
        Thread myThread = Thread.currentThread();
        AtomicBoolean sameThread = new AtomicBoolean(true);
        CountDownLatch latch = new CountDownLatch(1);
        BoundedThreadPool exec = BoundedThreadPool.newSingleThreadExecutor((ThreadFactory)Tools.namedThreads((String)"test"));
        exec.submit(() -> {
            sameThread.set(myThread.equals(Thread.currentThread()));
            latch.countDown();
        });
        try {
            Assert.assertTrue((String)"Job not run", (boolean)latch.await(100L, TimeUnit.MILLISECONDS));
            Assert.assertFalse((String)"Runnable used caller thread", (boolean)sameThread.get());
        }
        catch (InterruptedException e) {
            Assert.fail();
        }
        finally {
            exec.shutdown();
        }
        try {
            Assert.assertTrue((boolean)exec.awaitTermination(1L, TimeUnit.SECONDS));
        }
        catch (InterruptedException e) {
            Assert.fail();
        }
    }

    private List<CountDownLatch> fillExecutor(BoundedThreadPool exec) {
        CountDownLatch latch;
        int numThreads = exec.getMaximumPoolSize();
        ArrayList latches = Lists.newArrayList();
        CountDownLatch started = new CountDownLatch(numThreads);
        ArrayList finished = Lists.newArrayList();
        for (int i = 0; i < numThreads; ++i) {
            latch = new CountDownLatch(1);
            CountDownLatch fin = new CountDownLatch(1);
            latches.add(latch);
            finished.add(fin);
            exec.submit(() -> {
                try {
                    started.countDown();
                    latch.await();
                    fin.countDown();
                }
                catch (InterruptedException e) {
                    Assert.fail();
                }
            });
        }
        try {
            Assert.assertTrue((boolean)started.await(100L, TimeUnit.MILLISECONDS));
        }
        catch (InterruptedException e) {
            Assert.fail();
        }
        CountDownLatch startedBlocked = new CountDownLatch(1);
        while (exec.getQueue().remainingCapacity() > 0) {
            latch = new CountDownLatch(1);
            latches.add(latch);
            exec.submit(() -> {
                try {
                    startedBlocked.countDown();
                    latch.await();
                }
                catch (InterruptedException e) {
                    Assert.fail();
                }
            });
        }
        ((CountDownLatch)latches.remove(0)).countDown();
        try {
            Assert.assertTrue((String)"Job didn't finish", (boolean)((CountDownLatch)finished.remove(0)).await(100L, TimeUnit.MILLISECONDS));
        }
        catch (InterruptedException e) {
            Assert.fail();
        }
        try {
            Assert.assertTrue((boolean)startedBlocked.await(10L, TimeUnit.MILLISECONDS));
        }
        catch (InterruptedException e) {
            Assert.fail();
        }
        latch = new CountDownLatch(1);
        latches.add(latch);
        exec.submit(() -> {
            try {
                latch.await();
            }
            catch (InterruptedException e) {
                Assert.fail();
            }
        });
        Assert.assertEquals((long)exec.getQueue().size(), (long)BoundedThreadPool.maxQueueSize);
        return latches;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void releaseOneThread() {
        BoundedThreadPool.maxQueueSize = 10;
        BoundedThreadPool exec = BoundedThreadPool.newFixedThreadPool((int)4, (ThreadFactory)Tools.namedThreads((String)"test"));
        List<CountDownLatch> latches = this.fillExecutor(exec);
        CountDownLatch myLatch = new CountDownLatch(1);
        ExecutorService myExec = Executors.newSingleThreadExecutor();
        Future<Thread> expected = myExec.submit(Thread::currentThread);
        Assert.assertEquals((long)exec.getQueue().size(), (long)BoundedThreadPool.maxQueueSize);
        long start = System.nanoTime();
        Future<Thread> actual = myExec.submit(() -> (Thread)exec.submit(() -> {
            myLatch.countDown();
            return Thread.currentThread();
        }).get());
        try {
            Assert.assertFalse((String)"Thread should still be blocked", (boolean)myLatch.await(10L, TimeUnit.MILLISECONDS));
            latches.remove(0).countDown();
            Assert.assertFalse((String)"Thread should still be blocked", (boolean)myLatch.await(10L, TimeUnit.MILLISECONDS));
            latches.remove(0).countDown();
            Assert.assertTrue((String)"Thread should be unblocked", (boolean)myLatch.await(10L, TimeUnit.SECONDS));
            long delta = System.nanoTime() - start;
            double load = (double)exec.getQueue().size() / (double)BoundedThreadPool.maxQueueSize;
            Assert.assertTrue((String)"Load is greater than threshold", (load <= 0.8 ? 1 : 0) != 0);
            Assert.assertTrue((String)"Load is less than threshold", (load >= 0.6 ? 1 : 0) != 0);
            Assert.assertEquals((String)"Work done on wrong thread", (Object)expected.get(), (Object)actual.get());
            Assert.assertTrue((String)"Took more than one second", ((double)delta < Math.pow(10.0, 9.0) ? 1 : 0) != 0);
        }
        catch (InterruptedException | ExecutionException e) {
            Assert.fail();
        }
        finally {
            latches.forEach(CountDownLatch::countDown);
            exec.shutdown();
        }
        try {
            Assert.assertTrue((boolean)exec.awaitTermination(1L, TimeUnit.SECONDS));
        }
        catch (InterruptedException e) {
            Assert.fail();
        }
    }

    @Test
    public void highLoadTimeout() {
        BoundedThreadPool.maxQueueSize = 10;
        BoundedThreadPool exec = BoundedThreadPool.newFixedThreadPool((int)2, (ThreadFactory)Tools.namedThreads((String)"test"));
        List<CountDownLatch> latches = this.fillExecutor(exec);
        AtomicBoolean sameThread = new AtomicBoolean(false);
        Thread myThread = Thread.currentThread();
        long start = System.nanoTime();
        exec.submit(() -> sameThread.set(myThread.equals(Thread.currentThread())));
        long delta = System.nanoTime() - start;
        Assert.assertEquals((long)BoundedThreadPool.maxQueueSize, (long)exec.getQueue().size());
        Assert.assertTrue((String)"Work done on wrong thread (or didn't happen)", (boolean)sameThread.get());
        Assert.assertTrue((String)("Took less than one second. Actual: " + (double)delta / 1000000.0 + "ms"), ((double)delta > Math.pow(10.0, 9.0) ? 1 : 0) != 0);
        Assert.assertTrue((String)"Took more than two seconds", ((double)delta < 2.0 * Math.pow(10.0, 9.0) ? 1 : 0) != 0);
        latches.forEach(CountDownLatch::countDown);
        exec.shutdown();
        try {
            Assert.assertTrue((boolean)exec.awaitTermination(1L, TimeUnit.SECONDS));
        }
        catch (InterruptedException e) {
            Assert.fail();
        }
    }
}

