/*
 * Decompiled with CFR 0.152.
 */
package org.onlab.util;

import com.google.common.testing.EqualsTester;
import java.util.concurrent.Callable;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReference;
import org.junit.After;
import org.junit.Before;
import org.junit.Test;
import org.onlab.util.PredictableExecutor;
import org.onlab.util.Tools;

public class PredictableExecutorTest {
    private PredictableExecutor pexecutor;
    private ExecutorService executor;

    @Before
    public void setUp() {
        this.pexecutor = new PredictableExecutor(3, Tools.namedThreads((String)"Thread-%d"));
        this.executor = this.pexecutor;
    }

    @After
    public void tearDown() {
        this.pexecutor.shutdownNow();
    }

    @Test
    public void test() throws InterruptedException {
        final CountDownLatch latch = new CountDownLatch(7);
        AtomicReference<String> hintValue0 = new AtomicReference<String>("");
        AtomicReference<String> hintValue1 = new AtomicReference<String>("");
        AtomicReference<String> hintFunction0 = new AtomicReference<String>("");
        final AtomicReference<String> pickyRunnable0 = new AtomicReference<String>("");
        final AtomicReference<String> pickyRunnable1 = new AtomicReference<String>("");
        final AtomicReference<String> pickyCallable0 = new AtomicReference<String>("");
        final AtomicReference<String> hashCode0 = new AtomicReference<String>("");
        this.pexecutor.execute(() -> {
            hintValue0.set(Thread.currentThread().getName());
            latch.countDown();
        }, 0);
        this.pexecutor.execute(() -> {
            hintValue1.set(Thread.currentThread().getName());
            latch.countDown();
        }, 1);
        this.pexecutor.execute(() -> {
            hintFunction0.set(Thread.currentThread().getName());
            latch.countDown();
        }, runnable -> 0);
        this.pexecutor.execute((Runnable)new PredictableExecutor.PickyRunnable(){

            public void run() {
                pickyRunnable0.set(Thread.currentThread().getName());
                latch.countDown();
            }

            public int hint() {
                return 0;
            }
        });
        this.executor.execute((Runnable)new PredictableExecutor.PickyRunnable(){

            public void run() {
                pickyRunnable1.set(Thread.currentThread().getName());
                latch.countDown();
            }

            public int hint() {
                return 1;
            }
        });
        Callable<Void> callable = new Callable<Void>(){

            @Override
            public Void call() {
                pickyCallable0.set(Thread.currentThread().getName());
                latch.countDown();
                return null;
            }
        };
        this.executor.submit(PredictableExecutor.picky((Callable)callable, (int)0));
        this.executor.execute(new Runnable(){

            @Override
            public void run() {
                hashCode0.set(Thread.currentThread().getName());
                latch.countDown();
            }

            public int hashCode() {
                return 0;
            }
        });
        latch.await(1L, TimeUnit.SECONDS);
        new EqualsTester().addEqualityGroup(new Object[]{hintValue0.get(), hintFunction0.get(), pickyRunnable0.get(), pickyCallable0.get(), hashCode0.get()}).addEqualityGroup(new Object[]{hintValue1.get(), pickyRunnable1.get()}).testEquals();
    }
}

