/*
 * Decompiled with CFR 0.152.
 */
package org.onlab.packet;

import java.nio.ByteBuffer;
import java.util.Arrays;
import org.apache.commons.lang3.StringUtils;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Test;
import org.onlab.packet.Data;
import org.onlab.packet.DeserializationException;
import org.onlab.packet.Deserializer;
import org.onlab.packet.IPacket;
import org.onlab.packet.IPv6;
import org.onlab.packet.PacketTestUtils;
import org.onlab.packet.UDP;

public class IPv6Test {
    private static final byte[] SOURCE_ADDRESS = new byte[]{32, 1, 15, 24, 1, 19, 2, 21, -54, 42, 20, -1, -2, 53, 38, -50};
    private static final byte[] DESTINATION_ADDRESS = new byte[]{32, 1, 15, 24, 1, 19, 2, 21, -26, -50, -113, -1, -2, 84, 55, -56};
    private static final byte[] SOLICITATION_NODE_ADDRESS = new byte[]{-1, 2, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, -1, 84, 55, -56};
    private static final byte[] MULTICAST_ADDRESS = new byte[]{51, 51, -2, 84, 55, -56};
    private static Data data;
    private static UDP udp;
    private static byte[] bytePacket;
    private Deserializer<IPv6> deserializer;

    @BeforeClass
    public static void setUpBeforeClass() throws Exception {
        data = new Data();
        data.setData("testSerialize".getBytes());
        udp = new UDP();
        udp.setPayload((IPacket)data);
        byte[] bytePayload = udp.serialize();
        byte[] byteHeader = new byte[]{105, 49, 53, 121, (byte)(bytePayload.length >> 8 & 0xFF), (byte)(bytePayload.length & 0xFF), 17, 32, 32, 1, 15, 24, 1, 19, 2, 21, -54, 42, 20, -1, -2, 53, 38, -50, 32, 1, 15, 24, 1, 19, 2, 21, -26, -50, -113, -1, -2, 84, 55, -56};
        bytePacket = new byte[byteHeader.length + bytePayload.length];
        System.arraycopy(byteHeader, 0, bytePacket, 0, byteHeader.length);
        System.arraycopy(bytePayload, 0, bytePacket, byteHeader.length, bytePayload.length);
    }

    @Before
    public void setUp() {
        this.deserializer = IPv6.deserializer();
    }

    @Test
    public void testSerialize() {
        IPv6 ipv6 = new IPv6();
        ipv6.setPayload((IPacket)udp);
        ipv6.setVersion((byte)6);
        ipv6.setTrafficClass((byte)-109);
        ipv6.setFlowLabel(79225);
        ipv6.setNextHeader((byte)17);
        ipv6.setHopLimit((byte)32);
        ipv6.setSourceAddress(SOURCE_ADDRESS);
        ipv6.setDestinationAddress(DESTINATION_ADDRESS);
        Assert.assertArrayEquals((byte[])ipv6.serialize(), (byte[])bytePacket);
    }

    @Test
    public void testDeserializeBadInput() throws Exception {
        PacketTestUtils.testDeserializeBadInput(this.deserializer);
    }

    @Test
    public void testDeserializeTruncated() throws Exception {
        byte[] ipv6Header = new byte[40];
        ByteBuffer.wrap(bytePacket).get(ipv6Header);
        PacketTestUtils.testDeserializeTruncated(this.deserializer, ipv6Header);
    }

    @Test
    public void testDeserialize() throws DeserializationException {
        IPv6 ipv6 = (IPv6)this.deserializer.deserialize(bytePacket, 0, bytePacket.length);
        Assert.assertThat((Object)ipv6.getVersion(), (Matcher)Matchers.is((Object)6));
        Assert.assertThat((Object)ipv6.getTrafficClass(), (Matcher)Matchers.is((Object)-109));
        Assert.assertThat((Object)ipv6.getFlowLabel(), (Matcher)Matchers.is((Object)79225));
        Assert.assertThat((Object)ipv6.getNextHeader(), (Matcher)Matchers.is((Object)17));
        Assert.assertThat((Object)ipv6.getHopLimit(), (Matcher)Matchers.is((Object)32));
        Assert.assertArrayEquals((byte[])ipv6.getSourceAddress(), (byte[])SOURCE_ADDRESS);
        Assert.assertArrayEquals((byte[])ipv6.getDestinationAddress(), (byte[])DESTINATION_ADDRESS);
    }

    @Test
    public void testEqual() {
        IPv6 packet1 = new IPv6();
        packet1.setPayload((IPacket)udp);
        packet1.setVersion((byte)6);
        packet1.setTrafficClass((byte)-109);
        packet1.setFlowLabel(79225);
        packet1.setNextHeader((byte)17);
        packet1.setHopLimit((byte)32);
        packet1.setSourceAddress(SOURCE_ADDRESS);
        packet1.setDestinationAddress(DESTINATION_ADDRESS);
        IPv6 packet2 = new IPv6();
        packet2.setPayload((IPacket)udp);
        packet2.setVersion((byte)6);
        packet2.setTrafficClass((byte)-109);
        packet2.setFlowLabel(79225);
        packet2.setNextHeader((byte)17);
        packet2.setHopLimit((byte)32);
        packet2.setSourceAddress(DESTINATION_ADDRESS);
        packet2.setDestinationAddress(SOURCE_ADDRESS);
        Assert.assertTrue((boolean)packet1.equals((Object)packet1));
        Assert.assertFalse((boolean)packet1.equals((Object)packet2));
    }

    @Test
    public void testToStringIPv6() throws Exception {
        IPv6 ipv6 = (IPv6)this.deserializer.deserialize(bytePacket, 0, bytePacket.length);
        String str = ipv6.toString();
        Assert.assertTrue((boolean)StringUtils.contains((CharSequence)str, (CharSequence)"version=6"));
        Assert.assertTrue((boolean)StringUtils.contains((CharSequence)str, (CharSequence)"trafficClass=-109"));
        Assert.assertTrue((boolean)StringUtils.contains((CharSequence)str, (CharSequence)"flowLabel=79225"));
        Assert.assertTrue((boolean)StringUtils.contains((CharSequence)str, (CharSequence)"nextHeader=17"));
        Assert.assertTrue((boolean)StringUtils.contains((CharSequence)str, (CharSequence)"hopLimit=32"));
    }

    @Test
    public void testSolicitationNodeAddress() {
        Assert.assertTrue((boolean)Arrays.equals(SOLICITATION_NODE_ADDRESS, IPv6.solicitationNodeAddress((byte[])DESTINATION_ADDRESS)));
    }

    @Test
    public void testMulticastAddress() {
        Assert.assertTrue((boolean)Arrays.equals(MULTICAST_ADDRESS, IPv6.multicastMacAddress((byte[])DESTINATION_ADDRESS)));
    }
}

