/*
 * Decompiled with CFR 0.152.
 */
package org.onlab.graph;

import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.onlab.graph.AbstractEdge;
import org.onlab.graph.AbstractGraphPathSearch;
import org.onlab.graph.DijkstraGraphSearch;
import org.onlab.graph.DisjointPathPair;
import org.onlab.graph.Edge;
import org.onlab.graph.EdgeWeight;
import org.onlab.graph.Graph;
import org.onlab.graph.GraphPathSearch;
import org.onlab.graph.MutableAdjacencyListsGraph;
import org.onlab.graph.MutableGraph;
import org.onlab.graph.Path;
import org.onlab.graph.Vertex;

public class SuurballeGraphSearch<V extends Vertex, E extends Edge<V>>
extends DijkstraGraphSearch<V, E> {
    @Override
    public GraphPathSearch.Result<V, E> search(Graph<V, E> graph, V src, V dst, EdgeWeight<V, E> weight, int maxPaths) {
        if (weight == null) {
            weight = edge -> 1.0;
        }
        EdgeWeight weightf = weight;
        AbstractGraphPathSearch.DefaultResult firstDijkstraS = (AbstractGraphPathSearch.DefaultResult)super.search(graph, src, dst, weight, -1);
        AbstractGraphPathSearch.DefaultResult firstDijkstra = (AbstractGraphPathSearch.DefaultResult)super.search(graph, src, null, weight, -1);
        Path shortPath = null;
        if (firstDijkstraS.paths().isEmpty()) {
            return firstDijkstraS;
        }
        DisjointPathResult result = new DisjointPathResult(this, firstDijkstra, (Vertex)src, (Vertex)dst, maxPaths);
        Iterator iterator = firstDijkstraS.paths().iterator();
        while (iterator.hasNext()) {
            Path p;
            shortPath = p = iterator.next();
            EdgeWeight modified = edge -> edge instanceof ReverseEdge ? 0.0 : weightf.weight(edge) + firstDijkstra.cost(edge.src()) - firstDijkstra.cost(edge.dst());
            EdgeWeight modified2 = edge -> weightf.weight(edge) + firstDijkstra.cost(edge.src()) - firstDijkstra.cost(edge.dst());
            MutableGraph<V, Edge> gt = this.mutableCopy(graph);
            HashMap revToEdge = new HashMap();
            graph.getEdgesTo(src).forEach(gt::removeEdge);
            for (Edge edge2 : shortPath.edges()) {
                gt.removeEdge(edge2);
                ReverseEdge reverse = new ReverseEdge(edge2);
                revToEdge.put(reverse, edge2);
                gt.addEdge(reverse);
            }
            GraphPathSearch.Result secondDijkstra = new DijkstraGraphSearch<V, Edge>().search(gt, src, dst, modified, -1);
            Path residualShortPath = null;
            if (secondDijkstra.paths().isEmpty()) {
                result.dpps.add(new DisjointPathPair(shortPath, null));
                continue;
            }
            Iterator iterator2 = secondDijkstra.paths().iterator();
            block2: while (iterator2.hasNext()) {
                Path p2;
                residualShortPath = p2 = iterator2.next();
                MutableGraph<V, Edge> roundTrip = this.mutableCopy(graph);
                List<Edge> tmp = roundTrip.getEdges().stream().collect(Collectors.toList());
                tmp.forEach(roundTrip::removeEdge);
                shortPath.edges().forEach(roundTrip::addEdge);
                if (residualShortPath != null) {
                    for (Edge edge3 : residualShortPath.edges()) {
                        if (edge3 instanceof ReverseEdge) {
                            roundTrip.removeEdge((Edge)revToEdge.get(edge3));
                            continue;
                        }
                        roundTrip.addEdge(edge3);
                    }
                }
                AbstractGraphPathSearch.DefaultResult lastSearch = (AbstractGraphPathSearch.DefaultResult)super.search(roundTrip, src, dst, weight, -1);
                Path primary = lastSearch.paths().iterator().next();
                primary.edges().forEach(roundTrip::removeEdge);
                Set<Path<V, E>> backups = super.search(roundTrip, src, dst, weight, -1).paths();
                for (Path<V, E> backup : backups) {
                    if (!this.isDisjoint(primary, backup)) continue;
                    result.dpps.add(new DisjointPathPair(primary, backup));
                    continue block2;
                }
            }
        }
        for (int i = result.dpps.size() - 1; i > 0; --i) {
            if (((DisjointPathPair)result.dpps.get(i)).size() > 1) continue;
            result.dpps.remove(i);
        }
        result.buildPaths();
        return result;
    }

    private boolean isDisjoint(Path<V, E> a, Path<V, E> b) {
        return Sets.intersection(this.vertices(a), this.vertices(b)).isEmpty();
    }

    private Set<V> vertices(Path<V, E> p) {
        HashSet set = new HashSet();
        p.edges().forEach(e -> set.add(e.src()));
        set.remove(p.src());
        return set;
    }

    private MutableGraph<V, E> mutableCopy(Graph<V, E> graph) {
        return new MutableAdjacencyListsGraph<V, E>(graph.getVertexes(), graph.getEdges());
    }

    private final class DisjointPathResult
    implements GraphPathSearch.Result<V, E> {
        private final GraphPathSearch.Result<V, E> searchResult;
        private final V src;
        private final V dst;
        private final int maxPaths;
        private final List<DisjointPathPair<V, E>> dpps = new ArrayList();
        private final Set<Path<V, E>> disjointPaths = new HashSet();
        final /* synthetic */ SuurballeGraphSearch this$0;

        /*
         * WARNING - Possible parameter corruption
         */
        private DisjointPathResult(GraphPathSearch.Result<V, E> searchResult, V src, V dst, int maxPaths) {
            this.this$0 = (SuurballeGraphSearch)n;
            this.searchResult = searchResult;
            this.src = src;
            this.dst = dst;
            this.maxPaths = maxPaths;
        }

        @Override
        public V src() {
            return this.src;
        }

        @Override
        public V dst() {
            return this.dst;
        }

        @Override
        public Set<Path<V, E>> paths() {
            return this.disjointPaths;
        }

        private void buildPaths() {
            int paths = 0;
            for (DisjointPathPair path : this.dpps) {
                this.disjointPaths.add(path);
                if (++paths != this.maxPaths) continue;
                break;
            }
        }

        @Override
        public Map<V, Set<E>> parents() {
            return this.searchResult.parents();
        }

        @Override
        public Map<V, Double> costs() {
            return this.searchResult.costs();
        }
    }

    private static final class ReverseEdge<V extends Vertex>
    extends AbstractEdge<V> {
        private ReverseEdge(Edge<V> edge) {
            super(edge.dst(), edge.src());
        }

        @Override
        public String toString() {
            return "ReversedEdge src=" + this.src() + " dst=" + this.dst();
        }
    }
}

