/*
 * Decompiled with CFR 0.152.
 */
package org.onlab.packet;

import com.google.common.net.InetAddresses;
import com.google.common.testing.EqualsTester;
import java.net.InetAddress;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.Test;
import org.onlab.junit.ImmutableClassChecker;
import org.onlab.packet.Ip4Address;
import org.onlab.packet.Ip6Address;
import org.onlab.packet.IpAddress;

public class IpAddressTest {
    @Test
    public void testImmutable() {
        ImmutableClassChecker.assertThatClassIsImmutableBaseClass(IpAddress.class);
    }

    @Test
    public void testAddrByteLength() {
        Assert.assertThat((Object)4, (Matcher)Matchers.is((Object)4));
        Assert.assertThat((Object)16, (Matcher)Matchers.is((Object)16));
        Assert.assertThat((Object)IpAddress.byteLength((IpAddress.Version)IpAddress.Version.INET), (Matcher)Matchers.is((Object)4));
        Assert.assertThat((Object)IpAddress.byteLength((IpAddress.Version)IpAddress.Version.INET6), (Matcher)Matchers.is((Object)16));
    }

    @Test
    public void testAddrBitLength() {
        Assert.assertThat((Object)32, (Matcher)Matchers.is((Object)32));
        Assert.assertThat((Object)128, (Matcher)Matchers.is((Object)128));
    }

    @Test
    public void testVersion() {
        IpAddress ipAddress = IpAddress.valueOf((String)"0.0.0.0");
        Assert.assertThat((Object)ipAddress.version(), (Matcher)Matchers.is((Object)IpAddress.Version.INET));
        ipAddress = IpAddress.valueOf((String)"::");
        Assert.assertThat((Object)ipAddress.version(), (Matcher)Matchers.is((Object)IpAddress.Version.INET6));
    }

    @Test
    public void testIsIp4() {
        IpAddress ipAddress = IpAddress.valueOf((String)"0.0.0.0");
        Assert.assertTrue((boolean)ipAddress.isIp4());
        ipAddress = IpAddress.valueOf((String)"::");
        Assert.assertFalse((boolean)ipAddress.isIp4());
    }

    @Test
    public void testIsIp6() {
        IpAddress ipAddress = IpAddress.valueOf((String)"0.0.0.0");
        Assert.assertFalse((boolean)ipAddress.isIp6());
        ipAddress = IpAddress.valueOf((String)"::");
        Assert.assertTrue((boolean)ipAddress.isIp6());
    }

    @Test
    public void testGetIp4AndIp6AddressView() {
        IpAddress ipAddress = IpAddress.valueOf((String)"1.2.3.4");
        Ip4Address ip4Address = ipAddress.getIp4Address();
        Ip6Address ip6Address = ipAddress.getIp6Address();
        Assert.assertThat((Object)ip4Address.toString(), (Matcher)Matchers.is((Object)"1.2.3.4"));
        Assert.assertNull((Object)ip6Address);
        ipAddress = Ip4Address.valueOf((String)"1.2.3.4");
        ip4Address = ipAddress.getIp4Address();
        ip6Address = ipAddress.getIp6Address();
        Assert.assertThat((Object)ip4Address.toString(), (Matcher)Matchers.is((Object)"1.2.3.4"));
        Assert.assertNull((Object)ip6Address);
        ipAddress = IpAddress.valueOf((String)"1111:2222::");
        ip4Address = ipAddress.getIp4Address();
        ip6Address = ipAddress.getIp6Address();
        Assert.assertNull((Object)ip4Address);
        Assert.assertThat((Object)ip6Address.toString(), (Matcher)Matchers.is((Object)"1111:2222::"));
        ipAddress = Ip6Address.valueOf((String)"1111:2222::");
        ip4Address = ipAddress.getIp4Address();
        ip6Address = ipAddress.getIp6Address();
        Assert.assertNull((Object)ip4Address);
        Assert.assertThat((Object)ip6Address.toString(), (Matcher)Matchers.is((Object)"1111:2222::"));
    }

    @Test
    public void testAddressToOctetsIPv4() {
        byte[] value = new byte[]{1, 2, 3, 4};
        IpAddress ipAddress = IpAddress.valueOf((String)"1.2.3.4");
        Assert.assertThat((Object)ipAddress.toOctets(), (Matcher)Matchers.is((Object)value));
        value = new byte[]{0, 0, 0, 0};
        ipAddress = IpAddress.valueOf((String)"0.0.0.0");
        Assert.assertThat((Object)ipAddress.toOctets(), (Matcher)Matchers.is((Object)value));
        value = new byte[]{-1, -1, -1, -1};
        ipAddress = IpAddress.valueOf((String)"255.255.255.255");
        Assert.assertThat((Object)ipAddress.toOctets(), (Matcher)Matchers.is((Object)value));
    }

    @Test
    public void testAddressToOctetsIPv6() {
        byte[] value = new byte[]{17, 17, 34, 34, 51, 51, 68, 68, 85, 85, 102, 102, 119, 119, -120, -120};
        IpAddress ipAddress = IpAddress.valueOf((String)"1111:2222:3333:4444:5555:6666:7777:8888");
        Assert.assertThat((Object)ipAddress.toOctets(), (Matcher)Matchers.is((Object)value));
        value = new byte[]{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0};
        ipAddress = IpAddress.valueOf((String)"::");
        Assert.assertThat((Object)ipAddress.toOctets(), (Matcher)Matchers.is((Object)value));
        value = new byte[]{-1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1};
        ipAddress = IpAddress.valueOf((String)"ffff:ffff:ffff:ffff:ffff:ffff:ffff:ffff");
        Assert.assertThat((Object)ipAddress.toOctets(), (Matcher)Matchers.is((Object)value));
    }

    @Test
    public void testValueOfForIntegerIPv4() {
        IpAddress ipAddress = IpAddress.valueOf((int)16909060);
        Assert.assertThat((Object)ipAddress.toString(), (Matcher)Matchers.is((Object)"1.2.3.4"));
        ipAddress = IpAddress.valueOf((int)0);
        Assert.assertThat((Object)ipAddress.toString(), (Matcher)Matchers.is((Object)"0.0.0.0"));
        ipAddress = IpAddress.valueOf((int)-1);
        Assert.assertThat((Object)ipAddress.toString(), (Matcher)Matchers.is((Object)"255.255.255.255"));
    }

    @Test
    public void testValueOfByteArrayIPv4() {
        byte[] value = new byte[]{1, 2, 3, 4};
        IpAddress ipAddress = IpAddress.valueOf((IpAddress.Version)IpAddress.Version.INET, (byte[])value);
        Assert.assertThat((Object)ipAddress.toString(), (Matcher)Matchers.is((Object)"1.2.3.4"));
        value = new byte[]{0, 0, 0, 0};
        ipAddress = IpAddress.valueOf((IpAddress.Version)IpAddress.Version.INET, (byte[])value);
        Assert.assertThat((Object)ipAddress.toString(), (Matcher)Matchers.is((Object)"0.0.0.0"));
        value = new byte[]{-1, -1, -1, -1};
        ipAddress = IpAddress.valueOf((IpAddress.Version)IpAddress.Version.INET, (byte[])value);
        Assert.assertThat((Object)ipAddress.toString(), (Matcher)Matchers.is((Object)"255.255.255.255"));
    }

    @Test
    public void testValueOfByteArrayIPv6() {
        byte[] value = new byte[]{17, 17, 34, 34, 51, 51, 68, 68, 85, 85, 102, 102, 119, 119, -120, -120};
        IpAddress ipAddress = IpAddress.valueOf((IpAddress.Version)IpAddress.Version.INET6, (byte[])value);
        Assert.assertThat((Object)ipAddress.toString(), (Matcher)Matchers.is((Object)"1111:2222:3333:4444:5555:6666:7777:8888"));
        value = new byte[]{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0};
        ipAddress = IpAddress.valueOf((IpAddress.Version)IpAddress.Version.INET6, (byte[])value);
        Assert.assertThat((Object)ipAddress.toString(), (Matcher)Matchers.is((Object)"::"));
        value = new byte[]{-1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1};
        ipAddress = IpAddress.valueOf((IpAddress.Version)IpAddress.Version.INET6, (byte[])value);
        Assert.assertThat((Object)ipAddress.toString(), (Matcher)Matchers.is((Object)"ffff:ffff:ffff:ffff:ffff:ffff:ffff:ffff"));
    }

    @Test(expected=NullPointerException.class)
    public void testInvalidValueOfNullArrayIPv4() {
        byte[] value = null;
        IpAddress ipAddress = IpAddress.valueOf((IpAddress.Version)IpAddress.Version.INET, value);
    }

    @Test(expected=NullPointerException.class)
    public void testInvalidValueOfNullArrayIPv6() {
        byte[] value = null;
        IpAddress ipAddress = IpAddress.valueOf((IpAddress.Version)IpAddress.Version.INET6, value);
    }

    @Test(expected=IllegalArgumentException.class)
    public void testInvalidValueOfShortArrayIPv4() {
        byte[] value = new byte[]{1, 2, 3};
        IpAddress ipAddress = IpAddress.valueOf((IpAddress.Version)IpAddress.Version.INET, (byte[])value);
    }

    @Test(expected=IllegalArgumentException.class)
    public void testInvalidValueOfShortArrayIPv6() {
        byte[] value = new byte[]{1, 2, 3, 4, 5, 6, 7, 8, 9};
        IpAddress ipAddress = IpAddress.valueOf((IpAddress.Version)IpAddress.Version.INET6, (byte[])value);
    }

    @Test
    public void testValueOfByteArrayOffsetIPv4() {
        byte[] value = new byte[]{11, 22, 33, 1, 2, 3, 4, 44, 55};
        IpAddress ipAddress = IpAddress.valueOf((IpAddress.Version)IpAddress.Version.INET, (byte[])value, (int)3);
        Assert.assertThat((Object)ipAddress.toString(), (Matcher)Matchers.is((Object)"1.2.3.4"));
        value = new byte[]{11, 22, 0, 0, 0, 0, 33};
        ipAddress = IpAddress.valueOf((IpAddress.Version)IpAddress.Version.INET, (byte[])value, (int)2);
        Assert.assertThat((Object)ipAddress.toString(), (Matcher)Matchers.is((Object)"0.0.0.0"));
        value = new byte[]{11, 22, -1, -1, -1, -1, 33};
        ipAddress = IpAddress.valueOf((IpAddress.Version)IpAddress.Version.INET, (byte[])value, (int)2);
        Assert.assertThat((Object)ipAddress.toString(), (Matcher)Matchers.is((Object)"255.255.255.255"));
    }

    @Test
    public void testValueOfByteArrayOffsetIPv6() {
        byte[] value = new byte[]{11, 22, 33, 17, 17, 34, 34, 51, 51, 68, 68, 85, 85, 102, 102, 119, 119, -120, -120, 44, 55};
        IpAddress ipAddress = IpAddress.valueOf((IpAddress.Version)IpAddress.Version.INET6, (byte[])value, (int)3);
        Assert.assertThat((Object)ipAddress.toString(), (Matcher)Matchers.is((Object)"1111:2222:3333:4444:5555:6666:7777:8888"));
        value = new byte[]{11, 22, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 33};
        ipAddress = IpAddress.valueOf((IpAddress.Version)IpAddress.Version.INET6, (byte[])value, (int)2);
        Assert.assertThat((Object)ipAddress.toString(), (Matcher)Matchers.is((Object)"::"));
        value = new byte[]{11, 22, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 33};
        ipAddress = IpAddress.valueOf((IpAddress.Version)IpAddress.Version.INET6, (byte[])value, (int)2);
        Assert.assertThat((Object)ipAddress.toString(), (Matcher)Matchers.is((Object)"ffff:ffff:ffff:ffff:ffff:ffff:ffff:ffff"));
    }

    @Test(expected=IllegalArgumentException.class)
    public void testInvalidValueOfArrayInvalidOffsetIPv4() {
        byte[] value = new byte[]{11, 22, 33, 1, 2, 3, 4, 44, 55};
        IpAddress ipAddress = IpAddress.valueOf((IpAddress.Version)IpAddress.Version.INET, (byte[])value, (int)6);
    }

    @Test(expected=IllegalArgumentException.class)
    public void testInvalidValueOfArrayInvalidOffsetIPv6() {
        byte[] value = new byte[]{11, 22, 33, 17, 17, 34, 34, 51, 51, 68, 68, 85, 85, 102, 102, 119, 119, -120, -120, 44, 55};
        IpAddress ipAddress = IpAddress.valueOf((IpAddress.Version)IpAddress.Version.INET6, (byte[])value, (int)6);
    }

    @Test
    public void testValueOfInetAddressIPv4() {
        InetAddress inetAddress = InetAddresses.forString((String)"1.2.3.4");
        IpAddress ipAddress = IpAddress.valueOf((InetAddress)inetAddress);
        Assert.assertThat((Object)ipAddress.toString(), (Matcher)Matchers.is((Object)"1.2.3.4"));
        inetAddress = InetAddresses.forString((String)"0.0.0.0");
        ipAddress = IpAddress.valueOf((InetAddress)inetAddress);
        Assert.assertThat((Object)ipAddress.toString(), (Matcher)Matchers.is((Object)"0.0.0.0"));
        inetAddress = InetAddresses.forString((String)"255.255.255.255");
        ipAddress = IpAddress.valueOf((InetAddress)inetAddress);
        Assert.assertThat((Object)ipAddress.toString(), (Matcher)Matchers.is((Object)"255.255.255.255"));
    }

    @Test
    public void testValueOfInetAddressIPv6() {
        InetAddress inetAddress = InetAddresses.forString((String)"1111:2222:3333:4444:5555:6666:7777:8888");
        IpAddress ipAddress = IpAddress.valueOf((InetAddress)inetAddress);
        Assert.assertThat((Object)ipAddress.toString(), (Matcher)Matchers.is((Object)"1111:2222:3333:4444:5555:6666:7777:8888"));
        inetAddress = InetAddresses.forString((String)"::");
        ipAddress = IpAddress.valueOf((InetAddress)inetAddress);
        Assert.assertThat((Object)ipAddress.toString(), (Matcher)Matchers.is((Object)"::"));
        inetAddress = InetAddresses.forString((String)"ffff:ffff:ffff:ffff:ffff:ffff:ffff:ffff");
        ipAddress = IpAddress.valueOf((InetAddress)inetAddress);
        Assert.assertThat((Object)ipAddress.toString(), (Matcher)Matchers.is((Object)"ffff:ffff:ffff:ffff:ffff:ffff:ffff:ffff"));
    }

    @Test
    public void testValueOfStringIPv4() {
        IpAddress ipAddress = IpAddress.valueOf((String)"1.2.3.4");
        Assert.assertThat((Object)ipAddress.toString(), (Matcher)Matchers.is((Object)"1.2.3.4"));
        ipAddress = IpAddress.valueOf((String)"0.0.0.0");
        Assert.assertThat((Object)ipAddress.toString(), (Matcher)Matchers.is((Object)"0.0.0.0"));
        ipAddress = IpAddress.valueOf((String)"255.255.255.255");
        Assert.assertThat((Object)ipAddress.toString(), (Matcher)Matchers.is((Object)"255.255.255.255"));
    }

    @Test
    public void testValueOfStringIPv6() {
        IpAddress ipAddress = IpAddress.valueOf((String)"1111:2222:3333:4444:5555:6666:7777:8888");
        Assert.assertThat((Object)ipAddress.toString(), (Matcher)Matchers.is((Object)"1111:2222:3333:4444:5555:6666:7777:8888"));
        ipAddress = IpAddress.valueOf((String)"::");
        Assert.assertThat((Object)ipAddress.toString(), (Matcher)Matchers.is((Object)"::"));
        ipAddress = IpAddress.valueOf((String)"ffff:ffff:ffff:ffff:ffff:ffff:ffff:ffff");
        Assert.assertThat((Object)ipAddress.toString(), (Matcher)Matchers.is((Object)"ffff:ffff:ffff:ffff:ffff:ffff:ffff:ffff"));
    }

    @Test(expected=NullPointerException.class)
    public void testInvalidValueOfNullString() {
        String fromString = null;
        IpAddress ipAddress = IpAddress.valueOf(fromString);
    }

    @Test(expected=IllegalArgumentException.class)
    public void testInvalidValueOfEmptyString() {
        String fromString = "";
        IpAddress ipAddress = IpAddress.valueOf((String)fromString);
    }

    @Test(expected=IllegalArgumentException.class)
    public void testInvalidValueOfIncorrectString() {
        String fromString = "NoSuchIpAddress";
        IpAddress ipAddress = IpAddress.valueOf((String)fromString);
    }

    @Test
    public void testMakeMaskPrefixIPv4() {
        IpAddress ipAddress = IpAddress.makeMaskPrefix((IpAddress.Version)IpAddress.Version.INET, (int)25);
        Assert.assertThat((Object)ipAddress.toString(), (Matcher)Matchers.is((Object)"255.255.255.128"));
        ipAddress = IpAddress.makeMaskPrefix((IpAddress.Version)IpAddress.Version.INET, (int)0);
        Assert.assertThat((Object)ipAddress.toString(), (Matcher)Matchers.is((Object)"0.0.0.0"));
        ipAddress = IpAddress.makeMaskPrefix((IpAddress.Version)IpAddress.Version.INET, (int)32);
        Assert.assertThat((Object)ipAddress.toString(), (Matcher)Matchers.is((Object)"255.255.255.255"));
    }

    @Test
    public void testMakeMaskPrefixIPv6() {
        IpAddress ipAddress = IpAddress.makeMaskPrefix((IpAddress.Version)IpAddress.Version.INET6, (int)8);
        Assert.assertThat((Object)ipAddress.toString(), (Matcher)Matchers.is((Object)"ff00::"));
        ipAddress = IpAddress.makeMaskPrefix((IpAddress.Version)IpAddress.Version.INET6, (int)120);
        Assert.assertThat((Object)ipAddress.toString(), (Matcher)Matchers.is((Object)"ffff:ffff:ffff:ffff:ffff:ffff:ffff:ff00"));
        ipAddress = IpAddress.makeMaskPrefix((IpAddress.Version)IpAddress.Version.INET6, (int)0);
        Assert.assertThat((Object)ipAddress.toString(), (Matcher)Matchers.is((Object)"::"));
        ipAddress = IpAddress.makeMaskPrefix((IpAddress.Version)IpAddress.Version.INET6, (int)128);
        Assert.assertThat((Object)ipAddress.toString(), (Matcher)Matchers.is((Object)"ffff:ffff:ffff:ffff:ffff:ffff:ffff:ffff"));
        ipAddress = IpAddress.makeMaskPrefix((IpAddress.Version)IpAddress.Version.INET6, (int)64);
        Assert.assertThat((Object)ipAddress.toString(), (Matcher)Matchers.is((Object)"ffff:ffff:ffff:ffff::"));
    }

    @Test(expected=IllegalArgumentException.class)
    public void testInvalidMakeNegativeMaskPrefixIPv4() {
        IpAddress ipAddress = IpAddress.makeMaskPrefix((IpAddress.Version)IpAddress.Version.INET, (int)-1);
    }

    @Test(expected=IllegalArgumentException.class)
    public void testInvalidMakeNegativeMaskPrefixIPv6() {
        IpAddress ipAddress = IpAddress.makeMaskPrefix((IpAddress.Version)IpAddress.Version.INET6, (int)-1);
    }

    @Test(expected=IllegalArgumentException.class)
    public void testInvalidMakeTooLongMaskPrefixIPv4() {
        IpAddress ipAddress = IpAddress.makeMaskPrefix((IpAddress.Version)IpAddress.Version.INET, (int)33);
    }

    @Test(expected=IllegalArgumentException.class)
    public void testInvalidMakeTooLongMaskPrefixIPv6() {
        IpAddress ipAddress = IpAddress.makeMaskPrefix((IpAddress.Version)IpAddress.Version.INET6, (int)129);
    }

    @Test
    public void testMakeMaskedAddressIPv4() {
        IpAddress ipAddress = IpAddress.valueOf((String)"1.2.3.5");
        IpAddress ipAddressMasked = IpAddress.makeMaskedAddress((IpAddress)ipAddress, (int)24);
        Assert.assertThat((Object)ipAddressMasked.toString(), (Matcher)Matchers.is((Object)"1.2.3.0"));
        ipAddressMasked = IpAddress.makeMaskedAddress((IpAddress)ipAddress, (int)0);
        Assert.assertThat((Object)ipAddressMasked.toString(), (Matcher)Matchers.is((Object)"0.0.0.0"));
        ipAddressMasked = IpAddress.makeMaskedAddress((IpAddress)ipAddress, (int)32);
        Assert.assertThat((Object)ipAddressMasked.toString(), (Matcher)Matchers.is((Object)"1.2.3.5"));
    }

    @Test
    public void testMakeMaskedAddressIPv6() {
        IpAddress ipAddress = IpAddress.valueOf((String)"1111:2222:3333:4444:5555:6666:7777:8885");
        IpAddress ipAddressMasked = IpAddress.makeMaskedAddress((IpAddress)ipAddress, (int)8);
        Assert.assertThat((Object)ipAddressMasked.toString(), (Matcher)Matchers.is((Object)"1100::"));
        ipAddressMasked = IpAddress.makeMaskedAddress((IpAddress)ipAddress, (int)120);
        Assert.assertThat((Object)ipAddressMasked.toString(), (Matcher)Matchers.is((Object)"1111:2222:3333:4444:5555:6666:7777:8800"));
        ipAddressMasked = IpAddress.makeMaskedAddress((IpAddress)ipAddress, (int)0);
        Assert.assertThat((Object)ipAddressMasked.toString(), (Matcher)Matchers.is((Object)"::"));
        ipAddressMasked = IpAddress.makeMaskedAddress((IpAddress)ipAddress, (int)128);
        Assert.assertThat((Object)ipAddressMasked.toString(), (Matcher)Matchers.is((Object)"1111:2222:3333:4444:5555:6666:7777:8885"));
        ipAddressMasked = IpAddress.makeMaskedAddress((IpAddress)ipAddress, (int)64);
        Assert.assertThat((Object)ipAddressMasked.toString(), (Matcher)Matchers.is((Object)"1111:2222:3333:4444::"));
    }

    @Test(expected=IllegalArgumentException.class)
    public void testInvalidMakeNegativeMaskedAddressIPv4() {
        IpAddress ipAddress = IpAddress.valueOf((String)"1.2.3.5");
        IpAddress ipAddressMasked = IpAddress.makeMaskedAddress((IpAddress)ipAddress, (int)-1);
    }

    @Test(expected=IllegalArgumentException.class)
    public void testInvalidMakeNegativeMaskedAddressIPv6() {
        IpAddress ipAddress = IpAddress.valueOf((String)"1111:2222:3333:4444:5555:6666:7777:8885");
        IpAddress ipAddressMasked = IpAddress.makeMaskedAddress((IpAddress)ipAddress, (int)-1);
    }

    @Test(expected=IllegalArgumentException.class)
    public void testInvalidMakeTooLongMaskedAddressIPv4() {
        IpAddress ipAddress = IpAddress.valueOf((String)"1.2.3.5");
        IpAddress ipAddressMasked = IpAddress.makeMaskedAddress((IpAddress)ipAddress, (int)33);
    }

    @Test(expected=IllegalArgumentException.class)
    public void testInvalidMakeTooLongMaskedAddressIPv6() {
        IpAddress ipAddress = IpAddress.valueOf((String)"1111:2222:3333:4444:5555:6666:7777:8885");
        IpAddress ipAddressMasked = IpAddress.makeMaskedAddress((IpAddress)ipAddress, (int)129);
    }

    @Test
    public void testIsZeroIPv4() {
        IpAddress normalIP = IpAddress.valueOf((String)"10.0.0.1");
        IpAddress zeroIP = IpAddress.valueOf((String)"0.0.0.0");
        Assert.assertFalse((boolean)normalIP.isZero());
        Assert.assertTrue((boolean)zeroIP.isZero());
    }

    @Test
    public void testIsZeroIPv6() {
        IpAddress normalIP = IpAddress.valueOf((String)"fe80::1");
        IpAddress zeroIP = IpAddress.valueOf((String)"::");
        Assert.assertFalse((boolean)normalIP.isZero());
        Assert.assertTrue((boolean)zeroIP.isZero());
    }

    @Test
    public void testIsSelfAssignedIpv4() {
        IpAddress normalIP = IpAddress.valueOf((String)"10.0.0.1");
        IpAddress selfAssignedIP = IpAddress.valueOf((String)"169.1.2.3");
        Assert.assertFalse((boolean)normalIP.isSelfAssigned());
        Assert.assertTrue((boolean)selfAssignedIP.isSelfAssigned());
    }

    @Test
    public void testIsMulticast() {
        IpAddress v4Unicast = IpAddress.valueOf((String)"10.0.0.1");
        IpAddress v4Multicast = IpAddress.valueOf((String)"224.0.0.1");
        IpAddress v6Unicast = IpAddress.valueOf((String)"1000::1");
        IpAddress v6Multicast = IpAddress.valueOf((String)"ff02::1");
        Assert.assertFalse((boolean)v4Unicast.isMulticast());
        Assert.assertTrue((boolean)v4Multicast.isMulticast());
        Assert.assertFalse((boolean)v6Unicast.isMulticast());
        Assert.assertTrue((boolean)v6Multicast.isMulticast());
    }

    @Test
    public void testComparisonIPv4() {
        IpAddress addr1 = IpAddress.valueOf((String)"1.2.3.4");
        IpAddress addr2 = IpAddress.valueOf((String)"1.2.3.4");
        IpAddress addr3 = IpAddress.valueOf((String)"1.2.3.3");
        IpAddress addr4 = IpAddress.valueOf((String)"1.2.3.5");
        Assert.assertTrue((addr1.compareTo(addr2) == 0 ? 1 : 0) != 0);
        Assert.assertTrue((addr1.compareTo(addr3) > 0 ? 1 : 0) != 0);
        Assert.assertTrue((addr1.compareTo(addr4) < 0 ? 1 : 0) != 0);
        addr1 = IpAddress.valueOf((String)"255.2.3.4");
        addr2 = IpAddress.valueOf((String)"255.2.3.4");
        addr3 = IpAddress.valueOf((String)"255.2.3.3");
        addr4 = IpAddress.valueOf((String)"255.2.3.5");
        Assert.assertTrue((addr1.compareTo(addr2) == 0 ? 1 : 0) != 0);
        Assert.assertTrue((addr1.compareTo(addr3) > 0 ? 1 : 0) != 0);
        Assert.assertTrue((addr1.compareTo(addr4) < 0 ? 1 : 0) != 0);
    }

    @Test
    public void testComparisonIPv6() {
        IpAddress addr1 = IpAddress.valueOf((String)"1111:2222:3333:4444:5555:6666:7777:8888");
        IpAddress addr2 = IpAddress.valueOf((String)"1111:2222:3333:4444:5555:6666:7777:8888");
        IpAddress addr3 = IpAddress.valueOf((String)"1111:2222:3333:4444:5555:6666:7777:8887");
        IpAddress addr4 = IpAddress.valueOf((String)"1111:2222:3333:4444:5555:6666:7777:8889");
        Assert.assertTrue((addr1.compareTo(addr2) == 0 ? 1 : 0) != 0);
        Assert.assertTrue((addr1.compareTo(addr3) > 0 ? 1 : 0) != 0);
        Assert.assertTrue((addr1.compareTo(addr4) < 0 ? 1 : 0) != 0);
        addr1 = IpAddress.valueOf((String)"ffff:2222:3333:4444:5555:6666:7777:8888");
        addr2 = IpAddress.valueOf((String)"ffff:2222:3333:4444:5555:6666:7777:8888");
        addr3 = IpAddress.valueOf((String)"ffff:2222:3333:4444:5555:6666:7777:8887");
        addr4 = IpAddress.valueOf((String)"ffff:2222:3333:4444:5555:6666:7777:8889");
        Assert.assertTrue((addr1.compareTo(addr2) == 0 ? 1 : 0) != 0);
        Assert.assertTrue((addr1.compareTo(addr3) > 0 ? 1 : 0) != 0);
        Assert.assertTrue((addr1.compareTo(addr4) < 0 ? 1 : 0) != 0);
        addr1 = IpAddress.valueOf((String)"ffff:2222:3333:4444:5555:6666:7777:8888");
        addr2 = IpAddress.valueOf((String)"ffff:2222:3333:4444:5555:6666:7777:8888");
        addr3 = IpAddress.valueOf((String)"ffff:2222:3333:4443:5555:6666:7777:8888");
        addr4 = IpAddress.valueOf((String)"ffff:2222:3333:4445:5555:6666:7777:8888");
        Assert.assertTrue((addr1.compareTo(addr2) == 0 ? 1 : 0) != 0);
        Assert.assertTrue((addr1.compareTo(addr3) > 0 ? 1 : 0) != 0);
        Assert.assertTrue((addr1.compareTo(addr4) < 0 ? 1 : 0) != 0);
    }

    @Test
    public void testEqualityIPv4() {
        new EqualsTester().addEqualityGroup(new Object[]{IpAddress.valueOf((String)"1.2.3.4"), IpAddress.valueOf((String)"1.2.3.4")}).addEqualityGroup(new Object[]{IpAddress.valueOf((String)"1.2.3.5"), IpAddress.valueOf((String)"1.2.3.5")}).addEqualityGroup(new Object[]{IpAddress.valueOf((String)"0.0.0.0"), IpAddress.valueOf((String)"0.0.0.0")}).addEqualityGroup(new Object[]{IpAddress.valueOf((String)"255.255.255.255"), IpAddress.valueOf((String)"255.255.255.255")}).testEquals();
    }

    @Test
    public void testEqualityIPv6() {
        new EqualsTester().addEqualityGroup(new Object[]{IpAddress.valueOf((String)"1111:2222:3333:4444:5555:6666:7777:8888"), IpAddress.valueOf((String)"1111:2222:3333:4444:5555:6666:7777:8888")}).addEqualityGroup(new Object[]{IpAddress.valueOf((String)"1111:2222:3333:4444:5555:6666:7777:888a"), IpAddress.valueOf((String)"1111:2222:3333:4444:5555:6666:7777:888a")}).addEqualityGroup(new Object[]{IpAddress.valueOf((String)"::"), IpAddress.valueOf((String)"::")}).addEqualityGroup(new Object[]{IpAddress.valueOf((String)"ffff:ffff:ffff:ffff:ffff:ffff:ffff:ffff"), IpAddress.valueOf((String)"ffff:ffff:ffff:ffff:ffff:ffff:ffff:ffff")}).testEquals();
    }

    @Test
    public void testToStringIPv4() {
        IpAddress ipAddress = IpAddress.valueOf((String)"1.2.3.4");
        Assert.assertThat((Object)ipAddress.toString(), (Matcher)Matchers.is((Object)"1.2.3.4"));
        ipAddress = IpAddress.valueOf((String)"0.0.0.0");
        Assert.assertThat((Object)ipAddress.toString(), (Matcher)Matchers.is((Object)"0.0.0.0"));
        ipAddress = IpAddress.valueOf((String)"255.255.255.255");
        Assert.assertThat((Object)ipAddress.toString(), (Matcher)Matchers.is((Object)"255.255.255.255"));
    }

    @Test
    public void testToStringIPv6() {
        IpAddress ipAddress = IpAddress.valueOf((String)"1111:2222:3333:4444:5555:6666:7777:8888");
        Assert.assertThat((Object)ipAddress.toString(), (Matcher)Matchers.is((Object)"1111:2222:3333:4444:5555:6666:7777:8888"));
        ipAddress = IpAddress.valueOf((String)"1111::8888");
        Assert.assertThat((Object)ipAddress.toString(), (Matcher)Matchers.is((Object)"1111::8888"));
        ipAddress = IpAddress.valueOf((String)"1111::");
        Assert.assertThat((Object)ipAddress.toString(), (Matcher)Matchers.is((Object)"1111::"));
        ipAddress = IpAddress.valueOf((String)"::8888");
        Assert.assertThat((Object)ipAddress.toString(), (Matcher)Matchers.is((Object)"::8888"));
        ipAddress = IpAddress.valueOf((String)"::");
        Assert.assertThat((Object)ipAddress.toString(), (Matcher)Matchers.is((Object)"::"));
        ipAddress = IpAddress.valueOf((String)"ffff:ffff:ffff:ffff:ffff:ffff:ffff:ffff");
        Assert.assertThat((Object)ipAddress.toString(), (Matcher)Matchers.is((Object)"ffff:ffff:ffff:ffff:ffff:ffff:ffff:ffff"));
        ipAddress = IpAddress.valueOf((String)"::1111:2222");
        Assert.assertThat((Object)ipAddress.toString(), (Matcher)Matchers.is((Object)"::1111:2222"));
        ipAddress = IpAddress.valueOf((String)"1:0:0:1:0:0:2:3");
        Assert.assertThat((Object)ipAddress.toString(), (Matcher)Matchers.is((Object)"1::1:0:0:2:3"));
        ipAddress = IpAddress.valueOf((String)"::0123:0004");
        Assert.assertThat((Object)ipAddress.toString(), (Matcher)Matchers.is((Object)"::123:4"));
        ipAddress = IpAddress.valueOf((String)"0:0:1:1:0:0:1:1");
        Assert.assertThat((Object)ipAddress.toString(), (Matcher)Matchers.is((Object)"::1:1:0:0:1:1"));
        ipAddress = IpAddress.valueOf((String)"1:1a2b::");
        Assert.assertThat((Object)ipAddress.toString(), (Matcher)Matchers.is((Object)"1:1a2b::"));
        ipAddress = IpAddress.valueOf((String)"0:0:00:00:0000:00:00:000");
        Assert.assertThat((Object)ipAddress.toString(), (Matcher)Matchers.is((Object)"::"));
        ipAddress = IpAddress.valueOf((String)"0:0:0:1:0:0:0:0");
        Assert.assertThat((Object)ipAddress.toString(), (Matcher)Matchers.is((Object)"0:0:0:1::"));
    }
}

