/*
 * Decompiled with CFR 0.152.
 */
package org.onlab.util;

import java.util.Optional;
import java.util.concurrent.ThreadFactory;
import java.util.stream.Stream;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.Test;
import org.onlab.junit.TestTools;
import org.onlab.util.Tools;

public class ToolsTest {
    @Test
    public void fromHex() throws Exception {
        Assert.assertEquals((long)15L, (long)Tools.fromHex((String)"0f"));
        Assert.assertEquals((long)16L, (long)Tools.fromHex((String)"10"));
        Assert.assertEquals((long)65535L, (long)Tools.fromHex((String)"ffff"));
        Assert.assertEquals((long)4096L, (long)Tools.fromHex((String)"1000"));
        Assert.assertEquals((long)-1L, (long)Tools.fromHex((String)"ffffffffffffffff"));
    }

    @Test
    public void toHex() throws Exception {
        Assert.assertEquals((Object)"0f", (Object)Tools.toHex((long)15L, (int)2));
        Assert.assertEquals((Object)"ffff", (Object)Tools.toHex((long)65535L, (int)4));
        Assert.assertEquals((Object)"1000", (Object)Tools.toHex((long)4096L, (int)4));
        Assert.assertEquals((Object)"000000000000000f", (Object)Tools.toHex((long)15L));
        Assert.assertEquals((Object)"ffffffffffffffff", (Object)Tools.toHex((long)-1L));
    }

    @Test
    public void namedThreads() {
        ThreadFactory f = Tools.namedThreads((String)"foo-%d");
        Thread t = f.newThread(() -> TestTools.print((String)"yo"));
        Assert.assertTrue((String)"wrong pattern", (boolean)t.getName().startsWith("foo-"));
    }

    @Test
    public void groupedThreads() {
        ThreadFactory f = Tools.groupedThreads((String)"foo/bar-me", (String)"foo-%d");
        Thread t = f.newThread(() -> TestTools.print((String)"yo"));
        Assert.assertTrue((String)"wrong pattern", (boolean)t.getName().startsWith("foo-bar-me-foo-"));
        Assert.assertTrue((String)"wrong group", (boolean)t.getThreadGroup().getName().equals("foo/bar-me"));
    }

    @Test
    public void exceptionHandler() throws InterruptedException {
        ThreadFactory f = Tools.namedThreads((String)"foo");
        Thread t = f.newThread(() -> {
            throw new IllegalStateException("BOOM!");
        });
        Assert.assertNotNull((String)"thread should have exception handler", (Object)t.getUncaughtExceptionHandler());
        t.start();
        TestTools.assertAfter((int)100, () -> Assert.assertEquals((String)"incorrect thread state", (Object)((Object)Thread.State.TERMINATED), (Object)((Object)t.getState())));
    }

    @Test
    public void testOptionalStream() {
        Stream empty = Tools.stream(Optional.empty());
        Assert.assertThat((Object)empty.count(), (Matcher)Matchers.is((Object)0L));
        String value = "value";
        Stream stream = Tools.stream(Optional.of(value));
        Assert.assertThat((Object)stream.allMatch(value::equals), (Matcher)Matchers.is((Object)true));
    }
}

