/*
 * Decompiled with CFR 0.152.
 */
package org.onlab.packet;

import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import java.nio.ByteBuffer;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import org.onlab.packet.Data;
import org.onlab.packet.DeserializationException;
import org.onlab.packet.Deserializer;
import org.onlab.packet.ICMP6;
import org.onlab.packet.IP;
import org.onlab.packet.IPacket;
import org.onlab.packet.PacketUtils;
import org.onlab.packet.TCP;
import org.onlab.packet.UDP;
import org.onlab.packet.ipv6.Authentication;
import org.onlab.packet.ipv6.DestinationOptions;
import org.onlab.packet.ipv6.EncapSecurityPayload;
import org.onlab.packet.ipv6.Fragment;
import org.onlab.packet.ipv6.HopByHopOptions;
import org.onlab.packet.ipv6.IExtensionHeader;
import org.onlab.packet.ipv6.Routing;

public class IPv6
extends IP
implements IExtensionHeader {
    public static final byte FIXED_HEADER_LENGTH = 40;
    public static final byte PROTOCOL_TCP = 6;
    public static final byte PROTOCOL_UDP = 17;
    public static final byte PROTOCOL_ICMP6 = 58;
    public static final byte PROTOCOL_HOPOPT = 0;
    public static final byte PROTOCOL_ROUTING = 43;
    public static final byte PROTOCOL_FRAG = 44;
    public static final byte PROTOCOL_ESP = 50;
    public static final byte PROTOCOL_AH = 51;
    public static final byte PROTOCOL_DSTOPT = 60;
    public static final byte LINK_LOCAL_0 = -2;
    public static final byte LINK_LOCAL_1 = -128;
    public static final Map<Byte, Deserializer<? extends IPacket>> PROTOCOL_DESERIALIZER_MAP = new HashMap<Byte, Deserializer<? extends IPacket>>();
    protected byte version;
    protected byte trafficClass;
    protected int flowLabel;
    protected short payloadLength;
    protected byte nextHeader;
    protected byte hopLimit;
    protected byte[] sourceAddress = new byte[16];
    protected byte[] destinationAddress = new byte[16];

    public IPv6() {
        this.version = (byte)6;
    }

    @Override
    public byte getVersion() {
        return this.version;
    }

    @Override
    public IPv6 setVersion(byte version) {
        this.version = version;
        return this;
    }

    public byte getTrafficClass() {
        return this.trafficClass;
    }

    public IPv6 setTrafficClass(byte trafficClass) {
        this.trafficClass = trafficClass;
        return this;
    }

    public int getFlowLabel() {
        return this.flowLabel;
    }

    public IPv6 setFlowLabel(int flowLabel) {
        this.flowLabel = flowLabel;
        return this;
    }

    @Override
    public byte getNextHeader() {
        return this.nextHeader;
    }

    @Override
    public IPv6 setNextHeader(byte nextHeader) {
        this.nextHeader = nextHeader;
        return this;
    }

    public byte getHopLimit() {
        return this.hopLimit;
    }

    public IPv6 setHopLimit(byte hopLimit) {
        this.hopLimit = hopLimit;
        return this;
    }

    public byte[] getSourceAddress() {
        return this.sourceAddress;
    }

    public IPv6 setSourceAddress(byte[] sourceAddress) {
        this.sourceAddress = Arrays.copyOfRange(sourceAddress, 0, 16);
        return this;
    }

    public byte[] getDestinationAddress() {
        return this.destinationAddress;
    }

    public IPv6 setDestinationAddress(byte[] destinationAddress) {
        this.destinationAddress = Arrays.copyOfRange(destinationAddress, 0, 16);
        return this;
    }

    @Override
    public byte[] serialize() {
        byte[] payloadData = null;
        if (this.payload != null) {
            this.payload.setParent(this);
            payloadData = this.payload.serialize();
        }
        this.payloadLength = 0;
        if (payloadData != null) {
            this.payloadLength = (short)payloadData.length;
        }
        byte[] data = new byte[40 + this.payloadLength];
        ByteBuffer bb = ByteBuffer.wrap(data);
        bb.putInt((this.version & 0xF) << 28 | (this.trafficClass & 0xFF) << 20 | this.flowLabel & 0xFFFFF);
        bb.putShort(this.payloadLength);
        bb.put(this.nextHeader);
        bb.put(this.hopLimit);
        bb.put(this.sourceAddress, 0, 16);
        bb.put(this.destinationAddress, 0, 16);
        if (payloadData != null) {
            bb.put(payloadData);
        }
        return data;
    }

    @Override
    public IPacket deserialize(byte[] data, int offset, int length) {
        ByteBuffer bb = ByteBuffer.wrap(data, offset, length);
        int iscratch = bb.getInt();
        this.version = (byte)(iscratch >> 28 & 0xF);
        this.trafficClass = (byte)(iscratch >> 20 & 0xFF);
        this.flowLabel = iscratch & 0xFFFFF;
        this.payloadLength = bb.getShort();
        this.nextHeader = bb.get();
        this.hopLimit = bb.get();
        bb.get(this.sourceAddress, 0, 16);
        bb.get(this.destinationAddress, 0, 16);
        Deserializer<IPacket> deserializer = PROTOCOL_DESERIALIZER_MAP.containsKey(this.nextHeader) ? PROTOCOL_DESERIALIZER_MAP.get(this.nextHeader) : Data.deserializer();
        try {
            this.payload = deserializer.deserialize(data, bb.position(), bb.limit() - bb.position());
            this.payload.setParent(this);
        }
        catch (DeserializationException e) {
            return this;
        }
        return this;
    }

    @Override
    public int hashCode() {
        int i;
        int prime = 2521;
        int result = super.hashCode();
        ByteBuffer bb = ByteBuffer.wrap(this.destinationAddress);
        for (i = 0; i < 4; ++i) {
            result = 2521 * result + bb.getInt();
        }
        result = 2521 * result + this.trafficClass;
        result = 2521 * result + this.flowLabel;
        result = 2521 * result + this.hopLimit;
        result = 2521 * result + this.nextHeader;
        result = 2521 * result + this.payloadLength;
        bb = ByteBuffer.wrap(this.sourceAddress);
        for (i = 0; i < 4; ++i) {
            result = 2521 * result + bb.getInt();
        }
        result = 2521 * result + this.version;
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        if (!(obj instanceof IPv6)) {
            return false;
        }
        IPv6 other = (IPv6)obj;
        if (!Arrays.equals(this.destinationAddress, other.destinationAddress)) {
            return false;
        }
        if (this.trafficClass != other.trafficClass) {
            return false;
        }
        if (this.flowLabel != other.flowLabel) {
            return false;
        }
        if (this.hopLimit != other.hopLimit) {
            return false;
        }
        if (this.nextHeader != other.nextHeader) {
            return false;
        }
        if (this.payloadLength != other.payloadLength) {
            return false;
        }
        return Arrays.equals(this.sourceAddress, other.sourceAddress);
    }

    public static Deserializer<IPv6> deserializer() {
        return (data, offset, length) -> {
            PacketUtils.checkInput(data, offset, length, 40);
            IPv6 ipv6 = new IPv6();
            ByteBuffer bb = ByteBuffer.wrap(data, offset, length);
            int iscratch = bb.getInt();
            ipv6.version = (byte)(iscratch >> 28 & 0xF);
            ipv6.trafficClass = (byte)(iscratch >> 20 & 0xFF);
            ipv6.flowLabel = iscratch & 0xFFFFF;
            ipv6.payloadLength = bb.getShort();
            ipv6.nextHeader = bb.get();
            ipv6.hopLimit = bb.get();
            bb.get(ipv6.sourceAddress, 0, 16);
            bb.get(ipv6.destinationAddress, 0, 16);
            Deserializer<IPacket> deserializer = PROTOCOL_DESERIALIZER_MAP.containsKey(ipv6.nextHeader) ? PROTOCOL_DESERIALIZER_MAP.get(ipv6.nextHeader) : Data.deserializer();
            ipv6.payload = deserializer.deserialize(data, bb.position(), bb.limit() - bb.position());
            ipv6.payload.setParent(ipv6);
            return ipv6;
        };
    }

    public String toString() {
        return MoreObjects.toStringHelper(this.getClass()).add("version", (Object)Byte.toString(this.version)).add("trafficClass", (Object)Byte.toString(this.trafficClass)).add("flowLabel", (Object)Integer.toString(this.flowLabel)).add("payloadLength", (Object)Short.toString(this.payloadLength)).add("nextHeader", (Object)Byte.toString(this.nextHeader)).add("hopLimit", (Object)Byte.toString(this.hopLimit)).add("sourceAddress", (Object)Arrays.toString(this.sourceAddress)).add("destinationAddress", (Object)Arrays.toString(this.destinationAddress)).toString();
    }

    public static byte[] getSolicitNodeAddress(byte[] targetIp) {
        Preconditions.checkArgument((targetIp.length == 16 ? 1 : 0) != 0);
        return new byte[]{-1, 2, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, -1, targetIp[targetIp.length - 3], targetIp[targetIp.length - 2], targetIp[targetIp.length - 1]};
    }

    public static byte[] getMCastMacAddress(byte[] targetIp) {
        Preconditions.checkArgument((targetIp.length == 16 ? 1 : 0) != 0);
        return new byte[]{51, 51, targetIp[targetIp.length - 4], targetIp[targetIp.length - 3], targetIp[targetIp.length - 2], targetIp[targetIp.length - 1]};
    }

    public static boolean isLinkLocalAddress(byte[] targetIp) {
        Preconditions.checkArgument((targetIp.length == 16 ? 1 : 0) != 0);
        return (targetIp[0] & 0xFF) == 254 && (targetIp[1] & 0xC0) == 128;
    }

    public static byte[] getLinkLocalAddress(byte[] macAddress) {
        Preconditions.checkArgument((macAddress.length == 6 ? 1 : 0) != 0);
        return new byte[]{-2, -128, 0, 0, 0, 0, 0, 0, (byte)(macAddress[0] ^ 2), macAddress[1], macAddress[2], -1, -2, macAddress[3], macAddress[4], macAddress[5]};
    }

    public static byte[] getMacAddress(byte[] linkLocalAddress) {
        byte[] byArray;
        if (!IPv6.isLinkLocalAddress(linkLocalAddress)) {
            byArray = null;
        } else {
            byte[] byArray2 = new byte[6];
            byArray2[0] = (byte)(linkLocalAddress[8] ^ 2);
            byArray2[1] = linkLocalAddress[9];
            byArray2[2] = linkLocalAddress[10];
            byArray2[3] = linkLocalAddress[13];
            byArray2[4] = linkLocalAddress[14];
            byArray = byArray2;
            byArray2[5] = linkLocalAddress[15];
        }
        return byArray;
    }

    static {
        PROTOCOL_DESERIALIZER_MAP.put((byte)58, ICMP6.deserializer());
        PROTOCOL_DESERIALIZER_MAP.put((byte)6, TCP.deserializer());
        PROTOCOL_DESERIALIZER_MAP.put((byte)17, UDP.deserializer());
        PROTOCOL_DESERIALIZER_MAP.put((byte)0, HopByHopOptions.deserializer());
        PROTOCOL_DESERIALIZER_MAP.put((byte)43, Routing.deserializer());
        PROTOCOL_DESERIALIZER_MAP.put((byte)44, Fragment.deserializer());
        PROTOCOL_DESERIALIZER_MAP.put((byte)50, EncapSecurityPayload.deserializer());
        PROTOCOL_DESERIALIZER_MAP.put((byte)51, Authentication.deserializer());
        PROTOCOL_DESERIALIZER_MAP.put((byte)60, DestinationOptions.deserializer());
    }
}

