/*
 * Decompiled with CFR 0.152.
 */
package org.onlab.graph;

import com.google.common.collect.ImmutableSet;
import java.util.Set;
import org.onlab.graph.EdgeWeigher;
import org.onlab.graph.Graph;
import org.onlab.graph.Path;
import org.onlab.graph.TestDoubleWeight;
import org.onlab.graph.TestEdge;
import org.onlab.graph.TestVertex;
import org.onlab.graph.Weight;

public class GraphTest {
    static final TestVertex A = new TestVertex("A");
    static final TestVertex B = new TestVertex("B");
    static final TestVertex C = new TestVertex("C");
    static final TestVertex D = new TestVertex("D");
    static final TestVertex E = new TestVertex("E");
    static final TestVertex F = new TestVertex("F");
    static final TestVertex G = new TestVertex("G");
    static final TestVertex H = new TestVertex("H");
    static final TestVertex Z = new TestVertex("Z");
    static final TestDoubleWeight ZW = new TestDoubleWeight(0.0);
    static final TestDoubleWeight NW5 = new TestDoubleWeight(-5.0);
    static final TestDoubleWeight NW2 = new TestDoubleWeight(-2.0);
    static final TestDoubleWeight NW1 = new TestDoubleWeight(-1.0);
    static final TestDoubleWeight W1 = new TestDoubleWeight(1.0);
    static final TestDoubleWeight W2 = new TestDoubleWeight(2.0);
    static final TestDoubleWeight W3 = new TestDoubleWeight(3.0);
    static final TestDoubleWeight W4 = new TestDoubleWeight(4.0);
    static final TestDoubleWeight W5 = new TestDoubleWeight(5.0);
    protected Graph<TestVertex, TestEdge> graph;
    protected EdgeWeigher<TestVertex, TestEdge> weigher = new EdgeWeigher<TestVertex, TestEdge>(){

        public Weight weight(TestEdge edge) {
            return edge.weight();
        }

        public Weight getInitialWeight() {
            return ZW;
        }

        public Weight getNonViableWeight() {
            return TestDoubleWeight.NON_VIABLE_WEIGHT;
        }
    };

    protected void printPaths(Set<Path<TestVertex, TestEdge>> paths) {
        for (Path<TestVertex, TestEdge> p : paths) {
            System.out.println(p);
        }
    }

    protected Set<TestVertex> vertexes() {
        return ImmutableSet.of((Object)A, (Object)B, (Object)C, (Object)D, (Object)E, (Object)F, (Object[])new TestVertex[]{G, H});
    }

    protected Set<TestEdge> edges() {
        return ImmutableSet.of((Object)((Object)new TestEdge(A, B, W1)), (Object)((Object)new TestEdge(A, C, W3)), (Object)((Object)new TestEdge(B, D, W2)), (Object)((Object)new TestEdge(B, C, W1)), (Object)((Object)new TestEdge(B, E, W4)), (Object)((Object)new TestEdge(C, E, W1)), (Object[])new TestEdge[]{new TestEdge(D, H, W5), new TestEdge(D, E, W1), new TestEdge(E, F, W1), new TestEdge(F, D, W1), new TestEdge(F, G, W1), new TestEdge(F, H, W1)});
    }
}

