/*
 * Decompiled with CFR 0.152.
 */
package org.onlab.util;

import junit.framework.TestCase;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Ignore;
import org.junit.Test;
import org.onlab.util.SlidingWindowCounter;

@Ignore(value="Disable these for now because of intermittent load related failures on Jenkins runs.")
public class SlidingWindowCounterTest {
    private SlidingWindowCounter counter;

    @Before
    public void setUp() {
        this.counter = new SlidingWindowCounter(2);
    }

    @After
    public void tearDown() {
        this.counter.destroy();
    }

    @Test
    public void testIncrementCount() {
        Assert.assertEquals((long)0L, (long)this.counter.get(1));
        Assert.assertEquals((long)0L, (long)this.counter.get(2));
        this.counter.incrementCount();
        Assert.assertEquals((long)1L, (long)this.counter.get(1));
        Assert.assertEquals((long)1L, (long)this.counter.get(2));
        this.counter.incrementCount(2L);
        Assert.assertEquals((long)3L, (long)this.counter.get(2));
    }

    @Test
    public void testSlide() {
        this.counter.incrementCount();
        this.counter.advanceHead();
        Assert.assertEquals((long)0L, (long)this.counter.get(1));
        Assert.assertEquals((long)1L, (long)this.counter.get(2));
        this.counter.incrementCount(2L);
        Assert.assertEquals((long)2L, (long)this.counter.get(1));
        Assert.assertEquals((long)3L, (long)this.counter.get(2));
    }

    @Test
    public void testWrap() {
        this.counter.incrementCount();
        this.counter.advanceHead();
        this.counter.incrementCount(2L);
        this.counter.advanceHead();
        Assert.assertEquals((long)0L, (long)this.counter.get(1));
        Assert.assertEquals((long)2L, (long)this.counter.get(2));
        this.counter.advanceHead();
        Assert.assertEquals((long)0L, (long)this.counter.get(1));
        Assert.assertEquals((long)0L, (long)this.counter.get(2));
    }

    @Test
    public void testCornerCases() {
        try {
            this.counter.get(3);
            TestCase.fail((String)"Exception should have been thrown");
        }
        catch (IllegalArgumentException e) {
            Assert.assertTrue((boolean)true);
        }
        try {
            new SlidingWindowCounter(0);
            TestCase.fail((String)"Exception should have been thrown");
        }
        catch (IllegalArgumentException e) {
            Assert.assertTrue((boolean)true);
        }
        try {
            new SlidingWindowCounter(-1);
            TestCase.fail((String)"Exception should have been thrown");
        }
        catch (IllegalArgumentException e) {
            Assert.assertTrue((boolean)true);
        }
    }
}

