/*
 * Decompiled with CFR 0.152.
 */
package org.onlab.util;

import com.google.common.collect.ComparisonChain;
import org.onlab.util.Bandwidth;

final class LongBandwidth
implements Bandwidth {
    private final long bps;

    LongBandwidth(long bps) {
        this.bps = bps;
    }

    private LongBandwidth() {
        this.bps = 0L;
    }

    @Override
    public double bps() {
        return this.bps;
    }

    @Override
    public Bandwidth add(Bandwidth value) {
        if (value instanceof LongBandwidth) {
            return Bandwidth.bps(this.bps + ((LongBandwidth)value).bps);
        }
        return Bandwidth.bps((double)this.bps + value.bps());
    }

    @Override
    public Bandwidth subtract(Bandwidth value) {
        if (value instanceof LongBandwidth) {
            return Bandwidth.bps(this.bps - ((LongBandwidth)value).bps);
        }
        return Bandwidth.bps((double)this.bps - value.bps());
    }

    @Override
    public int compareTo(Bandwidth other) {
        if (other instanceof LongBandwidth) {
            return ComparisonChain.start().compare(this.bps, ((LongBandwidth)other).bps).result();
        }
        return ComparisonChain.start().compare((double)this.bps, other.bps()).result();
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj instanceof Bandwidth) {
            return this.compareTo((Bandwidth)obj) == 0;
        }
        return false;
    }

    public int hashCode() {
        return Long.hashCode(this.bps);
    }

    public String toString() {
        return String.valueOf(this.bps);
    }
}

