/*
 * Decompiled with CFR 0.152.
 */
package org.onlab.graph;

import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;

public class Heap<T> {
    private final List<T> data;
    private final Comparator<T> comparator;

    public Heap(List<T> data, Comparator<T> comparator) {
        this.data = (List)Preconditions.checkNotNull(data, (Object)"Data cannot be null");
        this.comparator = (Comparator)Preconditions.checkNotNull(comparator, (Object)"Comparator cannot be null");
        this.heapify();
    }

    public void heapify() {
        for (int i = this.data.size() / 2; i >= 0; --i) {
            this.heapify(i);
        }
    }

    public int size() {
        return this.data.size();
    }

    public boolean isEmpty() {
        return this.data.isEmpty();
    }

    public T extreme() {
        return this.data.isEmpty() ? null : (T)this.data.get(0);
    }

    public T extractExtreme() {
        if (!this.isEmpty()) {
            T extreme = this.extreme();
            this.data.set(0, this.data.get(this.data.size() - 1));
            this.data.remove(this.data.size() - 1);
            this.heapify();
            return extreme;
        }
        return null;
    }

    public Heap<T> insert(T item) {
        this.data.add(item);
        this.bubbleUp();
        return this;
    }

    public Iterator<T> iterator() {
        return ImmutableList.copyOf(this.data).iterator();
    }

    private void bubbleUp() {
        int child = this.data.size() - 1;
        while (child > 0) {
            int parent = child / 2;
            if (this.comparator.compare(this.data.get(child), this.data.get(parent)) < 0) break;
            this.swap(child, parent);
            child = parent;
        }
    }

    private void heapify(int i) {
        int left = 2 * i + 1;
        int right = 2 * i;
        int extreme = i;
        if (left < this.data.size() && this.comparator.compare(this.data.get(extreme), this.data.get(left)) < 0) {
            extreme = left;
        }
        if (right < this.data.size() && this.comparator.compare(this.data.get(extreme), this.data.get(right)) < 0) {
            extreme = right;
        }
        if (extreme != i) {
            this.swap(i, extreme);
            this.heapify(extreme);
        }
    }

    private void swap(int i, int k) {
        T aux = this.data.get(i);
        this.data.set(i, this.data.get(k));
        this.data.set(k, aux);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof Heap) {
            Heap that = (Heap)obj;
            return this.getClass() == that.getClass() && Objects.equals(this.comparator, that.comparator) && Objects.deepEquals(this.data, that.data);
        }
        return false;
    }

    public int hashCode() {
        return Objects.hash(this.comparator, this.data);
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("data", this.data).add("comparator", this.comparator).toString();
    }
}

