/*
 * Decompiled with CFR 0.152.
 */
package org.onlab.graph;

import com.google.common.collect.ImmutableSet;
import java.util.Set;
import org.junit.Assert;
import org.junit.Test;
import org.onlab.graph.AbstractGraphPathSearch;
import org.onlab.graph.AdjacencyListsGraph;
import org.onlab.graph.BreadthFirstSearchTest;
import org.onlab.graph.DisjointPathPair;
import org.onlab.graph.EdgeWeigher;
import org.onlab.graph.Graph;
import org.onlab.graph.GraphPathSearch;
import org.onlab.graph.ScalarWeight;
import org.onlab.graph.SuurballeGraphSearch;
import org.onlab.graph.TestDoubleWeight;
import org.onlab.graph.TestEdge;
import org.onlab.graph.TestVertex;
import org.onlab.graph.Vertex;
import org.onlab.graph.Weight;

public class SuurballeGraphSearchTest
extends BreadthFirstSearchTest {
    @Override
    protected AbstractGraphPathSearch<TestVertex, TestEdge> graphSearch() {
        return new SuurballeGraphSearch();
    }

    @Override
    public void defaultGraphTest() {
    }

    @Override
    public void defaultHopCountWeight() {
    }

    @Test
    public void basicGraphTest() {
        AdjacencyListsGraph graph = new AdjacencyListsGraph((Set)ImmutableSet.of((Object)A, (Object)B, (Object)C, (Object)D), (Set)ImmutableSet.of((Object)((Object)new TestEdge(A, B)), (Object)((Object)new TestEdge(B, C)), (Object)((Object)new TestEdge(A, D)), (Object)((Object)new TestEdge(D, C))));
        this.executeSearch((GraphPathSearch<TestVertex, TestEdge>)this.graphSearch(), (Graph<TestVertex, TestEdge>)graph, A, C, null, 1, (Weight)new ScalarWeight(4.0));
    }

    @Test
    public void multiplePathOnePairGraphTest() {
        AdjacencyListsGraph graph = new AdjacencyListsGraph((Set)ImmutableSet.of((Object)A, (Object)B, (Object)C, (Object)D, (Object)E), (Set)ImmutableSet.of((Object)((Object)new TestEdge(A, B, W1)), (Object)((Object)new TestEdge(B, C, W1)), (Object)((Object)new TestEdge(A, D, W1)), (Object)((Object)new TestEdge(D, C, W1)), (Object)((Object)new TestEdge(B, E, W2)), (Object)((Object)new TestEdge(C, E, W1)), (Object[])new TestEdge[0]));
        this.executeSearch((GraphPathSearch<TestVertex, TestEdge>)this.graphSearch(), (Graph<TestVertex, TestEdge>)graph, A, E, (EdgeWeigher<TestVertex, TestEdge>)this.weigher, 1, new TestDoubleWeight(6.0));
    }

    @Test
    public void multiplePathsMultiplePairs() {
        AdjacencyListsGraph graph = new AdjacencyListsGraph((Set)ImmutableSet.of((Object)A, (Object)B, (Object)C, (Object)D, (Object)E), (Set)ImmutableSet.of((Object)((Object)new TestEdge(A, B, W1)), (Object)((Object)new TestEdge(B, E, W1)), (Object)((Object)new TestEdge(A, C, W1)), (Object)((Object)new TestEdge(C, E, W1)), (Object)((Object)new TestEdge(A, D, W1)), (Object)((Object)new TestEdge(D, E, W1)), (Object[])new TestEdge[]{new TestEdge(A, E, W2)}));
        GraphPathSearch.Result result = this.graphSearch().search((Graph)graph, (Vertex)A, (Vertex)E, this.weigher, -1);
        Set paths = result.paths();
        System.out.println("\n\n" + paths + "\n\n\ndone\n");
        Assert.assertEquals((String)"incorrect paths count", (long)3L, (long)paths.size());
        DisjointPathPair dpp = (DisjointPathPair)paths.iterator().next();
        Assert.assertEquals((String)"incorrect disjoint paths per path", (long)2L, (long)dpp.size());
    }

    @Test
    public void differingPrimaryAndBackupPathLengths() {
        AdjacencyListsGraph graph = new AdjacencyListsGraph((Set)ImmutableSet.of((Object)A, (Object)B, (Object)C, (Object)D, (Object)E), (Set)ImmutableSet.of((Object)((Object)new TestEdge(A, B)), (Object)((Object)new TestEdge(B, C)), (Object)((Object)new TestEdge(A, D)), (Object)((Object)new TestEdge(D, C)), (Object)((Object)new TestEdge(B, E)), (Object)((Object)new TestEdge(C, E)), (Object[])new TestEdge[0]));
        this.executeSearch((GraphPathSearch<TestVertex, TestEdge>)this.graphSearch(), (Graph<TestVertex, TestEdge>)graph, A, E, (EdgeWeigher<TestVertex, TestEdge>)this.weigher, 1, new TestDoubleWeight(5.0));
    }

    @Test
    public void onePath() {
        AdjacencyListsGraph graph = new AdjacencyListsGraph((Set)ImmutableSet.of((Object)A, (Object)B, (Object)C, (Object)D), (Set)ImmutableSet.of((Object)((Object)new TestEdge(A, B, W1)), (Object)((Object)new TestEdge(B, C, W1)), (Object)((Object)new TestEdge(A, C, W4)), (Object)((Object)new TestEdge(C, D, W1))));
        GraphPathSearch.Result result = this.graphSearch().search((Graph)graph, (Vertex)A, (Vertex)D, this.weigher, -1);
        Set paths = result.paths();
        Assert.assertEquals((String)"incorrect paths count", (long)1L, (long)paths.size());
        DisjointPathPair dpp = (DisjointPathPair)paths.iterator().next();
        Assert.assertEquals((String)"incorrect disjoint paths count", (long)1L, (long)dpp.size());
    }

    @Test
    public void noPath() {
        AdjacencyListsGraph graph = new AdjacencyListsGraph((Set)ImmutableSet.of((Object)A, (Object)B, (Object)C, (Object)D), (Set)ImmutableSet.of((Object)((Object)new TestEdge(A, B, W1)), (Object)((Object)new TestEdge(B, C, W1)), (Object)((Object)new TestEdge(A, C, W4))));
        GraphPathSearch.Result result = this.graphSearch().search((Graph)graph, (Vertex)A, (Vertex)D, this.weigher, -1);
        Set paths = result.paths();
        Assert.assertEquals((String)"incorrect paths count", (long)paths.size(), (long)0L);
    }

    @Test
    public void disconnected() {
        AdjacencyListsGraph graph = new AdjacencyListsGraph((Set)ImmutableSet.of((Object)A, (Object)B, (Object)C, (Object)D), (Set)ImmutableSet.of());
        GraphPathSearch.Result result = this.graphSearch().search((Graph)graph, (Vertex)A, (Vertex)D, this.weigher, -1);
        Set paths = result.paths();
        Assert.assertEquals((String)"incorrect paths count", (long)0L, (long)paths.size());
    }
}

