/*
 * Decompiled with CFR 0.152.
 */
package org.onlab.graph;

import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.onlab.graph.AdjacencyListsGraph;
import org.onlab.graph.Edge;
import org.onlab.graph.GraphPathSearch;
import org.onlab.graph.GraphTest;
import org.onlab.graph.KShortestPathsSearch;
import org.onlab.graph.Path;
import org.onlab.graph.TestEdge;
import org.onlab.graph.TestVertex;
import org.onlab.graph.Vertex;

public class KShortestPathsSearchTest<V extends Vertex, E extends Edge<V>>
extends GraphTest {
    private KShortestPathsSearch<TestVertex, TestEdge> kShortestPathsSearch = new KShortestPathsSearch();
    private GraphPathSearch.Result<TestVertex, TestEdge> result;

    @Before
    public void setUp() {
        this.graph = new AdjacencyListsGraph(this.vertexes(), this.edges());
    }

    @Test
    public void noPath() {
        this.graph = new AdjacencyListsGraph((Set)ImmutableSet.of((Object)A, (Object)B, (Object)C, (Object)D), (Set)ImmutableSet.of((Object)((Object)new TestEdge(A, B)), (Object)((Object)new TestEdge(B, A)), (Object)((Object)new TestEdge(C, D)), (Object)((Object)new TestEdge(D, C))));
        KShortestPathsSearch kShortestPathsSearch = new KShortestPathsSearch();
        GraphPathSearch.Result result = kShortestPathsSearch.search(this.graph, (Vertex)A, (Vertex)D, this.weigher, 1);
        Set resultPathSet = result.paths();
        Assert.assertTrue((String)"There should not be any paths.", (boolean)resultPathSet.isEmpty());
    }

    @Test
    public void testSinglePath() {
        this.graph = new AdjacencyListsGraph(this.vertexes(), this.edges());
        this.result = this.kShortestPathsSearch.search(this.graph, (Vertex)A, (Vertex)B, this.weigher, 2);
        Iterator itr = this.result.paths().iterator();
        Assert.assertEquals((String)"incorrect paths count", (long)1L, (long)this.result.paths().size());
        ArrayList correctEdgeList = Lists.newArrayList();
        correctEdgeList.add(new TestEdge(A, B, W1));
        Assert.assertTrue((String)"That wrong path was returned.", (boolean)this.edgeListsAreEqual(correctEdgeList, ((Path)this.result.paths().iterator().next()).edges()));
    }

    @Test
    public void testTwoPath() {
        this.result = this.kShortestPathsSearch.search(this.graph, (Vertex)A, (Vertex)C, this.weigher, 3);
        Assert.assertTrue((String)"There are an unexpected number of paths.", (this.result.paths().size() == 2 ? 1 : 0) != 0);
        Iterator edgeListIterator = this.result.paths().iterator();
        ArrayList correctEdgeList = Lists.newArrayList();
        correctEdgeList.add(new TestEdge(A, B, W1));
        correctEdgeList.add(new TestEdge(B, C, W1));
        Assert.assertTrue((String)"The first path from A to C was incorrect.", (boolean)this.edgeListsAreEqual(((Path)edgeListIterator.next()).edges(), correctEdgeList));
        correctEdgeList.clear();
        correctEdgeList.add(new TestEdge(A, C, W3));
        Assert.assertTrue((String)"The second path from A to C was incorrect.", (boolean)this.edgeListsAreEqual(((Path)edgeListIterator.next()).edges(), correctEdgeList));
    }

    @Test
    public void testFourPath() {
        this.result = this.kShortestPathsSearch.search(this.graph, (Vertex)A, (Vertex)E, this.weigher, 5);
        Assert.assertTrue((String)"There are an unexpected number of paths.", (this.result.paths().size() == 4 ? 1 : 0) != 0);
        Iterator edgeListIterator = this.result.paths().iterator();
        ArrayList correctEdgeList = Lists.newArrayList();
        correctEdgeList.add(new TestEdge(A, B, W1));
        correctEdgeList.add(new TestEdge(B, C, W1));
        correctEdgeList.add(new TestEdge(C, E, W1));
        Assert.assertTrue((String)"The first path from A to E was incorrect.", (boolean)this.edgeListsAreEqual(((Path)edgeListIterator.next()).edges(), correctEdgeList));
        correctEdgeList.clear();
        ArrayList alternateCorrectEdgeList = Lists.newArrayList();
        correctEdgeList.add(new TestEdge(A, C, W3));
        correctEdgeList.add(new TestEdge(C, E, W1));
        alternateCorrectEdgeList.add(new TestEdge(A, B, W1));
        alternateCorrectEdgeList.add(new TestEdge(B, D, W2));
        alternateCorrectEdgeList.add(new TestEdge(D, E, W1));
        List candidateOne = ((Path)edgeListIterator.next()).edges();
        List candidateTwo = ((Path)edgeListIterator.next()).edges();
        if (candidateOne.size() == 2) {
            Assert.assertTrue((String)"The second path from A to E was incorrect.", (boolean)this.edgeListsAreEqual(candidateOne, correctEdgeList));
            Assert.assertTrue((String)"The third path from A to E was incorrect.", (boolean)this.edgeListsAreEqual(candidateTwo, alternateCorrectEdgeList));
        } else {
            Assert.assertTrue((String)"The second path from A to E was incorrect.", (boolean)this.edgeListsAreEqual(candidateOne, alternateCorrectEdgeList));
            Assert.assertTrue((String)"The third path from A to E was incorrect.", (boolean)this.edgeListsAreEqual(candidateTwo, correctEdgeList));
        }
        correctEdgeList.clear();
        correctEdgeList.add(new TestEdge(A, B, W1));
        correctEdgeList.add(new TestEdge(B, E, W4));
        Assert.assertTrue((String)"The fourth path rom A to E was incorrect", (boolean)this.edgeListsAreEqual(((Path)edgeListIterator.next()).edges(), correctEdgeList));
    }

    @Test
    public void testPathsFromSink() {
        for (TestVertex vertex : this.vertexes()) {
            Assert.assertTrue((String)"There should be no paths from vertex H to any other node.", (this.kShortestPathsSearch.search(this.graph, (Vertex)H, (Vertex)vertex, this.weigher, 1).paths().size() == 0 ? 1 : 0) != 0);
        }
    }

    @Test
    public void testLimitPathSetSize() {
        this.result = this.kShortestPathsSearch.search(this.graph, (Vertex)A, (Vertex)E, this.weigher, 3);
        Assert.assertTrue((String)"There are an unexpected number of paths.", (this.result.paths().size() == 3 ? 1 : 0) != 0);
        this.result = this.kShortestPathsSearch.search(this.graph, (Vertex)A, (Vertex)G, this.weigher, 1);
        Assert.assertTrue((String)"There are an unexpected number of paths.", (this.result.paths().size() == 1 ? 1 : 0) != 0);
    }

    @Test
    public void testVariableLenPathsWithConstantLinkWeight() {
        this.graph = new AdjacencyListsGraph((Set)ImmutableSet.of((Object)A, (Object)B, (Object)C, (Object)D, (Object)E, (Object)F, (Object[])new TestVertex[]{G, H}), (Set)ImmutableSet.of((Object)((Object)new TestEdge(A, B)), (Object)((Object)new TestEdge(B, A)), (Object)((Object)new TestEdge(B, C)), (Object)((Object)new TestEdge(C, B)), (Object)((Object)new TestEdge(C, D)), (Object)((Object)new TestEdge(D, C)), (Object[])new TestEdge[]{new TestEdge(D, E), new TestEdge(E, D), new TestEdge(E, H), new TestEdge(H, E), new TestEdge(H, G), new TestEdge(G, H), new TestEdge(G, F), new TestEdge(F, G), new TestEdge(F, B), new TestEdge(B, F)}));
        this.result = this.kShortestPathsSearch.search(this.graph, (Vertex)A, (Vertex)G, this.weigher, 5);
        Assert.assertEquals((String)"There are an unexpected number of paths.", (long)2L, (long)this.result.paths().size());
        Iterator edgeListIterator = this.result.paths().iterator();
        ArrayList correctEdgeList = Lists.newArrayList();
        correctEdgeList.add(new TestEdge(A, B));
        correctEdgeList.add(new TestEdge(B, F));
        correctEdgeList.add(new TestEdge(F, G));
        Assert.assertTrue((String)"The first path from A to G was incorrect.", (boolean)this.edgeListsAreEqual(((Path)edgeListIterator.next()).edges(), correctEdgeList));
        correctEdgeList.clear();
        correctEdgeList.add(new TestEdge(A, B));
        correctEdgeList.add(new TestEdge(B, C));
        correctEdgeList.add(new TestEdge(C, D));
        correctEdgeList.add(new TestEdge(D, E));
        correctEdgeList.add(new TestEdge(E, H));
        correctEdgeList.add(new TestEdge(H, G));
        Assert.assertTrue((String)"The second path from A to G was incorrect.", (boolean)this.edgeListsAreEqual(((Path)edgeListIterator.next()).edges(), correctEdgeList));
    }

    private boolean edgeListsAreEqual(List<TestEdge> edgeListOne, List<TestEdge> edgeListTwo) {
        if (edgeListOne.size() != edgeListTwo.size()) {
            return false;
        }
        for (int i = 0; i < edgeListOne.size(); ++i) {
            TestEdge edgeTwo;
            TestEdge edgeOne = edgeListOne.get(i);
            if (edgeOne.equals((Object)(edgeTwo = edgeListTwo.get(i)))) continue;
            return false;
        }
        return true;
    }
}

