/*
 * Decompiled with CFR 0.152.
 */
package org.onlab.packet.ndp;

import java.nio.ByteBuffer;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;
import org.onlab.packet.DeserializationException;
import org.onlab.packet.Deserializer;
import org.onlab.packet.MacAddress;
import org.onlab.packet.PacketTestUtils;
import org.onlab.packet.ndp.NeighborDiscoveryOptions;
import org.onlab.packet.ndp.NeighborSolicitation;

public class NeighborSolicitationTest {
    private static final byte[] TARGET_ADDRESS = new byte[]{32, 1, 15, 24, 1, 19, 2, 21, -54, 42, 20, -1, -2, 53, 38, -50};
    private static final byte[] TARGET_ADDRESS2 = new byte[]{32, 1, 15, 24, 1, 19, 2, 21, -26, -50, -113, -1, -2, 84, 55, -56};
    private static final MacAddress MAC_ADDRESS = MacAddress.valueOf((String)"11:22:33:44:55:66");
    private static byte[] bytePacket;
    private Deserializer<NeighborSolicitation> deserializer = NeighborSolicitation.deserializer();

    @BeforeClass
    public static void setUpBeforeClass() throws Exception {
        byte[] byteHeader = new byte[]{0, 0, 0, 0, 32, 1, 15, 24, 1, 19, 2, 21, -54, 42, 20, -1, -2, 53, 38, -50, 2, 1, 17, 34, 51, 68, 85, 102};
        bytePacket = new byte[byteHeader.length];
        System.arraycopy(byteHeader, 0, bytePacket, 0, byteHeader.length);
    }

    @Test
    public void testSerialize() {
        NeighborSolicitation ns = new NeighborSolicitation();
        ns.setTargetAddress(TARGET_ADDRESS);
        ns.addOption((byte)2, MAC_ADDRESS.toBytes());
        Assert.assertArrayEquals((byte[])ns.serialize(), (byte[])bytePacket);
    }

    @Test
    public void testDeserializeBadInput() throws Exception {
        PacketTestUtils.testDeserializeBadInput(NeighborSolicitation.deserializer());
    }

    @Test
    public void testDeserializeTruncated() throws Exception {
        byte[] nsHeader = new byte[20];
        ByteBuffer.wrap(bytePacket).get(nsHeader);
        PacketTestUtils.testDeserializeTruncated(NeighborSolicitation.deserializer(), nsHeader);
    }

    @Test
    public void testDeserialize() throws DeserializationException {
        NeighborSolicitation ns = (NeighborSolicitation)this.deserializer.deserialize(bytePacket, 0, bytePacket.length);
        Assert.assertArrayEquals((byte[])ns.getTargetAddress(), (byte[])TARGET_ADDRESS);
        Assert.assertThat((Object)ns.getOptions().size(), (Matcher)Matchers.is((Object)1));
        NeighborDiscoveryOptions.Option option = (NeighborDiscoveryOptions.Option)ns.getOptions().get(0);
        Assert.assertThat((Object)option.type(), (Matcher)Matchers.is((Object)2));
        Assert.assertArrayEquals((byte[])option.data(), (byte[])MAC_ADDRESS.toBytes());
    }

    @Test
    public void testEqual() {
        NeighborSolicitation ns1 = new NeighborSolicitation();
        ns1.setTargetAddress(TARGET_ADDRESS);
        ns1.addOption((byte)2, MAC_ADDRESS.toBytes());
        NeighborSolicitation ns2 = new NeighborSolicitation();
        ns2.setTargetAddress(TARGET_ADDRESS2);
        ns2.addOption((byte)2, MAC_ADDRESS.toBytes());
        Assert.assertTrue((boolean)ns1.equals((Object)ns1));
        Assert.assertFalse((boolean)ns1.equals((Object)ns2));
    }

    @Test
    public void testToStringNS() throws Exception {
        NeighborSolicitation ns = (NeighborSolicitation)this.deserializer.deserialize(bytePacket, 0, bytePacket.length);
        String str = ns.toString();
    }
}

