/*
 * Decompiled with CFR 0.152.
 */
package org.onlab.packet.ndp;

import java.nio.ByteBuffer;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;
import org.onlab.packet.DeserializationException;
import org.onlab.packet.Deserializer;
import org.onlab.packet.MacAddress;
import org.onlab.packet.PacketTestUtils;
import org.onlab.packet.ndp.NeighborDiscoveryOptions;
import org.onlab.packet.ndp.Redirect;

public class RedirectTest {
    private static final byte[] TARGET_ADDRESS = new byte[]{32, 1, 15, 24, 1, 19, 2, 21, 0, 0, 0, 0, 0, 0, 0, 0};
    private static final byte[] DESTINATION_ADDRESS = new byte[]{32, 1, 15, 24, 1, 19, 2, 21, -54, 42, 20, -1, -2, 53, 38, -50};
    private static final byte[] DESTINATION_ADDRESS2 = new byte[]{32, 1, 15, 24, 1, 19, 2, 21, -26, -50, -113, -1, -2, 84, 55, -56};
    private static final MacAddress MAC_ADDRESS = MacAddress.valueOf((String)"11:22:33:44:55:66");
    private static byte[] bytePacket;
    private Deserializer<Redirect> deserializer = Redirect.deserializer();

    @BeforeClass
    public static void setUpBeforeClass() throws Exception {
        byte[] byteHeader = new byte[]{0, 0, 0, 0, 32, 1, 15, 24, 1, 19, 2, 21, 0, 0, 0, 0, 0, 0, 0, 0, 32, 1, 15, 24, 1, 19, 2, 21, -54, 42, 20, -1, -2, 53, 38, -50, 2, 1, 17, 34, 51, 68, 85, 102};
        bytePacket = new byte[byteHeader.length];
        System.arraycopy(byteHeader, 0, bytePacket, 0, byteHeader.length);
    }

    @Test
    public void testSerialize() {
        Redirect rd = new Redirect();
        rd.setTargetAddress(TARGET_ADDRESS);
        rd.setDestinationAddress(DESTINATION_ADDRESS);
        rd.addOption((byte)2, MAC_ADDRESS.toBytes());
        Assert.assertArrayEquals((byte[])rd.serialize(), (byte[])bytePacket);
    }

    @Test
    public void testDeserializeBadInput() throws Exception {
        PacketTestUtils.testDeserializeBadInput(Redirect.deserializer());
    }

    @Test
    public void testDeserializeTruncated() throws Exception {
        byte[] rdHeader = new byte[36];
        ByteBuffer.wrap(bytePacket).get(rdHeader);
        PacketTestUtils.testDeserializeTruncated(Redirect.deserializer(), rdHeader);
    }

    @Test
    public void testDeserialize() throws DeserializationException {
        Redirect rd = (Redirect)this.deserializer.deserialize(bytePacket, 0, bytePacket.length);
        Assert.assertArrayEquals((byte[])rd.getTargetAddress(), (byte[])TARGET_ADDRESS);
        Assert.assertArrayEquals((byte[])rd.getDestinationAddress(), (byte[])DESTINATION_ADDRESS);
        Assert.assertThat((Object)rd.getOptions().size(), (Matcher)Matchers.is((Object)1));
        NeighborDiscoveryOptions.Option option = (NeighborDiscoveryOptions.Option)rd.getOptions().get(0);
        Assert.assertThat((Object)option.type(), (Matcher)Matchers.is((Object)2));
        Assert.assertArrayEquals((byte[])option.data(), (byte[])MAC_ADDRESS.toBytes());
    }

    @Test
    public void testEqual() {
        Redirect rd1 = new Redirect();
        rd1.setTargetAddress(TARGET_ADDRESS);
        rd1.setDestinationAddress(DESTINATION_ADDRESS);
        rd1.addOption((byte)2, MAC_ADDRESS.toBytes());
        Redirect rd2 = new Redirect();
        rd2.setTargetAddress(TARGET_ADDRESS);
        rd2.setDestinationAddress(DESTINATION_ADDRESS2);
        rd2.addOption((byte)2, MAC_ADDRESS.toBytes());
        Assert.assertTrue((boolean)rd1.equals((Object)rd1));
        Assert.assertFalse((boolean)rd1.equals((Object)rd2));
    }

    @Test
    public void testToStringRedirect() throws Exception {
        Redirect rd = (Redirect)this.deserializer.deserialize(bytePacket, 0, bytePacket.length);
        String str = rd.toString();
    }
}

