/*
 * Decompiled with CFR 0.152.
 */
package org.onlab.graph;

import com.google.common.base.MoreObjects;
import com.google.common.math.DoubleMath;
import java.util.Objects;
import org.onlab.graph.Weight;

public class ScalarWeight
implements Weight {
    public static final ScalarWeight NON_VIABLE_WEIGHT = new ScalarWeight(Double.POSITIVE_INFINITY);
    private static double samenessThreshold = Double.MIN_VALUE;
    private double value;

    public ScalarWeight(double value) {
        this.value = value;
    }

    @Override
    public Weight merge(Weight otherWeight) {
        return new ScalarWeight(this.value + ((ScalarWeight)otherWeight).value);
    }

    @Override
    public Weight subtract(Weight otherWeight) {
        return new ScalarWeight(this.value - ((ScalarWeight)otherWeight).value);
    }

    @Override
    public boolean isViable() {
        return this != NON_VIABLE_WEIGHT;
    }

    @Override
    public int compareTo(Weight otherWeight) {
        if (this.equals(otherWeight)) {
            return 0;
        }
        return Double.compare(this.value, ((ScalarWeight)otherWeight).value);
    }

    public boolean equals(Object obj) {
        return obj instanceof ScalarWeight && DoubleMath.fuzzyEquals((double)this.value, (double)((ScalarWeight)obj).value, (double)samenessThreshold);
    }

    public int hashCode() {
        return Objects.hash(this.value);
    }

    @Override
    public boolean isNegative() {
        return this.value < 0.0;
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("value", this.value).toString();
    }

    public double value() {
        return this.value;
    }

    public static void setSamenessThreshold(double threshold) {
        samenessThreshold = threshold;
    }

    public static double samenessThreshold() {
        return samenessThreshold;
    }
}

