/*
 * Decompiled with CFR 0.152.
 */
package org.onlab.packet.ndp;

import com.google.common.base.MoreObjects;
import java.nio.ByteBuffer;
import java.util.Arrays;
import java.util.List;
import org.onlab.packet.BasePacket;
import org.onlab.packet.Deserializer;
import org.onlab.packet.IPacket;
import org.onlab.packet.PacketUtils;
import org.onlab.packet.ndp.NeighborDiscoveryOptions;

public class Redirect
extends BasePacket {
    public static final byte HEADER_LENGTH = 36;
    protected byte[] targetAddress = new byte[16];
    protected byte[] destinationAddress = new byte[16];
    private final NeighborDiscoveryOptions options = new NeighborDiscoveryOptions();

    public byte[] getTargetAddress() {
        return this.targetAddress;
    }

    public Redirect setTargetAddress(byte[] targetAddress) {
        this.targetAddress = Arrays.copyOfRange(targetAddress, 0, 16);
        return this;
    }

    public byte[] getDestinationAddress() {
        return this.destinationAddress;
    }

    public Redirect setDestinationAddress(byte[] destinationAddress) {
        this.destinationAddress = Arrays.copyOfRange(destinationAddress, 0, 16);
        return this;
    }

    public List<NeighborDiscoveryOptions.Option> getOptions() {
        return this.options.options();
    }

    public Redirect addOption(byte type, byte[] data) {
        this.options.addOption(type, data);
        return this;
    }

    @Override
    public byte[] serialize() {
        byte[] optionsData = null;
        if (this.options.hasOptions()) {
            optionsData = this.options.serialize();
        }
        int optionsLength = 0;
        if (optionsData != null) {
            optionsLength = optionsData.length;
        }
        byte[] data = new byte[36 + optionsLength];
        ByteBuffer bb = ByteBuffer.wrap(data);
        bb.putInt(0);
        bb.put(this.targetAddress, 0, 16);
        bb.put(this.destinationAddress, 0, 16);
        if (optionsData != null) {
            bb.put(optionsData);
        }
        return data;
    }

    @Override
    public IPacket deserialize(byte[] data, int offset, int length) {
        ByteBuffer bb = ByteBuffer.wrap(data, offset, length);
        bb.getInt();
        bb.get(this.targetAddress, 0, 16);
        bb.get(this.destinationAddress, 0, 16);
        this.options.deserialize(data, bb.position(), bb.limit() - bb.position());
        return this;
    }

    @Override
    public int hashCode() {
        int i;
        int prime = 5807;
        int result = super.hashCode();
        ByteBuffer bb = ByteBuffer.wrap(this.targetAddress);
        for (i = 0; i < this.targetAddress.length / 4; ++i) {
            result = 5807 * result + bb.getInt();
        }
        bb = ByteBuffer.wrap(this.destinationAddress);
        for (i = 0; i < this.destinationAddress.length / 4; ++i) {
            result = 5807 * result + bb.getInt();
        }
        result = 5807 * result + this.options.hashCode();
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        if (!(obj instanceof Redirect)) {
            return false;
        }
        Redirect other = (Redirect)obj;
        if (!Arrays.equals(this.targetAddress, other.targetAddress)) {
            return false;
        }
        if (!Arrays.equals(this.destinationAddress, other.destinationAddress)) {
            return false;
        }
        return this.options.equals(other.options);
    }

    public static Deserializer<Redirect> deserializer() {
        return (data, offset, length) -> {
            PacketUtils.checkInput(data, offset, length, 36);
            Redirect redirect = new Redirect();
            ByteBuffer bb = ByteBuffer.wrap(data, offset, length);
            bb.getInt();
            bb.get(redirect.targetAddress, 0, 16);
            bb.get(redirect.destinationAddress, 0, 16);
            if (bb.limit() - bb.position() > 0) {
                NeighborDiscoveryOptions options = NeighborDiscoveryOptions.deserializer().deserialize(data, bb.position(), bb.limit() - bb.position());
                for (NeighborDiscoveryOptions.Option option : options.options()) {
                    redirect.addOption(option.type(), option.data());
                }
            }
            return redirect;
        };
    }

    public String toString() {
        return MoreObjects.toStringHelper(this.getClass()).add("targetAddress", (Object)Arrays.toString(this.targetAddress)).add("destinationAddress", (Object)Arrays.toString(this.destinationAddress)).toString();
    }
}

