/*
 * Decompiled with CFR 0.152.
 */
package org.onlab.packet;

import java.nio.ByteBuffer;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.onlab.packet.DeserializationException;
import org.onlab.packet.Deserializer;
import org.onlab.packet.Ethernet;
import org.onlab.packet.MacAddress;
import org.onlab.packet.PacketTestUtils;

public class EthernetTest {
    private MacAddress dstMac;
    private MacAddress srcMac;
    private short ethertype = (short)6;
    private short vlan = (short)5;
    private Deserializer<Ethernet> deserializer;
    private byte[] byteHeader;
    private byte[] vlanByteHeader;

    @Before
    public void setUp() {
        this.deserializer = Ethernet.deserializer();
        byte[] dstMacBytes = new byte[]{-120, -120, -120, -120, -120, -120};
        this.dstMac = MacAddress.valueOf((byte[])dstMacBytes);
        byte[] srcMacBytes = new byte[]{-86, -86, -86, -86, -86, -86};
        this.srcMac = MacAddress.valueOf((byte[])srcMacBytes);
        ByteBuffer bb = ByteBuffer.allocate(14);
        bb.put(dstMacBytes);
        bb.put(srcMacBytes);
        bb.putShort(this.ethertype);
        this.byteHeader = bb.array();
        bb = ByteBuffer.allocate(18);
        bb.put(dstMacBytes);
        bb.put(srcMacBytes);
        bb.putShort(Ethernet.TYPE_VLAN);
        bb.putShort(this.vlan);
        bb.putShort(this.ethertype);
        this.vlanByteHeader = bb.array();
    }

    @Test
    public void testDeserializeBadInput() throws Exception {
        PacketTestUtils.testDeserializeBadInput(this.deserializer);
    }

    @Test
    public void testDeserializeTruncated() throws DeserializationException {
        PacketTestUtils.testDeserializeTruncated(this.deserializer, this.vlanByteHeader);
    }

    @Test
    public void testDeserializeNoVlan() throws Exception {
        Ethernet eth = (Ethernet)this.deserializer.deserialize(this.byteHeader, 0, this.byteHeader.length);
        Assert.assertEquals((Object)this.dstMac, (Object)eth.getDestinationMAC());
        Assert.assertEquals((Object)this.srcMac, (Object)eth.getSourceMAC());
        Assert.assertEquals((long)-1L, (long)eth.getVlanID());
        Assert.assertEquals((long)this.ethertype, (long)eth.getEtherType());
    }

    @Test
    public void testDeserializeWithVlan() throws Exception {
        Ethernet eth = (Ethernet)this.deserializer.deserialize(this.vlanByteHeader, 0, this.vlanByteHeader.length);
        Assert.assertEquals((Object)this.dstMac, (Object)eth.getDestinationMAC());
        Assert.assertEquals((Object)this.srcMac, (Object)eth.getSourceMAC());
        Assert.assertEquals((long)this.vlan, (long)eth.getVlanID());
        Assert.assertEquals((long)this.ethertype, (long)eth.getEtherType());
    }
}

